/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict;

import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.uict.FuncTypeEnum;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public class FunctionRes {
    private static final String FUNC_NAME = "name";
    private static final String FUNC_FORMULA = "formula";
    private static final String FUNC_DESCRIPION = "description";
    private static final char PONIT = '.';
    private static FunctionRes instance = null;
    private ResourceBundleHelper resHelper = new ResourceBundleHelper(FunctionRes.class.getName());
    private Map typeFuncMap = null;

    private FunctionRes() {
        this.initFuncMap();
    }

    public Vector getFuncNameVector(String funcTypeName) {
        return (Vector)((Map)this.typeFuncMap.get(funcTypeName)).get(FUNC_NAME);
    }

    public Vector getFuncFormulaVector(String funcTypeName) {
        return (Vector)((Map)this.typeFuncMap.get(funcTypeName)).get(FUNC_FORMULA);
    }

    public Vector getFuncDescriptionVector(String funcTypeName) {
        return (Vector)((Map)this.typeFuncMap.get(funcTypeName)).get(FUNC_DESCRIPION);
    }

    private void initFuncMap() {
        this.typeFuncMap = new HashMap();
        Map funcTypes = FuncTypeEnum.getEnumMap();
        Object[] funcTypeArray = funcTypes.keySet().toArray();
        ResourceBundle resourceBoundle = this.resHelper.getResourceBundle();
        Enumeration<String> propEnum = resourceBoundle.getKeys();
        String typeName = null;
        Vector nameVector = null;
        Vector formulaVector = null;
        Vector descriptionVector = null;
        String prefix = null;
        while (propEnum.hasMoreElements()) {
            HashMap allFuncMap;
            String propKey = propEnum.nextElement();
            if (!propKey.endsWith(FUNC_NAME)) continue;
            int m = funcTypeArray.length;
            for (int i = 0; i < m; ++i) {
                typeName = (String)funcTypeArray[i];
                if (FuncTypeEnum.ALL_FUNC.getName().equals(typeName) || !propKey.startsWith(typeName)) continue;
                HashMap subMap = (HashMap)this.typeFuncMap.get(typeName);
                if (subMap == null) {
                    subMap = new HashMap();
                    this.typeFuncMap.put(typeName, subMap);
                }
                nameVector = this.getVector(FUNC_NAME, subMap);
                formulaVector = this.getVector(FUNC_FORMULA, subMap);
                descriptionVector = this.getVector(FUNC_DESCRIPION, subMap);
                nameVector.add(resourceBoundle.getString(propKey));
                prefix = propKey.substring(0, propKey.lastIndexOf(46) + 1);
                formulaVector.add(resourceBoundle.getString(prefix + FUNC_FORMULA));
                descriptionVector.add(resourceBoundle.getString(prefix + FUNC_DESCRIPION));
                break;
            }
            if ((allFuncMap = (HashMap)this.typeFuncMap.get(FuncTypeEnum.ALL_FUNC.getName())) == null) {
                allFuncMap = new HashMap();
                this.typeFuncMap.put(FuncTypeEnum.ALL_FUNC.getName(), allFuncMap);
            }
            nameVector = this.getVector(FUNC_NAME, allFuncMap);
            formulaVector = this.getVector(FUNC_FORMULA, allFuncMap);
            descriptionVector = this.getVector(FUNC_DESCRIPION, allFuncMap);
            nameVector.add(resourceBoundle.getString(propKey));
            prefix = propKey.substring(0, propKey.lastIndexOf(46) + 1);
            formulaVector.add(resourceBoundle.getString(prefix + FUNC_FORMULA));
            descriptionVector.add(resourceBoundle.getString(prefix + FUNC_DESCRIPION));
        }
    }

    private Vector getVector(String name, Map aMap) {
        Vector aVector = (Vector)aMap.get(name);
        if (aVector == null) {
            aVector = new Vector();
            aMap.put(name, aVector);
        }
        return aVector;
    }

    public static FunctionRes getInstance() {
        if (instance == null) {
            instance = new FunctionRes();
        }
        return instance;
    }

    public static void main(String[] args) {
        FunctionRes.getInstance();
    }
}

