/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientTool {
    protected static Log log = LogFactory.getLog(HttpClientTool.class);

    public static String httpPost(HttpClient client, String url) {
        return HttpClientTool.httpPost(client, url, null);
    }

    public static String httpPost(HttpClient client, String url, Map paramMap) {
        String result = "";
        NameValuePair[] data = HttpClientTool.getNameValuePair(paramMap);
        String charSet = "UTF-8";
        result = HttpClientTool.httpPost(client, url, data, charSet, charSet);
        return result;
    }

    public static NameValuePair[] getNameValuePair(Map paramMap) {
        Object[] keys;
        NameValuePair[] data = null;
        if (null != paramMap && null != (keys = paramMap.keySet().toArray()) && keys.length > 0) {
            data = new NameValuePair[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String clumnName = (String)keys[i];
                Object value = paramMap.get(clumnName);
                data[i] = new NameValuePair(clumnName, String.valueOf(value));
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(HttpClient client, String url, NameValuePair[] data, String paramsCharSet, String responseCharSet) {
        String result = "";
        PostMethod post = new PostMethod(url);
        if (null == paramsCharSet || "".equals(paramsCharSet)) {
            paramsCharSet = "UTF-8";
        }
        if (null == responseCharSet || "".equals(responseCharSet)) {
            responseCharSet = "UTF-8";
        }
        post.getParams().setParameter("http.protocol.content-charset", (Object)paramsCharSet);
        post.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        if (null != data) {
            post.setQueryString(data);
        }
        InputStream in = null;
        try {
            int httpStatus = client.executeMethod((HttpMethod)post);
            if (httpStatus == 200) {
                in = post.getResponseBodyAsStream();
                result = HttpClientTool.inputStream2String(in, responseCharSet);
            }
        }
        catch (Exception e) {
            log.error((Object)"HttpClient\u5ba2\u6237\u7aef\u8bf7\u6c42\u5904\u7406,\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                post.releaseConnection();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(HttpClient client, String url, String data, String paramsCharSet, String responseCharSet) {
        String result = "";
        PostMethod post = new PostMethod(url);
        if (null == paramsCharSet || "".equals(paramsCharSet)) {
            paramsCharSet = "UTF-8";
        }
        if (null == responseCharSet || "".equals(responseCharSet)) {
            responseCharSet = "UTF-8";
        }
        post.getParams().setParameter("http.protocol.content-charset", (Object)paramsCharSet);
        post.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        if (null != data) {
            post.setQueryString(data);
        }
        InputStream in = null;
        try {
            int httpStatus = client.executeMethod((HttpMethod)post);
            if (httpStatus == 200) {
                in = post.getResponseBodyAsStream();
                result = HttpClientTool.inputStream2String(in, responseCharSet);
            }
        }
        catch (Exception e) {
            log.error((Object)"HttpClient\u5ba2\u6237\u7aef\u8bf7\u6c42\u5904\u7406,\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                post.releaseConnection();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public static Map httpPost(String url, Map paramMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        client.getHttpConnectionManager().getParams().setSoTimeout(60000);
        String resStr = HttpClientTool.httpPost(client, url, paramMap);
        result.put("HTTP_CLIENT_USER_TAG", client);
        result.put("HTTP_CLIENT_USER_RESULT", resStr);
        return result;
    }

    public static String inputStream2String(InputStream is, String charSet) throws Exception {
        try {
            InputStreamReader reader = new InputStreamReader(is, charSet);
            BufferedReader in = new BufferedReader(reader);
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while (line != null) {
                if ((line = line.trim()).length() != 0) {
                    buffer.append(line);
                }
                line = in.readLine();
            }
            return buffer.toString();
        }
        catch (Exception e) {
            log.error((Object)"\u5c06InputStream\u6d41\u8f6c\u5316\u4e3a\u5b57\u7b26\u4e32\uff0c\u5931\u8d25\uff01", (Throwable)e);
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostFile(HttpClient client, String url, Map params, String paramsCharSet, String responseCharSet, File file) {
        String result = "";
        NameValuePair[] data = HttpClientTool.getNameValuePair(params);
        PostMethod post = new PostMethod(url);
        if (null == paramsCharSet || "".equals(paramsCharSet)) {
            paramsCharSet = "UTF-8";
        }
        if (null == responseCharSet || "".equals(responseCharSet)) {
            responseCharSet = "UTF-8";
        }
        post.getParams().setParameter("http.protocol.content-charset", (Object)paramsCharSet);
        post.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        if (null != data) {
            post.setQueryString(data);
        }
        InputStream in = null;
        try {
            Part[] parts = new Part[]{new FilePart("upload", file)};
            post.addParameters(data);
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            int httpStatus = client.executeMethod((HttpMethod)post);
            if (httpStatus == 200) {
                in = post.getResponseBodyAsStream();
                result = HttpClientTool.inputStream2String(in, responseCharSet);
            }
        }
        catch (Exception e) {
            log.error((Object)"HttpClient\u5ba2\u6237\u7aef\u8bf7\u6c42\u5904\u7406,\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                post.releaseConnection();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return result;
    }
}

