/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.Activity;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Feed
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4797674664272323011L;
    public String targetId;
    public String category;
    public String title;
    public String digest;
    public String conversationState;
    public int unread;
    public Date createDate;
    public long itemCount;
    public long subscriberCount;
    public String tagKey;
    public long participantCount;
    public List<String> userList;
    public List<Activity> activityList;

    Feed(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONArray atcivityListJsonArr;
            JSONObject meta;
            this.targetId = json.getString("feedSource");
            this.title = json.getString("title");
            this.unread = json.getInt("unread");
            this.tagKey = json.getString("tagKey");
            this.createDate = new Date(json.getLong("createDate"));
            JSONObject statisticsJson = json.getJSONObject("statistics");
            if (statisticsJson != null) {
                this.itemCount = statisticsJson.getLong("itemCount");
                this.subscriberCount = statisticsJson.getLong("subscriberCount");
                this.participantCount = statisticsJson.getLong("participantCount");
            }
            if ((meta = json.getJSONObject("metas")) != null) {
                this.category = meta.getString("category");
                this.conversationState = meta.getString("conversationState");
            }
            if (json.get("activityList") instanceof JSONArray && (atcivityListJsonArr = json.getJSONArray("activityList")) != null) {
                ArrayList<Activity> list = new ArrayList<Activity>();
                int length = atcivityListJsonArr.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject activityJson = atcivityListJsonArr.getJSONObject(i);
                    if (activityJson == null) continue;
                    Activity act = new Activity(activityJson);
                    list.add(act);
                }
                this.activityList = list;
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    Feed(JSONObject json) throws WeiboException {
        try {
            JSONArray atcivityListJsonArr;
            JSONObject meta;
            this.targetId = json.getString("feedSource");
            this.title = json.getString("title");
            this.unread = json.getInt("unread");
            this.tagKey = json.getString("tagKey");
            this.createDate = new Date(json.getLong("createDate"));
            JSONObject statisticsJson = json.getJSONObject("statistics");
            if (statisticsJson != null) {
                this.itemCount = statisticsJson.getLong("itemCount");
                this.subscriberCount = statisticsJson.getLong("subscriberCount");
                this.participantCount = statisticsJson.getLong("participantCount");
            }
            if ((meta = json.getJSONObject("metas")) != null) {
                this.category = meta.getString("category");
                this.conversationState = meta.getString("conversationState");
            }
            if (json.get("activityList") instanceof JSONArray && (atcivityListJsonArr = json.getJSONArray("activityList")) != null) {
                ArrayList<Activity> list = new ArrayList<Activity>();
                int length = atcivityListJsonArr.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject activityJson = atcivityListJsonArr.getJSONObject(i);
                    if (activityJson == null) continue;
                    Activity act = new Activity(activityJson);
                    list.add(act);
                }
                this.activityList = list;
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    static List<Feed> constructList(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<Feed> feeds = new ArrayList<Feed>(size);
            for (int i = 0; i < size; ++i) {
                feeds.add(new Feed(list.getJSONObject(i)));
            }
            return feeds;
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + list.toString(), je);
        }
    }
}

