/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weibo4j.DirectMessage;
import weibo4j.UserWapper;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class User
extends WeiboResponse
implements Serializable {
    static final String[] POSSIBLE_ROOT_NAMES = new String[]{"user", "sender", "recipient", "retweeting_user"};
    private Weibo weibo;
    private String id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Date statusCreatedAt;
    private String statusId = null;
    private String statusText = null;
    private String statusSource = null;
    private boolean statusTruncated = false;
    private String statusInReplyToStatusId = null;
    private String statusInReplyToUserId = null;
    private boolean statusFavorited = false;
    private String statusInReplyToScreenName = null;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private String profileBackgroundTile;
    private boolean following;
    private boolean notificationEnabled;
    private int statusesCount;
    private boolean geoEnabled;
    private boolean verified;
    private boolean admin;
    private static final long serialVersionUID = -6345893237975349030L;
    public String companyId;
    public String companyName;
    public boolean publicUser;

    User(Response res, Weibo weibo) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(elem, weibo);
    }

    User(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(elem, weibo);
    }

    User(JSONObject json) throws WeiboException {
        this.init(json);
    }

    private void init(JSONObject json) throws WeiboException {
        if (json != null) {
            try {
                this.id = json.getString("id");
                this.name = json.getString("name");
                this.screenName = json.getString("screen_name");
                this.location = json.getString("location");
                this.description = json.getString("description");
                this.profileImageUrl = json.getString("profile_image_url");
                this.url = json.getString("url");
                this.isProtected = json.getBoolean("protected");
                this.followersCount = json.getInt("followers_count");
                this.admin = json.getBoolean("admin");
                this.companyId = json.getString("companyId");
                this.companyName = json.getString("companyName");
                this.publicUser = json.getBoolean("publicUser");
                this.profileBackgroundColor = json.getString("profile_background_color");
                this.profileTextColor = json.getString("profile_text_color");
                this.profileLinkColor = json.getString("profile_link_color");
                this.profileSidebarFillColor = json.getString("profile_sidebar_fill_color");
                this.profileSidebarBorderColor = json.getString("profile_sidebar_border_color");
                this.friendsCount = json.getInt("friends_count");
                this.createdAt = User.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.favouritesCount = json.getInt("favourites_count");
                this.utcOffset = User.getInt("utc_offset", json);
                this.timeZone = json.getString("time_zone");
                this.profileBackgroundImageUrl = json.getString("profile_background_image_url");
                this.profileBackgroundTile = json.getString("profile_background_tile");
                this.following = User.getBoolean("following", json);
                this.notificationEnabled = User.getBoolean("notifications", json);
                this.statusesCount = json.getInt("statuses_count");
                if (!json.isNull("status")) {
                    JSONObject status = json.getJSONObject("status");
                    this.statusCreatedAt = User.parseDate(status.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                    this.statusId = status.getString("id");
                    this.statusText = status.getString("text");
                    this.statusSource = status.getString("source");
                    this.statusTruncated = status.getBoolean("truncated");
                    this.statusInReplyToStatusId = status.getString("in_reply_to_status_id");
                    this.statusInReplyToUserId = status.getString("in_reply_to_user_id");
                    this.statusFavorited = status.getBoolean("favorited");
                    this.statusInReplyToScreenName = status.getString("in_reply_to_screen_name");
                }
            }
            catch (JSONException jsone) {
                throw new WeiboException(jsone.getMessage() + ":" + json.toString(), jsone);
            }
        }
    }

    private void init(Element elem, Weibo weibo) throws WeiboException {
        this.weibo = weibo;
        User.ensureRootNodeNameIs(POSSIBLE_ROOT_NAMES, elem);
        this.id = User.getChildText("id", elem);
        this.name = User.getChildText("name", elem);
        this.screenName = User.getChildText("screen_name", elem);
        this.location = User.getChildText("location", elem);
        this.description = User.getChildText("description", elem);
        this.profileImageUrl = User.getChildText("profile_image_url", elem);
        this.url = User.getChildText("url", elem);
        this.isProtected = User.getChildBoolean("protected", elem);
        this.followersCount = User.getChildInt("followers_count", elem);
        this.profileBackgroundColor = User.getChildText("profile_background_color", elem);
        this.profileTextColor = User.getChildText("profile_text_color", elem);
        this.profileLinkColor = User.getChildText("profile_link_color", elem);
        this.profileSidebarFillColor = User.getChildText("profile_sidebar_fill_color", elem);
        this.profileSidebarBorderColor = User.getChildText("profile_sidebar_border_color", elem);
        this.friendsCount = User.getChildInt("friends_count", elem);
        this.createdAt = User.getChildDate("created_at", elem);
        this.favouritesCount = User.getChildInt("favourites_count", elem);
        this.utcOffset = User.getChildInt("utc_offset", elem);
        this.timeZone = User.getChildText("time_zone", elem);
        this.profileBackgroundImageUrl = User.getChildText("profile_background_image_url", elem);
        this.profileBackgroundTile = User.getChildText("profile_background_tile", elem);
        this.following = User.getChildBoolean("following", elem);
        this.notificationEnabled = User.getChildBoolean("notifications", elem);
        this.statusesCount = User.getChildInt("statuses_count", elem);
        this.geoEnabled = User.getChildBoolean("geo_enabled", elem);
        this.verified = User.getChildBoolean("verified", elem);
        NodeList statuses = elem.getElementsByTagName("status");
        if (statuses.getLength() != 0) {
            Element status = (Element)statuses.item(0);
            this.statusCreatedAt = User.getChildDate("created_at", status);
            this.statusId = User.getChildText("id", status);
            this.statusText = User.getChildText("text", status);
            this.statusSource = User.getChildText("source", status);
            this.statusTruncated = User.getChildBoolean("truncated", status);
            this.statusInReplyToStatusId = User.getChildText("in_reply_to_status_id", status);
            this.statusInReplyToUserId = User.getChildText("in_reply_to_user_id", status);
            this.statusFavorited = User.getChildBoolean("favorited", status);
            this.statusInReplyToScreenName = User.getChildText("in_reply_to_screen_name", status);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public DirectMessage sendDirectMessage(String text) throws WeiboException {
        return this.weibo.sendDirectMessage(this.getName(), text);
    }

    public static List<User> constructUser(Response res) throws WeiboException {
        JSONObject json = res.asJSONObject();
        try {
            JSONArray list = json.getJSONArray("users");
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException je) {
            throw new WeiboException(je);
        }
    }

    public static List<User> constructUsers(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (User.isRootNodeNilClasses(doc)) {
            return new ArrayList<User>(0);
        }
        try {
            User.ensureRootNodeNameIs("users", doc);
            NodeList list = doc.getDocumentElement().getChildNodes();
            ArrayList<User> users = new ArrayList<User>(list.getLength());
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getNodeName().equals("user")) continue;
                users.add(new User(res, (Element)node, weibo));
            }
            return users;
        }
        catch (WeiboException te) {
            if (User.isRootNodeNilClasses(doc)) {
                return new ArrayList<User>(0);
            }
            throw te;
        }
    }

    public static UserWapper constructWapperUsers(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (User.isRootNodeNilClasses(doc)) {
            return new UserWapper(new ArrayList<User>(0), 0L, 0L);
        }
        try {
            User.ensureRootNodeNameIs("users_list", doc);
            Element root = doc.getDocumentElement();
            NodeList user = root.getElementsByTagName("users");
            int length = user.getLength();
            if (length == 0) {
                return new UserWapper(new ArrayList<User>(0), 0L, 0L);
            }
            Element listsRoot = (Element)user.item(0);
            NodeList list = listsRoot.getChildNodes();
            ArrayList<User> users = new ArrayList<User>(list.getLength());
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getNodeName().equals("user")) continue;
                users.add(new User(res, (Element)node, weibo));
            }
            long previousCursor = User.getChildLong("previous_curosr", root);
            long nextCursor = User.getChildLong("next_curosr", root);
            if (nextCursor == -1L) {
                nextCursor = User.getChildLong("nextCurosr", root);
            }
            return new UserWapper(users, previousCursor, nextCursor);
        }
        catch (WeiboException te) {
            if (User.isRootNodeNilClasses(doc)) {
                return new UserWapper(new ArrayList<User>(0), 0L, 0L);
            }
            throw te;
        }
    }

    public static List<User> constructUsers(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public static UserWapper constructWapperUsers(Response res) throws WeiboException {
        JSONObject jsonUsers = res.asJSONObject();
        try {
            JSONArray user = jsonUsers.getJSONArray("users");
            int size = user.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(user.getJSONObject(i)));
            }
            long previousCursor = jsonUsers.getLong("previous_curosr");
            long nextCursor = jsonUsers.getLong("next_cursor");
            if (nextCursor == -1L) {
                nextCursor = jsonUsers.getLong("nextCursor");
            }
            return new UserWapper(users, previousCursor, nextCursor);
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    static List<User> constructResult(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Date getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getStatusSource() {
        return this.statusSource;
    }

    public boolean isStatusTruncated() {
        return this.statusTruncated;
    }

    public String getStatusInReplyToStatusId() {
        return this.statusInReplyToStatusId;
    }

    public String getStatusInReplyToUserId() {
        return this.statusInReplyToUserId;
    }

    public boolean isStatusFavorited() {
        return this.statusFavorited;
    }

    public String getStatusInReplyToScreenName() {
        return null == this.statusInReplyToUserId ? this.statusInReplyToScreenName : null;
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    public String getProfileBackgroundTile() {
        return this.profileBackgroundTile;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public boolean isNotifications() {
        return this.notificationEnabled;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public boolean isGeoEnabled() {
        return this.geoEnabled;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).id == this.id;
    }

    public String toString() {
        return "User{weibo=" + this.weibo + ", id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", location='" + this.location + '\'' + ", description='" + this.description + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", url='" + this.url + '\'' + ", isProtected=" + this.isProtected + ", followersCount=" + this.followersCount + ", statusCreatedAt=" + this.statusCreatedAt + ", statusId=" + this.statusId + ", statusText='" + this.statusText + '\'' + ", statusSource='" + this.statusSource + '\'' + ", statusTruncated=" + this.statusTruncated + ", statusInReplyToStatusId=" + this.statusInReplyToStatusId + ", statusInReplyToUserId=" + this.statusInReplyToUserId + ", statusFavorited=" + this.statusFavorited + ", statusInReplyToScreenName='" + this.statusInReplyToScreenName + '\'' + ", profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundTile='" + this.profileBackgroundTile + '\'' + ", following=" + this.following + ", notificationEnabled=" + this.notificationEnabled + ", statusesCount=" + this.statusesCount + ", geoEnabled=" + this.geoEnabled + ", verified=" + this.verified + ", admin=" + this.admin + '}';
    }

    public boolean isAdmin() {
        return this.admin;
    }
}

