/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.notice.api;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.base.wssc.app.notice.api.AbstractMessage;
import com.kingdee.eas.base.wssc.app.notice.api.ITalkTransfer;
import com.kingdee.eas.base.wssc.util.common.HttpClientUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;

public abstract class AbstractTransfer
implements ITalkTransfer {
    private static Logger logger = Logger.getLogger(AbstractTransfer.class);
    private String response = null;
    private boolean status = false;
    private AbstractMessage message = null;

    public AbstractTransfer(AbstractMessage message) {
        this.message = message;
    }

    @Override
    public String pushMessage() {
        if (this.message != null && this.message.hasReady()) {
            this.status = false;
            HttpClient http = new HttpClient();
            http.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            http.getHttpConnectionManager().getParams().setSoTimeout(60000);
            String url = this.getConnectServerURL();
            try {
                this.response = HttpClientUtil.doPost(url, JSON.toJSONString(this.message.getContent()), "UTF-8");
                if (this.response.contains("pubId") && this.response.contains("sourceMsgId")) {
                    this.status = true;
                }
            }
            catch (Throwable var4) {
                logger.error((Object)"error message", var4);
                this.status = false;
                this.response = var4.getMessage() + "";
            }
        } else {
            this.status = false;
            this.response = this.message == null ? "message object was not initialized" : "message object was not ready";
        }
        return this.response;
    }

    @Override
    public boolean isSucceed() {
        return this.status;
    }

    public void setMessage(AbstractMessage message) {
        this.message = message;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    protected abstract String getConnectServerURL();

    protected abstract String getConnectContentType();
}

