/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.sscLogin;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WSSOLoginUtil {
    private static Logger logger = Logger.getLogger(WSSOLoginUtil.class);
    public static String LTPATOKEN_PATH = "eas/LtpaToken.properties";
    public static String CONFIG_DIR;

    public static String getSSOLonginURL(Context ctx, String sscNumber) throws UnsupportedEncodingException {
        logger.error((Object)("*****sscNumber****" + sscNumber.toString()));
        String username = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "userName");
        String dominoSecret = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "dominoSecret");
        logger.error((Object)("*****dominoSecret****" + dominoSecret.toString()));
        String tokenExpiration = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "tokenExpiration");
        logger.error((Object)("*****tokenExpiration****" + tokenExpiration.toString()));
        LtpaToken token = WSSOLoginUtil.getToken(username, false, dominoSecret, tokenExpiration);
        logger.error((Object)("*****token****" + token.toString()));
        String newToken = URLDecoder.decode(URLDecoder.decode(token.toString(), "UTF-8"), "UTF-8");
        logger.error((Object)("*****newToken****" + newToken.toString()));
        newToken = token.toString();
        return newToken;
    }

    public static String getPassword(String userNumber) {
        if (CONFIG_DIR == null) {
            WSSOLoginUtil.setConfigDir();
        }
        LtpaToken token = LtpaTokenManager.generate((String)userNumber, (String)(CONFIG_DIR + "/" + LTPATOKEN_PATH));
        logger.error((Object)("*****token************" + token.toString()));
        return token.toString();
    }

    public static void setConfigDir() {
        try {
            String tmp = System.getProperty("java.security.auth.login.config");
            if (tmp == null) {
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u672a\u914d\u7f6e!");
                return;
            }
            int i = tmp.lastIndexOf("/");
            if (i < 0) {
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u914d\u7f6e\u7684\u8def\u5f84\u4e2d\u6ca1\u6709 /!");
                return;
            }
            CONFIG_DIR = tmp.substring(0, i) + "/ssc/";
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static LtpaToken getToken(String canonicalUser, boolean isLMBCSEncode, String dominoSecret, String tokenExpiration) {
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(tokenExpiration);
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes((String)canonicalUser));
        } else {
            try {
                ltpa.setUser(canonicalUser.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(canonicalUser.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(creationDate);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(expirationDate);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, (byte[])ltpa.getHeader());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getCreation());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getExpires());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getUser());
        md.update(token);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes((String)dominoSecret));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate((byte[])token, (byte[])digest);
        String tokenStr = BASE64Util.encode((byte[])token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result = result + st.nextToken();
        }
        return new LtpaToken(result);
    }
}

