/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.wssc.app.util.WSSCCacheManager;
import com.kingdee.eas.common.EASBizException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WebServiceSetDao {
    static Logger logger = Logger.getLogger(WebServiceSetDao.class);

    public static void save(Properties properties, String fileName) throws BOSException, EASBizException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        OutputStream fos = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            fos = new FileOutputStream(fileName);
            properties.store(fos, "update");
            WSSCCacheManager.clearCache();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public static Properties getProperties(String fileName) throws BOSException, EASBizException {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(fileName);){
            properties.load(fileInputStream);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return properties;
    }
}

