/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.image;

import com.kingdee.eas.base.wssc.ImageSystemException;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageList;
import com.kingdee.eas.base.wssc.image.pojo.ImageStateParamInfo;
import com.kingdee.eas.common.EASBizException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class SSCImageUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.image.SSCImageUtils");
    public static final String TRAVEL_ACCOUNT_BILL = "TA";
    public static final String BIZ_ACCOUNT_BILL = "BA";
    public static final String DAILYACC_ACCOUNT_BILL = "DA";
    public static final String IMAGE_ALLOW_SCAN = "AllowScan";
    public static final String EXISTS_IMAGES = "Exists";
    public static final String NOT_DEAL = "0";
    public static final String HAS_DEAL = "1";
    public static final String DEAL_WAY = "NUMBER";
    private static String res = "com.kingdee.eas.cp.bc.CommonUtilResource";
    public static String jsonStr = "{\"total\":16,\"data\":[{\"id\":\"OPP-2010-411371\"},{\"id\":\"OPP\uff0d2014-318448\"},{\"id\":\"OPP-2011-519822\"},{\"id\":\"OPP-2011-526750\"},{\"id\":\"OPP-2011-510062\"},{\"id\":\"OPP-2010-447050\"},{\"id\":\"OPP\uff0d2014-318444\"},{\"id\":\"OPP\uff0d2013-318443\"},{\"id\":\"OPP\uff0d2015-318445\"},{\"id\":\"OPP\uff0d2012-318442\"},{\"id\":\"OPP\uff0d2013-318448\"}]}";
    public static String jsonStr2 = "{\"total\":16,\"data\":[{\"id\":\"OPP-2010-411371\"},{\"id\":\"OPP\uff0d2014-318448\"},{\"id\":\"OPP-2011-519822\"},{\"id\":\"OPP-2011-526750\"},{\"id\":\"OPP-2011-510062\"}]}";

    public static String getImageNo(String billNumber, String billType) {
        if (billNumber.length() > 2) {
            String prefix = billNumber.substring(0, 2);
            return prefix + billType + billNumber.substring(2);
        }
        return billType + billNumber;
    }

    public static String getBarCodeSpec(String imageNo) {
        return "*" + imageNo + "*";
    }

    public static Map getImageNoMap(BaseImageList baseList) {
        HashMap<String, HashSet> imageMap = new HashMap<String, HashSet>();
        BaseImageInfo imageInfo2 = null;
        String imageNo = null;
        String prefix = null;
        HashSet noSet = null;
        for (BaseImageInfo imageInfo2 : baseList.getImageList()) {
            imageNo = imageInfo2.getImageNo();
            prefix = SSCImageUtils.getPrefix(imageNo);
            if (!imageMap.containsKey(prefix)) {
                noSet = new HashSet();
                noSet.add(imageNo);
                imageMap.put(prefix, noSet);
                continue;
            }
            noSet = (HashSet)imageMap.get(prefix);
            noSet.add(imageNo);
        }
        return imageMap;
    }

    public static String getPrefix(String imageNo) {
        if (imageNo.indexOf(TRAVEL_ACCOUNT_BILL) > -1) {
            return TRAVEL_ACCOUNT_BILL;
        }
        if (imageNo.indexOf(BIZ_ACCOUNT_BILL) > -1) {
            return BIZ_ACCOUNT_BILL;
        }
        return "ERROR";
    }

    public static void addErrorImageList(BaseImageList baseList, BaseImageList newList, String clsName) {
        String imageNo = null;
        boolean exists = false;
        Iterator it1 = baseList.getImageList().iterator();
        while (it1.hasNext()) {
            exists = false;
            imageNo = ((BaseImageInfo)it1.next()).getImageNo().toUpperCase(Locale.ENGLISH);
            Iterator it2 = newList.getImageList().iterator();
            while (it2.hasNext()) {
                if (!imageNo.equals(((BaseImageInfo)it2.next()).getImageNo())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            try {
                BaseImageInfo imageInfo = (BaseImageInfo)Class.forName(clsName).newInstance();
                imageInfo.setImageNo(imageNo);
                newList.addImageList(imageInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append("'");
            sb.append(it.next());
            sb.append("'");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        if (set.size() > 0) {
            sb.append(")");
        } else {
            sb.append("'')");
        }
        return sb.toString();
    }

    public static String getStrFromArray(String[] arr) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int j = arr.length;
        for (int i = 0; i < j; ++i) {
            sb.append("'");
            sb.append(arr[i]);
            sb.append("'");
            if (i == j - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Date convertStr2Date(String dateStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.parse(dateStr);
        }
        catch (Exception e) {
            logger.error((Object)("formate Date Fail yyyy-MM-dd HH:mm:ss   " + e));
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.parse(dateStr);
            }
            catch (Exception e2) {
                logger.error((Object)("formate Date Fail yyyy-MM-dd  " + e));
                return new Date();
            }
        }
    }

    public static JSONObject getImageJosnObj(String imageNo) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("imageNo", (Object)imageNo);
        }
        catch (JSONException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return jsonObj;
    }

    public static JSONObject getImageJosnObj(ImageStateParamInfo imageInfo) {
        return SSCImageUtils.getImageJosnObj(imageInfo, "");
    }

    public static JSONObject getImageJosnObj(ImageStateParamInfo imageInfo, String previousNodeAssignId) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("imageNo", (Object)imageInfo.getImageNo());
            jsonObj.put("message", (Object)imageInfo.getMessage());
            if (imageInfo.getMessage() == null || imageInfo.getMessage().trim().length() == 0) {
                jsonObj.put("message", (Object)imageInfo.getRescanMessage());
            }
            jsonObj.put("rescanMassage", (Object)imageInfo.getRescanMessage());
            jsonObj.put("sscType", (Object)imageInfo.getSscType());
            jsonObj.put("scanUserID", (Object)imageInfo.getScanUserID());
            jsonObj.put("previousNodeAssignId", (Object)previousNodeAssignId);
        }
        catch (JSONException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return jsonObj;
    }

    public static void checkImageHost(String imageIp, int imagePort) throws EASBizException {
        Socket connect = new Socket();
        try {
            connect.connect(new InetSocketAddress(imageIp, imagePort), 1000);
            boolean res = connect.isConnected();
            if (!res) {
                throw new ImageSystemException(ImageSystemException.IMAGENETWORK_EXCEPTION, new Object[]{imageIp + ":" + imagePort});
            }
        }
        catch (IOException e) {
            throw new ImageSystemException(ImageSystemException.IMAGENETWORK_EXCEPTION, new Object[]{imageIp + ":" + imagePort});
        }
        finally {
            try {
                if (connect != null) {
                    connect.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void checkImageServer(String url_prefix, String imageIp, int imagePort, String imageTail) throws EASBizException {
        String url = url_prefix + "://" + imageIp + ":" + imagePort + imageTail;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(60000);
            if (200 != connection.getResponseCode()) {
                throw new ImageSystemException(ImageSystemException.IMAGESERVER_EXCEPTION);
            }
        }
        catch (SocketTimeoutException e1) {
            throw new ImageSystemException(ImageSystemException.IMAGESERVER_EXCEPTION, e1);
        }
        catch (IOException e) {
            throw new ImageSystemException(ImageSystemException.IMAGESERVER_EXCEPTION, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

