/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.image.helper.xmlParmas;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class JDomUtils {
    public static Element createRoot(String rootName) {
        Element root = new Element(rootName);
        return root;
    }

    public static Element addChild(Element parent, String childName) {
        Element child = new Element(childName);
        parent.addContent((Content)child);
        return child;
    }

    public static void addChild(Element parent, Element childName) {
        parent.addContent((Content)childName);
    }

    public static Element addChild(Element parent, String childName, String childValue) {
        Element child = new Element(childName);
        child.setText(childValue != null ? childValue : "");
        parent.addContent((Content)child);
        return child;
    }

    public static String root2StringWithoutXMLDeclaration(Element root, String encoding) throws JDOMException, IOException {
        return JDomUtils.root2StringWithoutXMLDeclaration(root, encoding, false);
    }

    public static String root2StringWithoutXMLDeclaration(Element root, String encoding, boolean formated) throws JDOMException, IOException {
        XMLOutputter outputter = new XMLOutputter();
        if (formated) {
            String msg = outputter.outputString(root);
            root = JDomUtils.string2Root(msg, encoding);
        }
        return outputter.outputString(root);
    }

    public static String root2String(Element root, String encoding) throws JDOMException, IOException {
        return JDomUtils.root2String(root, encoding, false);
    }

    public static String root2String(Element root, String encoding, boolean formated) throws JDOMException, IOException {
        XMLOutputter outputter = new XMLOutputter();
        if (formated) {
            String msg = outputter.outputString(root);
            root = JDomUtils.string2Root(msg, encoding);
        }
        Document document = null;
        if (root.getParent() != null) {
            root.detach();
        }
        document = new Document(root);
        return outputter.outputString(document);
    }

    public static Element string2Root(String content, String encoding) throws JDOMException, IOException {
        Document document = JDomUtils.string2Document(content, encoding);
        return document.getRootElement();
    }

    private static Document string2Document(String content, String encoding) throws JDOMException, IOException {
        int startPoint = content.indexOf("<?xml");
        if (-1 != startPoint) {
            content = content.substring(startPoint);
        }
        if (-1 == content.indexOf("<?xml")) {
            content = "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>" + content;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(encoding));
        SAXBuilder builder = new SAXBuilder();
        return builder.build((InputStream)bais);
    }
}

