/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.imageNew.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.ImageLogFactory;
import com.kingdee.eas.base.wssc.ImageLogInfo;
import com.kingdee.eas.base.wssc.ImageOperation;
import com.kingdee.eas.base.wssc.ImageSystemException;
import com.kingdee.eas.base.wssc.image.pojo.ImageSysSuperBaseInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2RejectBillInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2RescanInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2SendNoteInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2getScanHomeInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysArchive;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysCancelRescanInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysCreateJobInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysDeleteInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysDestroyInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysSubmitInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysSynVoucherInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysToAppParamInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysUploadInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewOnPhoneInfo;
import com.kingdee.eas.base.wssc.imageNew.helper.NoticeImageSysHelper_New;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.base.wssc.imageNew.util.HttpPostUtil;
import com.kingdee.eas.base.wssc.imageNew.util.ImageLogUtil;
import com.kingdee.eas.base.wssc.imageNew.util.MultiImageConfig;
import com.kingdee.eas.base.wssc.util.H;
import com.kingdee.eas.base.wssc.util.MD5;
import com.kingdee.eas.base.wssc.util.MD5Utils;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NoticeImageSysHelper_FPY_New
extends NoticeImageSysHelper_New {
    private Logger logger = Logger.getLogger(NoticeImageSysHelper_FPY_New.class);
    public static final String ENTRUST_TYPE_ID = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    public final String key = "FPY";
    private StringBuffer bufferParam = new StringBuffer();
    private StringBuffer bufferException = new StringBuffer();
    private String clientId = null;
    private String sign = null;
    private long timestamp = 0L;
    private String token = null;
    private String phoneNumber = null;
    private String taxNo = null;
    private String feasUid = null;
    private String fuserNumber = null;

    public NoticeImageSysHelper_FPY_New(Context ctx, String imageSysId) {
        super(ctx, imageSysId);
    }

    public static boolean clearTokenCache() {
        return true;
    }

    private String getRequestToken(String barCode) throws EASBizException {
        this.initToken(barCode);
        return this.token;
    }

    private void initToken(String barCode) throws EASBizException {
        String clientid;
        if (StringUtils.isBlank((CharSequence)this.feasUid)) {
            this.feasUid = this.ctx.getCaller().toString();
            this.initUserNumber(this.ctx, this.feasUid);
        } else if (BOSUuid.isValid((String)this.feasUid, (boolean)false)) {
            ObjectUuidPK uuid = new ObjectUuidPK(this.feasUid);
            if (uuid != null && "80EF7DED".equals(uuid.getObjectType().toString())) {
                this.logger.error((Object)("id\u4e3apersonId:[" + this.feasUid + "],"));
                try {
                    EntityViewInfo view = new EntityViewInfo();
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isDelete", (Object)false));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isForbidden", (Object)false));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("person", (Object)this.feasUid));
                    UserCollection coll = UserFactory.getLocalInstance((Context)this.ctx).getUserCollection(view);
                    this.feasUid = coll.get(0).getId().toString();
                    this.fuserNumber = coll.get(0).getNumber();
                }
                catch (Exception e) {
                    this.logger.error((Object)"\u6839\u636epersonid\u67e5\u8be2userid\u51fa\u73b0\u5f02\u5e38!");
                }
            } else if (uuid != null && "13B7DE7F".equals(uuid.getObjectType().toString())) {
                this.initUserNumber(this.ctx, this.feasUid);
            } else {
                this.logger.error((Object)("\u65e0\u6548\u7684\u7528\u6237id,\u66ff\u6362\u4e3actx\u7684caller;\u539fid:" + this.feasUid + ";caller:" + this.ctx.getCaller()));
                this.feasUid = this.ctx.getCaller().toString();
                this.initUserNumber(this.ctx, this.feasUid);
            }
        } else {
            this.logger.error((Object)("\u65e0\u6548\u7684\u7528\u6237id,\u66ff\u6362\u4e3actx\u7684caller;\u539fid:" + this.feasUid + ";caller:" + this.ctx.getCaller()));
            this.feasUid = this.ctx.getCaller().toString();
            this.initUserNumber(this.ctx, this.feasUid);
        }
        if (this.phoneNumber == null) {
            this.initPhoneNumber();
        }
        if (StringUtils.isEmpty((CharSequence)this.fuserNumber)) {
            this.initUserNumber(this.ctx, this.feasUid);
        }
        if (StringUtils.isEmpty((CharSequence)this.phoneNumber) && StringUtils.isEmpty((CharSequence)this.fuserNumber)) {
            this.logger.error((Object)("@_@\u7528\u6237\u624b\u673a\u53f7\u6216\u8005\u7528\u6237\u540d\u90fd\u662f\u7a7a\u7684\u5462@_@" + this.feasUid + ";caller:" + this.ctx.getCaller()));
        }
        if (StringUtils.isEmpty((CharSequence)(clientid = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.token.clientid")))) {
            if (StringUtils.isBlank((CharSequence)this.clientId)) {
                this.initParamsByUserID();
            }
        } else {
            this.initFpyInfo();
            this.logger.error((Object)("clientId:" + this.clientId + ";sign:" + this.sign));
        }
        this.token = this.getTokenFromFPY(this.clientId, this.sign, this.timestamp, this.phoneNumber, this.taxNo, this.feasUid, this.fuserNumber);
    }

    private void initUserNumber(Context ctx, String feasUid) {
        if (StringUtils.isNotBlank((CharSequence)feasUid)) {
            try {
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(H.PK(feasUid));
                this.fuserNumber = userInfo.getNumber();
            }
            catch (BOSException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void initFpyInfo() throws EASBizException {
        this.timestamp = System.currentTimeMillis();
        this.clientId = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.token.clientid");
        try {
            this.clientId = MD5Utils.md5Decode(this.clientId);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u89e3\u5bc6\u6388\u6743\u7801\u5f02\u5e38:clientId" + this.clientId), (Throwable)e);
        }
        this.sign = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.token.key");
        try {
            this.sign = MD5Utils.md5Decode(this.sign);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u89e3\u5bc6\u6388\u6743\u79d8\u94a5\u5f02\u5e38:sign" + this.sign), (Throwable)e);
        }
        this.sign = this.clientId + this.sign + this.timestamp;
        this.sign = MD5.md5crypt(this.sign);
    }

    private void initParamsByUserID() throws EASBizException {
        this.timestamp = System.currentTimeMillis();
        String sql = "select oa.FID,oa.FlongNumber from T_ORG_Admin oa, T_ORG_PositionMember opm,T_ORG_Position op,T_PM_User pu where opm.FPositionID = op.FID and opm.FPersonID = pu.FPersonID and opm.FISPrimary = 1 and oa.FID = op.FAdminOrgUnitID and pu.FID = ? ";
        String longNumber = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{this.feasUid});
            if (rs.next()) {
                longNumber = rs.getString(2);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        if (StringUtils.isEmpty(longNumber)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u6ca1\u6709\u5206\u914d\u884c\u653f\u7ec4\u7ec7"));
        }
        if (longNumber != null) {
            String[] numbers = longNumber.split("!");
            String companyLongNumber = null;
            for (int i = numbers.length - 1; i >= 0; --i) {
                String sql2 = "select oc.FlongNumber from T_ORG_UNITRELATION ur, T_ORG_Admin oa, T_ORG_Company oc where ur.FFromUnitID = oa.FID and ur.FToUnitID = oc.FID and FTYPERELATIONID = ? and oa.FNumber = ?";
                try {
                    IRowSet rs2 = DbUtil.executeQuery((Context)this.ctx, (String)sql2, (Object[])new Object[]{ENTRUST_TYPE_ID, numbers[i]});
                    if (!rs2.next()) continue;
                    companyLongNumber = rs2.getString(1);
                    break;
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
            if (StringUtils.isEmpty(companyLongNumber)) {
                throw new EASBizException(new NumericExceptionSubItem("00", longNumber + "\u6ca1\u6709\u8d22\u52a1\u7ec4\u7ec7"));
            }
            if (companyLongNumber != null) {
                String sql3 = "select FTAXNUMBER,FAuthorizationCode,FAuthorizationKey from T_ORG_Company where (charindex('!'||FNUMBER||'!', '" + companyLongNumber + "') > 1  or charindex(FNUMBER||'!','" + companyLongNumber + "') = 1 or FlongNumber = '" + companyLongNumber + "' ) and FTAXNUMBER is not null order by FLongNumber desc";
                try {
                    IRowSet rs3 = DbUtil.executeQuery((Context)this.ctx, (String)sql3, (Object[])new Object[0]);
                    if (rs3.next()) {
                        this.taxNo = rs3.getString(1);
                        this.clientId = rs3.getString(2);
                        this.sign = rs3.getString(3);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.taxNo)) {
                throw new EASBizException(new NumericExceptionSubItem("00", companyLongNumber + "\u6ca1\u6709\u914d\u7f6e\u7a0e\u53f7\u7b49\u4fe1\u606f"));
            }
        }
        this.sign = this.clientId + this.sign + this.timestamp;
        this.sign = MD5.md5crypt(this.sign);
    }

    private String getPostURLHeader() {
        String url = "https://api.piaozone.com";
        String ip = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.ip");
        if (!StringUtils.isEmpty((CharSequence)ip)) {
            String urlprefix;
            String port = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.port");
            String string = urlprefix = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.url.prefix") == null ? "http" : MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.url.prefix").trim();
            url = StringUtils.isEmpty((CharSequence)port) ? (ip.startsWith("http") ? ip : urlprefix + "://" + ip) : (ip.startsWith("http") ? ip + ":" + port : urlprefix + "://" + ip + ":" + port);
        }
        return url;
    }

    private String getTokenFromFPY(String clientId, String sign, long timestamp, String phoneNumber, String ftaxNo, String feasUid, String fuserNumber) throws EASBizException {
        String retToken = null;
        String fsource = "2";
        String url = "";
        String getTokenUrl = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.token.tail");
        if (!StringUtils.isBlank((CharSequence)getTokenUrl)) {
            url = getTokenUrl;
        } else {
            url = this.getPostURLHeader();
            getTokenUrl = "/archivebase/scan/login/token";
            url = url + getTokenUrl;
        }
        JSONObject param = new JSONObject();
        param.put((Object)"clientId", (Object)clientId);
        param.put((Object)"sign", (Object)sign);
        param.put((Object)"timestamp", (Object)timestamp);
        param.put((Object)"fphoneNumber", (Object)phoneNumber);
        param.put((Object)"ftaxNo", (Object)ftaxNo);
        param.put((Object)"feasUid", (Object)feasUid);
        param.put((Object)"fsource", (Object)fsource);
        param.put((Object)"fuserName", (Object)fuserNumber);
        this.logger.error((Object)("\u53d1\u7968\u4e91\u53d6token,Param:" + param));
        JSONObject retJsonObj = null;
        try {
            retJsonObj = JSONObject.fromObject((Object)HttpPostUtil.postInterface(url, param.toString(), true));
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6token\u5f02\u5e38:" + e == null ? "\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a" : e.getMessage()), (Throwable)e);
        }
        this.logger.error((Object)("\u53d1\u7968\u4e91\u53d6token,retJsonObj:" + retJsonObj));
        String errcode = retJsonObj.get("errcode") + "";
        if (!"0000".equals(errcode)) {
            this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91token\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edftoken\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description"))));
        }
        retToken = ((Map)retJsonObj.get("data")).get("accessToken") + "";
        return retToken;
    }

    private void initPhoneNumber() throws EASBizException {
        UserInfo userInfo = null;
        try {
            if (UserFactory.getLocalInstance((Context)this.ctx).exists((IObjectPK)new ObjectUuidPK(this.feasUid)) && this.phoneNumber == null) {
                userInfo = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo((IObjectPK)new ObjectUuidPK(this.feasUid));
                this.phoneNumber = userInfo.getCell();
                if (this.phoneNumber == null && userInfo.getPerson() != null) {
                    PersonInfo pInfo = PersonFactory.getLocalInstance((Context)this.ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(userInfo.getPerson().getId()));
                    this.phoneNumber = pInfo.getCell();
                }
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws BOSException, ImageSystemException {
        String url = null;
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        String requestUrl = "";
        try {
            try {
                String scan_tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.scan.homeurl");
                if (StringUtils.isBlank((CharSequence)scan_tail)) {
                    requestUrl = this.getPostURLHeader();
                    scan_tail = "/scan/bill/outside/getHomeUrl";
                    requestUrl = requestUrl + scan_tail;
                } else {
                    requestUrl = scan_tail;
                }
                requestUrl = requestUrl + "?access_token=" + this.getRequestToken(scanHomeInfo.getBarCode());
                this.bufferParam.append("[").append(requestUrl).append("][").append(scanHomeInfo).append("]");
                JSONObject param = new JSONObject();
                String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("getScanHomeUrl;return json:" + json));
                JSONObject retJsonObj = JSONObject.fromObject((Object)json);
                String errcode = retJsonObj.get("errcode") + "";
                if ("1300".equals(errcode)) {
                    this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                    String oldToken = this.token;
                    this.token = null;
                    this.token = this.getRequestToken(scanHomeInfo.getBarCode());
                    requestUrl = requestUrl.replace(oldToken, this.token);
                    json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                    this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                    retJsonObj = JSONObject.fromObject((Object)json);
                    errcode = retJsonObj.get("errcode") + "";
                }
                if (!"0000".equals(errcode)) {
                    this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u626b\u63cf\u9996\u9875\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6\u626b\u63cf\u9996\u9875\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description"))));
                }
                url = ((Map)retJsonObj.get("data")).get("url") + "";
            }
            catch (RemoteException e) {
                this.logger.error((Object)("\u83b7\u53d6\u626b\u63cf\u9996\u9875--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";scanHomeInfo:" + scanHomeInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
            }
            catch (Exception e) {
                this.logger.error((Object)("\u83b7\u53d6\u626b\u63cf\u9996\u9875--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";scanHomeInfo:" + scanHomeInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
            }
            String string = url;
            return string;
        }
        finally {
            ImageLogUtil.writeErrLog(this.ctx, scanHomeInfo.getBarCode(), ImageOperation.scanHome, this.bufferParam.toString(), this.bufferException.toString());
        }
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        String requestUrl = "";
        try {
            this.feasUid = rescanInfo.getUserId();
            String rescan_tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.rescan");
            if (!StringUtils.isBlank((CharSequence)rescan_tail)) {
                requestUrl = rescan_tail;
            } else {
                requestUrl = this.getPostURLHeader();
                rescan_tail = "/scan/bill/outside/reject";
                requestUrl = requestUrl + rescan_tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(rescanInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(rescanInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)rescanInfo.getBarCode());
            param.put((Object)"rejectReason", (Object)(rescanInfo.getRescanMessage() == null ? "" : rescanInfo.getRescanMessage()));
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("rescan;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(rescanInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u9000\u56de\u91cd\u626b\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";rescanInfo:" + rescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.error((Object)("\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";rescanInfo:" + rescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        String requestUrl = "";
        try {
            this.feasUid = cancelRescanInfo.getCancelUser();
            String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.cancelrescan");
            if (!StringUtils.isBlank((CharSequence)tail)) {
                requestUrl = tail;
            } else {
                requestUrl = this.getPostURLHeader();
                tail = "/scan/bill/outside/reject/cancel";
                requestUrl = requestUrl + tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(cancelRescanInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(cancelRescanInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)cancelRescanInfo.getBarCode());
            param.put((Object)"cancelRejectReason", (Object)(cancelRescanInfo.getCancelMessage() == null ? "" : cancelRescanInfo.getCancelMessage()));
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("cancelRescan;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(cancelRescanInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u53d6\u6d88\u9000\u56de\u91cd\u626b\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u53d6\u6d88\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";cancelRescanInfo:" + cancelRescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.error((Object)("\u53d6\u6d88\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";cancelRescanInfo:" + cancelRescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws BOSException, ImageSystemException {
        String url = null;
        String requestUrl = "";
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        try {
            try {
                String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.view");
                if (!StringUtils.isBlank((CharSequence)tail)) {
                    requestUrl = tail;
                } else {
                    requestUrl = this.getPostURLHeader();
                    tail = "/scan/bill/outside/getScanUrl";
                    requestUrl = requestUrl + tail;
                }
                requestUrl = requestUrl + "?access_token=" + this.getRequestToken(viewPhotoInfo.getBarCode());
                this.bufferParam.append("[").append(requestUrl).append("][").append(viewPhotoInfo).append("]");
                JSONObject param = new JSONObject();
                param.put((Object)"scanBillNo", (Object)viewPhotoInfo.getBarCode());
                param.put((Object)"isRemark", (Object)viewPhotoInfo.isAllowRescan());
                param.put((Object)"isRescan", (Object)viewPhotoInfo.isAllowRescan());
                param.put((Object)"isEdit", (Object)false);
                String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("getScanHomeUrl;return json:" + json));
                JSONObject retJsonObj = JSONObject.fromObject((Object)json);
                String errcode = retJsonObj.get("errcode") + "";
                if ("1300".equals(errcode)) {
                    this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                    String oldToken = this.token;
                    this.token = null;
                    this.token = this.getRequestToken(viewPhotoInfo.getBarCode());
                    requestUrl = requestUrl.replace(oldToken, this.token);
                    json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                    this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                    retJsonObj = JSONObject.fromObject((Object)json);
                    errcode = retJsonObj.get("errcode") + "";
                }
                if (!"0000".equals(errcode)) {
                    this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u67e5\u770b\u5f71\u50cf\u9875\u9762\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                    throw new Exception("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description")));
                }
                url = ((Map)retJsonObj.get("data")).get("url") + "";
            }
            catch (RemoteException e) {
                this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";viewPhotoInfo:" + viewPhotoInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
            }
            catch (Exception e) {
                this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";viewPhotoInfo:" + viewPhotoInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
            }
            String string = url;
            return string;
        }
        finally {
            ImageLogUtil.writeErrLog(this.ctx, viewPhotoInfo.getBarCode(), ImageOperation.viewPhoto, this.bufferParam.toString(), this.bufferException.toString());
        }
    }

    @Override
    public String imageUpload(NoticeImageSysUploadInfo uploadInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String viewPhotoOnPhone(NoticeImageSysViewOnPhoneInfo viewPhotoInfo) throws BOSException, ImageSystemException {
        String url;
        block12: {
            String requestUrl = "";
            String json = "";
            String paramStr = "";
            String errSta = "";
            boolean success = true;
            url = "";
            try {
                JSONObject param = new JSONObject();
                param.put((Object)"scanBillNo", (Object)viewPhotoInfo.getBarCode());
                param.put((Object)"isRemark", (Object)false);
                param.put((Object)"isRescan", (Object)false);
                param.put((Object)"isEdit", (Object)false);
                param.put((Object)"language", (Object)"zh_CN");
                requestUrl = this.getRequestUrl("image.phone.view", "/imgsys/bill/h5/getH5ViewPageUrl");
                this.logger.error((Object)("viewPhotoOnPhone--requestUrl" + requestUrl));
                paramStr = param.toString();
                this.logger.error((Object)("viewPhotoOnPhone--param" + param));
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("viewPhotoOnPhone;return json:" + json));
                JSONObject retJsonObj = JSONObject.fromObject((Object)json);
                String errcode = retJsonObj.get("errcode") + "";
                if ("0000".equals(errcode)) {
                    url = ((Map)retJsonObj.get("data")).get("url") + "";
                    break block12;
                }
                success = false;
                errSta = errSta + "errorJSON:" + json;
                this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u624b\u673a\u67e5\u770b\u5f71\u50cf\u9875\u9762\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                throw new ImageSystemException(new NumericExceptionSubItem("001", "\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description"))));
            }
            catch (EASBizException e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
            }
            catch (Exception e) {
                success = false;
                errSta = errSta + e.getMessage();
                this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
            }
            finally {
                try {
                    if (Configure.enableLog2Table(this.ctx)) {
                        ImageLogInfo logInfo = new ImageLogInfo();
                        logInfo.setException(errSta + "--resultJSON:" + json);
                        logInfo.setSuccess(success);
                        logInfo.setParam(paramStr);
                        logInfo.setImageNo(viewPhotoInfo.getBarCode());
                        ImageLogFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)logInfo);
                    }
                }
                catch (Throwable e) {
                    this.logger.error((Object)e, e);
                }
            }
        }
        return url;
    }

    @Override
    public String viewPhotos(NoticeImageSysViewInfo[] viewPhotoInfos) throws BOSException, ImageSystemException {
        if (viewPhotoInfos == null || viewPhotoInfos.length == 0) {
            return null;
        }
        StringBuilder imageNo = new StringBuilder();
        for (int i = 0; i < viewPhotoInfos.length; ++i) {
            imageNo.append(viewPhotoInfos[i].getBarCode() + ",");
        }
        imageNo.setCharAt(imageNo.length() - 1, ' ');
        String url = null;
        String requestUrl = "";
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        try {
            requestUrl = this.getRequestUrl("image.view", "/scan/bill/outside/getScanUrl");
            this.bufferParam.append("[").append(requestUrl).append("][").append(viewPhotoInfos).append("]");
            url = this.getUrl(requestUrl, imageNo.toString(), viewPhotoInfos[0].isAllowRescan());
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return url;
    }

    private String getUrl(String requestUrl, String imageNo, boolean isAllowRescan) throws BOSException, ImageSystemException {
        String url = null;
        try {
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)imageNo);
            param.put((Object)"isRemark", (Object)isAllowRescan);
            param.put((Object)"isRescan", (Object)isAllowRescan);
            param.put((Object)"isEdit", (Object)false);
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("getScanHomeUrl;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken("");
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if (!"0000".equals(errcode)) {
                this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u67e5\u770b\u5f71\u50cf\u9875\u9762\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                throw new ImageSystemException(new NumericExceptionSubItem("001", "\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description"))));
            }
            url = ((Map)retJsonObj.get("data")).get("url") + "";
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
        return url;
    }

    private String getRequestUrl(String value, String defaultValue) throws BOSException {
        try {
            String requestUrl = "";
            String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, value);
            if (!StringUtils.isBlank((CharSequence)tail)) {
                requestUrl = tail;
            } else {
                requestUrl = this.getPostURLHeader();
                tail = defaultValue;
                requestUrl = requestUrl + tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken("");
            return requestUrl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public String viewPhotosOnPhone(NoticeImageSysViewOnPhoneInfo[] viewPhotoInfos) throws BOSException, ImageSystemException {
        if (viewPhotoInfos == null || viewPhotoInfos.length == 0) {
            return null;
        }
        StringBuilder imageNo = new StringBuilder();
        for (int i = 0; i < viewPhotoInfos.length; ++i) {
            imageNo.append(viewPhotoInfos[i].getBarCode() + ",");
        }
        imageNo.setCharAt(imageNo.length() - 1, ' ');
        String requestUrl = "";
        String json = "";
        String paramStr = "";
        String errSta = "";
        boolean success = true;
        String url = "";
        try {
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)imageNo.toString());
            param.put((Object)"isRemark", (Object)false);
            param.put((Object)"isRescan", (Object)false);
            param.put((Object)"isEdit", (Object)false);
            param.put((Object)"language", (Object)"zh_CN");
            requestUrl = this.getRequestUrl("image.phone.view", "/imgsys/bill/h5/getH5ViewPageUrl");
            this.logger.error((Object)("viewPhotoOnPhone--requestUrl" + requestUrl));
            paramStr = param.toString();
            this.logger.error((Object)("viewPhotoOnPhone--param" + param));
            json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("viewPhotoOnPhone;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if (!"0000".equals(errcode)) {
                success = false;
                errSta = errSta + "errorJSON:" + json;
                this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u624b\u673a\u6279\u91cf\u67e5\u770b\u5f71\u50cf\u9875\u9762\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                throw new ImageSystemException(new NumericExceptionSubItem("001", "\u83b7\u53d6\u53d1\u7968\u4e91\u624b\u673a\u6279\u91cf\u67e5\u770b\u5f71\u50cf\u9875\u9762\u8bf7\u6c42\u5931\u8d25\uff1a" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description"))));
            }
            url = ((Map)retJsonObj.get("data")).get("url") + "";
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            success = false;
            errSta = errSta + e.getMessage();
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            success = false;
            errSta = errSta + e.getMessage();
            this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + "\n" + e.getMessage()), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
        return url;
    }

    @Override
    public String synVoucherInfo(NoticeImageSysSynVoucherInfo synInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String deleteImage(NoticeImageSysDeleteInfo deleteInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        String requestUrl = "";
        try {
            this.feasUid = deleteInfo.getUserId();
            String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.delete");
            if (!StringUtils.isBlank((CharSequence)tail)) {
                requestUrl = tail;
            } else {
                requestUrl = this.getPostURLHeader();
                tail = "/scan/bill/outside/delete";
                requestUrl = requestUrl + tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(deleteInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(deleteInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)deleteInfo.getBarCode());
            param.put((Object)"deleteReason", (Object)deleteInfo.getMessage());
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("deleteImage;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(deleteInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdeleteImage(\u5220\u9664)\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdeleteImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";deleteInfo:" + deleteInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdeleteImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";deleteInfo:" + deleteInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        String requestUrl = "";
        try {
            this.feasUid = destroyInfo.getOpreatePerson() == null ? destroyInfo.getSscNumber() : destroyInfo.getOpreatePerson();
            String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.delete");
            if (!StringUtils.isBlank((CharSequence)tail)) {
                requestUrl = tail;
            } else {
                requestUrl = this.getPostURLHeader();
                tail = "/scan/bill/outside/delete";
                requestUrl = requestUrl + tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(destroyInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(destroyInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)destroyInfo.getBarCode());
            param.put((Object)"deleteReason", (Object)destroyInfo.getMessage());
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("deleteImage;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(destroyInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdestroyImage(\u5220\u9664)\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdestroyImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";destroyInfo:" + destroyInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdestroyImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";destroyInfo:" + destroyInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String submit2ImageSys(NoticeImageSysSubmitInfo submitInfo) throws BOSException, ImageSystemException {
        if (submitInfo == null || submitInfo.getBarCode() == null || submitInfo.getFilePaths() == null) {
            this.logger.error((Object)("fpy\u5f71\u50cf\u4e0a\u4f20\u5931\u8d25, \u63a5\u53e3\u53c2\u6570\u6709\u8bef \u8bf7\u68c0\u67e5 \uff1a " + submitInfo.toString()));
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION);
        }
        String imageNumber = submitInfo.getBarCode();
        String result = "1";
        String requestUrl = "";
        ArrayList<String> fileIds = new ArrayList<String>();
        try {
            requestUrl = this.getRequestUrl("image.phone.upload", "/imgsys/bill/outside/file/upload");
            this.logger.error((Object)("imageupload--requestUrl:" + requestUrl));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("hashType", "0");
            ArrayList<String> files = new ArrayList<String>(Arrays.asList(submitInfo.getFilePaths()));
            int fileNum = files.size();
            for (int i = 0; i < 3; ++i) {
                for (int j = files.size() - 1; j >= 0; --j) {
                    String filepath = (String)files.get(j);
                    if (StringUtils.isEmpty((CharSequence)filepath)) continue;
                    File file = new File(filepath);
                    String res = HttpPostUtil.postInterface(requestUrl, params, file, "file", true);
                    this.logger.error((Object)("imageupload : result json : " + res));
                    JSONObject json = JSONObject.fromObject((Object)res);
                    if ("1300".equals(json.get("errcode"))) {
                        this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + json.get("description")));
                        requestUrl = this.getRequestUrl("image.phone.upload", "/imgsys/bill/outside/file/upload");
                        res = HttpPostUtil.postInterface(requestUrl, params, file, "file", true);
                        this.logger.error((Object)(" \u7b2c\u4e8c\u6b21 imageupload : result json : " + res));
                        json = JSONObject.fromObject((Object)res);
                    }
                    if ("0000".equals(json.get("errcode"))) {
                        fileIds.add(json.getJSONObject("data").getString("fileId"));
                        files.remove(j);
                        continue;
                    }
                    this.logger.error((Object)("\u7b2c" + i + "\u6b21\u83b7\u53d6\u53d1\u7968\u4e91\u4e0a\u4f20\u5f71\u50cf\u8bf7\u6c42\u5931\u8d25!errcode:" + json.get("errcode") + "!description:" + json.get("description")));
                }
            }
            if (fileIds.size() != 0) {
                if (fileIds.size() == fileNum) {
                    this.logger.error((Object)("submit2ImageSys imageNum \uff1a " + imageNumber + "    fileNum : " + fileIds.size() + "\u5168\u90e8\u4e0a\u4f20\u6210\u529f \u5f85\u7ed1\u5b9a\u5173\u7cfb"));
                } else {
                    this.logger.error((Object)("submit2ImageSys imageNum \uff1a " + imageNumber + "    fileNum : " + fileIds.size() + "\u90e8\u5206\u4e0a\u4f20\u6210\u529f \u5f85\u7ed1\u5b9a\u5173\u7cfb"));
                }
                String res = this.bingingImgAndFiles(this.ctx, imageNumber, fileIds);
                if ("1".equals(res)) {
                    return "1";
                }
                this.logger.error((Object)("submit2ImageSys imageNum \uff1a " + imageNumber + "\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25"));
                return "0";
            }
            this.logger.error((Object)("submit2ImageSys imageNum \uff1a " + imageNumber + "    fileNum : " + fileNum + "\u5168\u90e8\u4e0a\u4f20\u5931\u8d25"));
            return "0";
        }
        catch (Exception e) {
            result = "0";
            this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + "\n" + e.getMessage()), (Throwable)e);
            return result;
        }
    }

    private String bingingImgAndFiles(Context ctx, String imageNumber, List<String> fileIds) {
        if (fileIds == null || fileIds.isEmpty() || StringUtils.isEmpty((CharSequence)imageNumber)) {
            this.logger.error((Object)("bingingImgAndFiles : \u53c2\u6570\u6709\u8bef \u8bf7\u68c0\u67e5 -- imageNum" + imageNumber + "\u6587\u4ef6\u4e2a\u6570" + fileIds.size()));
        }
        try {
            String url = this.getRequestUrl("image.binging.imageNumAndFiles", "/imgsys/bill/outside/scanbill/add");
            this.logger.error((Object)("bingingImgAndFiles : \u8bf7\u6c42\u7684url --" + url));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"fscanBillNo", (Object)imageNumber);
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (String fileId : fileIds) {
                JSONObject json = new JSONObject();
                json.put((Object)"coverFlag", (Object)0);
                json.put((Object)"fileId", (Object)fileId);
                list.add(json);
            }
            jsonObject.put((Object)"scanOutsideFileVoList", list);
            String params = jsonObject.toString();
            this.logger.error((Object)("bingingImgAndFiles \u8bf7\u6c42\u53c2\u6570\uff1a imageNum : " + imageNumber + "  params\uff1a " + params));
            String res = HttpPostUtil.postInterface(url, params, true);
            this.logger.error((Object)("bingingImgAndFiles \u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a " + res));
            JSONObject jsonRes = JSONObject.fromObject((Object)res);
            if ("1300".equals(jsonRes.get("errcode"))) {
                this.logger.error((Object)("bingingImgAndFiles  !token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + jsonRes.get("description")));
                url = this.getRequestUrl("image.binging.imageNumAndFiles", "/imgsys/bill/outside/scanbill/add");
                res = HttpPostUtil.postInterface(url, params, true);
                jsonRes = JSONObject.fromObject((Object)res);
                this.logger.error((Object)("bingingImgAndFiles \u7b2c\u4e8c\u6b21\u8bf7\u6c42\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a " + res));
            }
            if ("0000".equals(jsonRes.get("errcode"))) {
                this.logger.error((Object)("bingingImgAndFiles \u5f71\u50cf\u6587\u4ef6\u7ed1\u5b9a\u6210\u529f  imageNumber \uff1a " + imageNumber + "\u5f71\u50cf\u6587\u4ef6\u6570\u91cf \uff1a " + fileIds.size()));
                return "1";
            }
            return "0";
        }
        catch (Exception e) {
            this.logger.error((Object)("bingingImgAndFiles \u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef imageNum \uff1a " + imageNumber + e));
            return "0";
        }
    }

    @Override
    public String freezeArchiveImage(ImageSysSuperBaseInfo superBaseInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String noticImageSysCreateScanJob(ImageSysSuperBaseInfo superBaseInfo) throws BOSException, ImageSystemException {
        NoticeImageSysCreateJobInfo createJobInfo = (NoticeImageSysCreateJobInfo)superBaseInfo;
        try {
            String requestUrl = this.getPostURLHeader();
            String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.createscanjob");
            if (!StringUtils.isBlank((CharSequence)tail)) {
                requestUrl = tail;
            } else {
                requestUrl = this.getPostURLHeader();
                tail = "/imgsys/bill/signPost/erpBillPush";
                requestUrl = requestUrl + tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(createJobInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(createJobInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"fscanBillNo", (Object)createJobInfo.getBarCode());
            param.put((Object)"fbillId", (Object)createJobInfo.getBillId());
            param.put((Object)"fbillTypeCode", (Object)createJobInfo.getBillType());
            param.put((Object)"fbillTypeDes", (Object)createJobInfo.getBillTypeName());
            param.put((Object)"fapplyUserName", (Object)createJobInfo.getUserName());
            param.put((Object)"fapplyUserPhone", (Object)this.phoneNumber);
            param.put((Object)"fapplyErpUserName", (Object)createJobInfo.getUserNumber());
            param.put((Object)"fapplyOrganizationCode", (Object)createJobInfo.getOrgNo());
            param.put((Object)"fapplyOrganizationName", (Object)createJobInfo.getOrgName());
            param.put((Object)"ferpDataId", (Object)this.ctx.getAIS());
            param.put((Object)"fsource", (Object)"2");
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("noticImageSysCreateScanJob;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("noticImageSysCreateScanJob:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(createJobInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("noticImageSysCreateScanJob:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return String.valueOf(true);
            }
            this.logger.error((Object)("noticImageSysCreateScanJob:" + errcode + "!description:" + retJsonObj.get("description")));
            try {
                this.logger.error((Object)("noticImageSysCreateScanJob:" + errcode + "!description:" + retJsonObj.get("description") + "fpy /imgsys/bill/signPost/erpBillPush error;"));
                ImageLogInfo logInfo = new ImageLogInfo();
                logInfo.setImageNo(createJobInfo.getBarCode());
                logInfo.setParam("billId:" + createJobInfo.getBillId() + ";imageNumber:" + createJobInfo.getBarCode());
                logInfo.setSuccess(false);
                logInfo.setException("noticImageSysCreateScanJob:" + errcode + "!description:" + retJsonObj.get("description") + "fpy /imgsys/bill/signPost/erpBillPush error;");
                ImageLogFactory.getLocalInstance(this.ctx).writeLog(logInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.valueOf(false);
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("fpy noticImageSysCreateScanJob Exception /imgsys/bill/signPost/erpBillPush error;" + e.getMessage()), (Throwable)e);
                ImageLogInfo logInfo = new ImageLogInfo();
                logInfo.setImageNo(createJobInfo.getBarCode());
                logInfo.setParam("billId:" + createJobInfo.getBillId() + ";imageNumber:" + createJobInfo.getBarCode());
                logInfo.setSuccess(false);
                logInfo.setException("noticImageSysCreateScanJob Exception fpy /imgsys/bill/signPost/erpBillPush error;" + e.getMessage());
                ImageLogFactory.getLocalInstance(this.ctx).writeLog(logInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.valueOf(false);
        }
    }

    @Override
    public String rejectBill(NoticeImageSys2RejectBillInfo rejectBillInfo) throws BOSException, ImageSystemException {
        return null;
    }

    @Override
    public String sendNote(NoticeImageSys2SendNoteInfo sendNote) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        String requestUrl = "";
        try {
            String tail = MultiImageConfig.getPropertiesValue(this.ctx, this.imageSysId, "image.sendnote");
            if (!StringUtils.isBlank((CharSequence)tail)) {
                requestUrl = tail;
            } else {
                requestUrl = this.getPostURLHeader();
                tail = "/scan/bill/outside/review";
                requestUrl = requestUrl + tail;
            }
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(sendNote.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(sendNote).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)sendNote.getBarCode());
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("sendNote;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(sendNote.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u5ba1\u6838\u901a\u8fc7\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u5ba1\u6838\u901a\u8fc7\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";sendNote:" + sendNote + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e, (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGE_COMMON_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u5ba1\u6838\u901a\u8fc7\u51fa\u73b0\u5f02\u5e38.ctx:" + this.ctx.getAIS() + ";" + this.ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";sendNote:" + sendNote + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String getToImageAppParam(NoticeImageSysToAppParamInfo toAppInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public Map<String, String> noticeArchive(NoticeImageSysArchive noticeArchiveInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }
}

