/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.imageNew.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.ImageLogFactory;
import com.kingdee.eas.base.wssc.ImageLogInfo;
import com.kingdee.eas.base.wssc.ImageOperation;
import com.kingdee.eas.base.wssc.ImageSolution;
import org.apache.commons.lang3.StringUtils;

public class ImageLogUtil {
    public static void writeErrLog(Context ctx, String imageNO, ImageOperation operation, String param, String exception) {
        try {
            ImageLogInfo imageLogInfo = new ImageLogInfo();
            imageLogInfo.setImageNo(imageNO);
            imageLogInfo.setOperation(operation);
            if (StringUtils.isNotEmpty((CharSequence)param)) {
                param = param.length() > 1000 ? param.substring(0, 1000) : param;
                imageLogInfo.setParam(param);
            }
            if (StringUtils.isNotEmpty((CharSequence)exception)) {
                exception = exception.length() > 4000 ? exception.substring(0, 4000) : exception;
                imageLogInfo.setException(exception);
            }
            ImageLogFactory.getLocalInstance(ctx).writeLog(imageLogInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void writeImageLog(Context ctx, String imageNO, ImageOperation operation, boolean success, ImageSolution solution, String param, String exception) {
        try {
            ImageLogInfo imageLogInfo = new ImageLogInfo();
            imageLogInfo.setImageNo(imageNO);
            imageLogInfo.setOperation(operation);
            imageLogInfo.setSuccess(success);
            imageLogInfo.setSolution(solution);
            if (StringUtils.isNotEmpty((CharSequence)param)) {
                param = param.length() > 1000 ? param.substring(0, 1000) : param;
                imageLogInfo.setParam(param);
            }
            if (StringUtils.isNotEmpty((CharSequence)exception)) {
                exception = exception.length() > 4000 ? exception.substring(0, 4000) : exception;
                imageLogInfo.setException(exception);
            }
            ImageLogFactory.getLocalInstance(ctx).writeLog(imageLogInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void writeInvokeLog(Context ctx, String imageNO, ImageOperation operation, String param) {
        try {
            ImageLogInfo imageLogInfo = new ImageLogInfo();
            imageLogInfo.setImageNo(imageNO);
            imageLogInfo.setOperation(operation);
            if (StringUtils.isNotEmpty((CharSequence)param)) {
                param = param.length() > 1000 ? param.substring(0, 1000) : param;
                imageLogInfo.setParam(param);
            }
            StringBuilder errStack = new StringBuilder();
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int length = stackTrace.length >= 40 ? 40 : stackTrace.length;
            for (int i = 0; i < length; ++i) {
                StackTraceElement log = stackTrace[i];
                errStack.append("at:").append(log.toString()).append(";");
            }
            if (errStack.length() >= 4000) {
                errStack.setLength(4000);
            }
            imageLogInfo.setException(errStack.toString());
            ImageLogFactory.getLocalInstance(ctx).writeLog(imageLogInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

