/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.know.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.wssc.KnowledgeCollection;
import com.kingdee.eas.base.wssc.KnowledgeFactory;
import com.kingdee.eas.base.wssc.KnowledgeInfo;
import com.kingdee.eas.base.wssc.KnowledgeProFactory;
import com.kingdee.eas.base.wssc.KnowledgeProInfo;
import com.kingdee.eas.base.wssc.KnowledgeProOrgCollection;
import com.kingdee.eas.base.wssc.KnowledgeProOrgFactory;
import com.kingdee.eas.base.wssc.KnowledgeProOrgInfo;
import com.kingdee.eas.base.wssc.KnowledgeQuestionEntryInfo;
import com.kingdee.eas.base.wssc.OrgQuestionInfo;
import com.kingdee.eas.base.wssc.util.FormatUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class KnowledgeUtils {
    private static Logger logger = Logger.getLogger(KnowledgeUtils.class);
    public static final int QUESTION = 0;
    public static final int NEARQUESTION = 1;

    public static void delOrgQuestion(Context ctx, List<String> list) throws BOSException {
        DbUtil.execute((Context)ctx, (String)("DELETE FROM T_WSC_ORGQUESTION WHERE FKNOWLEDGEID IN " + FormatUtils.list2Sql(list) + ""));
    }

    public static List<OrgQuestionInfo> saveOrgQuestion(Context ctx, List<OrgQuestionInfo> list) throws BOSException, EASBizException {
        ArrayList<OrgQuestionInfo> result = new ArrayList<OrgQuestionInfo>();
        if (list.isEmpty()) {
            return list;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> delList = new ArrayList<String>();
        for (OrgQuestionInfo info : list) {
            sb.append("'" + info.getOrgQuestion() + "',");
            delList.add(info.getKnowledgeID());
        }
        try {
            String delsql = "DELETE FROM T_WSC_ORGQUESTION WHERE FKNOWLEDGEID IN " + FormatUtils.list2Sql(delList) + " ";
            DbUtil.execute((Context)ctx, (String)delsql);
            String sql = "SELECT FORGID,FQUESTION,FKNOWLEDGEID,FORGQUESTION,TYPE FROM T_WSC_ORGQUESTION WHERE FORGQUESTION IN (" + sb.toString().substring(0, sb.toString().length() - 1) + ") ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null) {
                while (rowSet.next()) {
                    OrgQuestionInfo info = new OrgQuestionInfo();
                    info.setOrgID(rowSet.getString("FORGID"));
                    info.setQuestion(rowSet.getString("FQUESTION"));
                    info.setKnowledgeID(rowSet.getString("FKNOWLEDGEID"));
                    info.setOrgQuestion(rowSet.getString("FORGQUESTION"));
                    info.setType(rowSet.getInt("TYPE"));
                    result.add(info);
                }
            }
            if (result.size() > 0) {
                int i;
                StringBuilder sb1 = new StringBuilder();
                OrgQuestionInfo resultInfo = null;
                ArrayList<String> orgList = new ArrayList<String>();
                ArrayList<String> knowledgeList = new ArrayList<String>();
                for (int i2 = 0; i2 < result.size(); ++i2) {
                    orgList.add(((OrgQuestionInfo)result.get(i2)).getOrgID());
                    knowledgeList.add(((OrgQuestionInfo)result.get(i2)).getKnowledgeID());
                }
                FullOrgUnitCollection orgCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("where id in " + FormatUtils.list2Sql(orgList) + "");
                HashMap<String, String> orgMap = new HashMap<String, String>();
                for (int i3 = 0; i3 < orgCollection.size(); ++i3) {
                    orgMap.put(orgCollection.get(i3).getId().toString(), orgCollection.get(i3).getName());
                }
                KnowledgeCollection knowledgeCollection = KnowledgeFactory.getLocalInstance(ctx).getKnowledgeCollection("select id,knowledgePro.id,knowledgePro.name where id in " + FormatUtils.list2Sql(knowledgeList) + "");
                HashMap<String, String> knowledgeMap = new HashMap<String, String>();
                for (i = 0; i < knowledgeCollection.size(); ++i) {
                    knowledgeMap.put(knowledgeCollection.get(i).getId().toString(), knowledgeCollection.get(i).getKnowledgePro().getName());
                }
                for (i = 0; i < result.size(); ++i) {
                    resultInfo = (OrgQuestionInfo)result.get(i);
                    if (resultInfo.getType() == 0) {
                        sb1.append("\u7ec4\u7ec7\u3010" + (String)orgMap.get(resultInfo.getOrgID()) + "\u3011\u4e0b\u7684\u95ee\u9898\u3010" + resultInfo.getQuestion() + "\u3011\u5df2\u7ecf\u5728\u65b9\u6848\u540d\u79f0\u3010" + (String)knowledgeMap.get(resultInfo.getKnowledgeID()) + "\u3011\u4e2d\u5b58\u5728\uff01 \uff1b");
                        continue;
                    }
                    sb1.append("\u7ec4\u7ec7\u3010" + (String)orgMap.get(resultInfo.getOrgID()) + "\u3011\u4e0b\u7684\u76f8\u4f3c\u95ee\u6cd5\u3010" + resultInfo.getQuestion() + "\u3011\u5df2\u7ecf\u5728\u65b9\u6848\u540d\u79f0\u3010" + (String)knowledgeMap.get(resultInfo.getKnowledgeID()) + "\u3011\u4e2d\u5b58\u5728\uff01\uff1b");
                }
                NumericExceptionSubItem item = new NumericExceptionSubItem("bs.wssc.knowledge.orgQuestionIsExists", sb1.toString());
                throw new EASBizException(item);
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (OrgQuestionInfo info : list) {
                paramsList.add(new Object[]{info.getOrgID(), info.getQuestion(), info.getKnowledgeID(), info.getOrgQuestion(), info.getType()});
            }
            String column = "FORGID,FQUESTION,FKNOWLEDGEID,FORGQUESTION,TYPE";
            logger.error((Object)("dbType:" + ctx.get((Object)"dbType").toString().toUpperCase()));
            if (ctx.get((Object)"dbType").toString().toUpperCase().contains("POSTGRE")) {
                column = "forgid,fquestion,fknowledgeid,forgquestion,type";
            }
            DbUtil.executeBatch((Context)ctx, (String)("INSERT INTO T_WSC_ORGQUESTION(" + column + ") VALUES (?,?,?,?,?)"), paramsList);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void deleteData(Context ctx, KnowledgeProInfo proInfo) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_WSC_ORGQUESTION WHERE FKNOWLEDGEID in (select fid from t_Wsc_Knowledge where FKnowledgeProID = ?)", (Object[])new Object[]{proInfo.getId().toString()});
    }

    public static List<OrgQuestionInfo> saveBatchOrgQuestion(Context ctx, KnowledgeProInfo proInfo) throws BOSException, EASBizException {
        if (proInfo == null) {
            return null;
        }
        KnowledgeCollection colls = KnowledgeFactory.getLocalInstance(ctx).getKnowledgeCollection("where knowledgePro.id = '" + proInfo.getId().toString() + "'");
        return KnowledgeUtils.saveBatchOrgQuestion(ctx, colls, proInfo.getOrg());
    }

    public static List<OrgQuestionInfo> saveBatchOrgQuestion(Context ctx, KnowledgeCollection knowledgeList) throws BOSException, EASBizException {
        if (knowledgeList.isEmpty()) {
            return null;
        }
        return KnowledgeUtils.saveBatchOrgQuestion(ctx, knowledgeList, null);
    }

    public static List<OrgQuestionInfo> saveBatchOrgQuestion(Context ctx, KnowledgeCollection knowledgeList, KnowledgeProOrgCollection orgCollection) throws BOSException, EASBizException {
        if (knowledgeList.isEmpty()) {
            return null;
        }
        ArrayList<OrgQuestionInfo> list = new ArrayList<OrgQuestionInfo>();
        KnowledgeInfo info = null;
        OrgQuestionInfo oqInfo = null;
        KnowledgeProOrgInfo proorg = null;
        KnowledgeQuestionEntryInfo nearQuestion = null;
        OrgQuestionInfo nearOrgQuestionInfo = null;
        if (orgCollection == null || orgCollection.size() == 0) {
            KnowledgeProInfo proInfo = KnowledgeProFactory.getLocalInstance(ctx).getKnowledgeProInfo((IObjectPK)new ObjectUuidPK(knowledgeList.get(0).getKnowledgePro().getId()));
            orgCollection = KnowledgeProOrgFactory.getLocalInstance(ctx).getKnowledgeProOrgCollection("where knowledgePro.id = '" + proInfo.getId().toString() + "'");
        }
        if (orgCollection != null) {
            for (int i = 0; i < orgCollection.size(); ++i) {
                proorg = orgCollection.get(i);
                for (int k = 0; k < knowledgeList.size(); ++k) {
                    info = knowledgeList.get(k);
                    oqInfo = new OrgQuestionInfo(info.getId().toString(), proorg.getOrg().getId().toString(), proorg.getOrg().getId().toString() + info.getQuestion(), info.getQuestion(), 0);
                    for (int j = 0; j < info.getNearQuestionEntry().size(); ++j) {
                        nearQuestion = info.getNearQuestionEntry().get(j);
                        nearOrgQuestionInfo = new OrgQuestionInfo(info.getId().toString(), proorg.getOrg().getId().toString(), proorg.getOrg().getId().toString() + nearQuestion.getQuestion(), nearQuestion.getQuestion(), 1);
                        list.add(nearOrgQuestionInfo);
                    }
                    list.add(oqInfo);
                }
            }
        }
        return KnowledgeUtils.saveOrgQuestion(ctx, list);
    }
}

