/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLazyLoadCache;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.metadata.view.listeners.MdbviewListenerManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.wssc.image.pojo.TreeDataEntity;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class EntityNodeUtils {
    private Context ctx;

    public EntityNodeUtils(Context ctx) {
        this.ctx = ctx;
    }

    public String getEntityTreeJson() throws BOSException {
        return JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.getEntityTree());
    }

    public TreeDataEntity getEntityTree(boolean isOpen) {
        TreeDataEntity node = this.getEntityTree();
        node.setOpen(isOpen);
        return node;
    }

    public TreeDataEntity getEntityTree() {
        MetaDataPK pk = MetaDataPK.create(null, (String)"com_kingdee_eas_base_subsystemEntity");
        MetaDataBriefViewInfo info = (MetaDataBriefViewInfo)new MetaDataLazyLoadCache(this.ctx).get(MetaDataTypeList.METADATABRIEFVIEW, (IMetaDataPK)pk);
        MetaDataPK2[] mdPk1 = MDLoader.createInstance((Context)this.ctx).cl.getMDContext().pkIndexs.getAddNewPKs(null);
        MetaDataPK2[] mdPk2 = this.getMetaDataPKsAffectMdbview();
        if (mdPk1 != null && mdPk1.length > 0 || mdPk2 != null && mdPk2.length > 0) {
            MetaDataBriefViewInfo info2 = new MetaDataBriefViewInfo();
            MetaDataBriefCollection mdbc = info.getMetaDataBriefs();
            if (mdbc != null) {
                int len = mdbc.size();
                for (int i = 0; i < len; ++i) {
                    info2.getMetaDataBriefs().add(mdbc.get(i));
                }
            }
            info2.setRoot(info.getRoot());
            MdbviewListenerManager.addNew((IMetaDataPK)pk, (MetaDataBriefViewInfo)info2, (MetaDataPK2[])mdPk1, null);
            MdbviewListenerManager.modify((IMetaDataPK)pk, (MetaDataBriefViewInfo)info2, (MetaDataPK2[])mdPk2, null);
            info = info2;
        }
        IBriefViewTreeNode root = this.getRoot(info, (IMetaDataPK)pk);
        TreeDataEntity node = this.getViewRoot(root);
        return node;
    }

    private TreeDataEntity formatIBriefViewTreeNode(IBriefViewTreeNode node) {
        TreeDataEntity entity = new TreeDataEntity();
        if (null != node.getParent()) {
            IBriefViewTreeNode parent = (IBriefViewTreeNode)node.getParent();
            entity.setPId(parent.getFullName());
            entity.setParentId(parent.getFullName());
        } else {
            entity.setPId(null);
            entity.setParentId(null);
        }
        entity.setId(node.getFullName());
        entity.setName(node.getAlias());
        entity.setParent(false);
        return entity;
    }

    protected TreeDataEntity getViewRoot(IBriefViewTreeNode root) {
        TreeDataEntity rootNode = new TreeDataEntity();
        HashMap<String, TreeDataEntity> entityTree = new HashMap<String, TreeDataEntity>();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)root).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            IBriefViewTreeNode tmpNode = (IBriefViewTreeNode)e.nextElement();
            if (!this.accept(tmpNode)) continue;
            MetaDataBriefInfo meta = tmpNode.getMetaDataObjectBriefInfo();
            BriefViewTreeNode node = new BriefViewTreeNode(meta);
            TreeDataEntity entity = this.formatIBriefViewTreeNode((IBriefViewTreeNode)node);
            if (tmpNode.getParent() == null) {
                rootNode = entity;
                entityTree.put(node.getFullName(), rootNode);
                continue;
            }
            String parentFullName = ((IBriefViewTreeNode)tmpNode.getParent()).getFullName();
            TreeDataEntity parentEntity = (TreeDataEntity)entityTree.get(parentFullName);
            if (parentEntity != null) {
                ArrayList<TreeDataEntity> child = parentEntity.getChildren();
                if (child == null) {
                    child = new ArrayList<TreeDataEntity>();
                }
                child.add(entity);
                parentEntity.setParent(true);
                parentEntity.setChildren(child);
            }
            if (!node.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) continue;
            entityTree.put(node.getFullName(), entity);
        }
        return rootNode;
    }

    private IBriefViewTreeNode getRoot(MetaDataBriefViewInfo view, IMetaDataPK pk) {
        MetaDataBriefCollection metas = view.getMetaDataBriefs();
        if (metas == null) {
            throw new NullPointerException("Can't load " + pk);
        }
        HashMap<String, BriefViewTreeNode> tree = new HashMap<String, BriefViewTreeNode>();
        LinkedList<BriefViewTreeNode> listTmp = new LinkedList<BriefViewTreeNode>();
        MetaDataBriefInfo info = null;
        BriefViewTreeNode node = null;
        BriefViewTreeNode root = null;
        IBriefViewTreeNode parent = null;
        int size = metas.size();
        for (int i = 0; i < size; ++i) {
            info = metas.get(i);
            node = new BriefViewTreeNode(info);
            if (root == null && StringUtils.isEmpty((String)info.getParent())) {
                root = node;
            }
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                tree.put(info.getFullName(), node);
            }
            if ((parent = (IBriefViewTreeNode)tree.get(info.getParent())) != null) {
                ((DefaultMutableTreeNode)parent).add((MutableTreeNode)node);
                continue;
            }
            if (root == node) continue;
            listTmp.add(node);
        }
        int len = listTmp.size();
        if (len > 0) {
            for (int i = len - 1; i >= 0; --i) {
                MetaDataBriefInfo mdbi;
                BriefViewTreeNode tn = (BriefViewTreeNode)listTmp.get(i);
                Object uo = tn.getUserObject();
                if (!(uo instanceof MetaDataBriefInfo) || (parent = (IBriefViewTreeNode)tree.get((mdbi = (MetaDataBriefInfo)uo).getParent())) == null) continue;
                ((DefaultMutableTreeNode)parent).insert((MutableTreeNode)tn, 0);
            }
            listTmp.clear();
        }
        listTmp = null;
        return root;
    }

    private MetaDataPK2[] getMetaDataPKsAffectMdbview() {
        Map typeToPks = null;
        try {
            typeToPks = DBConfigureResourceLoader.getMetaDataPKsAffectMdbview(null);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (typeToPks == null) {
            return null;
        }
        ArrayList<MetaDataPK2> rtv = new ArrayList<MetaDataPK2>();
        for (Map.Entry entry : typeToPks.entrySet()) {
            BOSObjectType type = (BOSObjectType)entry.getKey();
            Set pks = (Set)entry.getValue();
            for (MetaDataPK pk : pks) {
                rtv.add(new MetaDataPK2(pk.getFullName(), type.toString()));
            }
        }
        return rtv.toArray(new MetaDataPK2[0]);
    }

    public boolean accept(IBriefViewTreeNode node) {
        if (node.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
            return true;
        }
        BOSObjectType[] bosTypes = new BOSObjectType[]{MetaDataTypeList.ENTITY};
        int len = bosTypes.length;
        for (int i = 0; i < len; ++i) {
            if (!bosTypes[i].equals((Object)node.getMetaDataType())) continue;
            return true;
        }
        return false;
    }
}

