/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util.common;

import com.kingdee.eas.base.wssc.util.common.SSLClient;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static String doPost(String url, String jsonstr, String charset) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        StringEntity se = new StringEntity(jsonstr, "UTF-8");
        httpPost.setEntity((HttpEntity)se);
        return HttpClientUtil.invoke((HttpRequestBase)httpPost, charset, null);
    }

    public static String doPost(String url, String jsonstr, Map<String, String> headMap, String charset) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        StringEntity se = new StringEntity(jsonstr, charset);
        httpPost.setEntity((HttpEntity)se);
        return HttpClientUtil.invoke((HttpRequestBase)httpPost, charset, headMap);
    }

    public static String doPut(String url, String jsonstr, Map<String, String> headMap, String charset) throws Exception {
        HttpPut httpPut = new HttpPut(url);
        StringEntity se = new StringEntity(jsonstr, charset);
        httpPut.setEntity((HttpEntity)se);
        return HttpClientUtil.invoke((HttpRequestBase)httpPut, charset, headMap);
    }

    public static String doDelete(String url, Map<String, String> headMap, String charset) throws Exception {
        HttpDelete httpDelete = new HttpDelete(url);
        return HttpClientUtil.invoke((HttpRequestBase)httpDelete, charset, headMap);
    }

    public static String doGet(String url, String charset) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return HttpClientUtil.invoke((HttpRequestBase)httpGet, charset, null);
    }

    private static String invoke(HttpRequestBase request, String charset, Map<String, String> headMap) throws Exception {
        HttpEntity resEntity;
        SSLClient httpClient = null;
        String result = null;
        httpClient = new SSLClient();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(5000).build();
        request.setConfig(config);
        request.addHeader("Content-Type", "application/json");
        if (headMap != null && !headMap.isEmpty()) {
            Set<String> keySet = headMap.keySet();
            for (String key : keySet) {
                request.addHeader(key, headMap.get(key));
            }
        }
        httpClient.getParams().setParameter("http.connection.timeout", (Object)5000);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)5000);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null && (resEntity = response.getEntity()) != null) {
            result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
        }
        return result;
    }
}

