/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.ClassDefinition;
import com.tool.classfile.Const;
import com.tool.classfile.FieldRef;
import com.tool.classfile.SourceWriter;
import com.tool.classfile.sc;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class FieldDefinition {
    public int access_flags;
    public final String name;
    public final String type;
    public Const initValue;
    public final ClassDefinition parent;
    public final Vector extra_attributes = new Vector();
    public boolean deprecated = false;
    public boolean synthetic = false;

    FieldDefinition(ClassDefinition _parent, String _name, String _type, int _access_flags) {
        this.parent = _parent;
        this.name = _name;
        this.type = _type;
        this.access_flags = _access_flags;
    }

    public FieldRef newReference() {
        return new FieldRef(this.parent.className, this.name, this.type);
    }

    public void dump(PrintWriter out) throws IOException {
        out.println(Modifier.toString(this.access_flags) + " " + sc.javaType(this.type) + " " + this.name);
        out.println("Attributes:");
        if (this.deprecated) {
            out.println("\tDeprecated");
        }
        if (this.synthetic) {
            out.println("\tSynthetic");
        }
        if (this.initValue != null) {
            out.println("\tConstantValue\t" + this.initValue);
        }
        ClassDefinition.dumpExtraAttributes(this.extra_attributes, out);
    }

    void buildAsm(SourceWriter out) throws IOException {
        out.writeString(Modifier.toString(this.access_flags) + " " + sc.javaType(this.type) + " " + this.name);
        if (this.initValue != null) {
            out.writeString("=" + this.initValue.toString());
        }
        out.writeLine(";");
    }

    public String getDeclareString() {
        String s = Modifier.toString(this.access_flags) + " " + sc.javaType(this.type) + " " + this.name;
        if (this.initValue != null) {
            s = s + " = " + this.initValue.toString();
        }
        return s.trim();
    }
}

