/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.ByteCodeReader;
import com.tool.classfile.CodeException;
import com.tool.classfile.Const;
import com.tool.classfile.ConstantPool;
import com.tool.classfile.Context;
import com.tool.classfile.FieldRef;
import com.tool.classfile.InterfaceMethodRef;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.MethodRef;
import com.tool.classfile.binary.CodeAttribute;
import com.tool.classfile.binary.LineNumberAttribute;
import com.tool.classfile.binary.LocalVariableAttribute;
import com.tool.classfile.pcodes.ByteCodes;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.Instruction_array_load;
import com.tool.classfile.pcodes.Instruction_array_store;
import com.tool.classfile.pcodes.Instruction_arraylength;
import com.tool.classfile.pcodes.Instruction_bitwise;
import com.tool.classfile.pcodes.Instruction_checkcast;
import com.tool.classfile.pcodes.Instruction_cmp;
import com.tool.classfile.pcodes.Instruction_const;
import com.tool.classfile.pcodes.Instruction_convert;
import com.tool.classfile.pcodes.Instruction_dup;
import com.tool.classfile.pcodes.Instruction_getfield;
import com.tool.classfile.pcodes.Instruction_getstatic;
import com.tool.classfile.pcodes.Instruction_goto;
import com.tool.classfile.pcodes.Instruction_if;
import com.tool.classfile.pcodes.Instruction_if_cmp;
import com.tool.classfile.pcodes.Instruction_if_null;
import com.tool.classfile.pcodes.Instruction_iinc;
import com.tool.classfile.pcodes.Instruction_instanceof;
import com.tool.classfile.pcodes.Instruction_invoke;
import com.tool.classfile.pcodes.Instruction_invokestatic;
import com.tool.classfile.pcodes.Instruction_jsr;
import com.tool.classfile.pcodes.Instruction_lookup;
import com.tool.classfile.pcodes.Instruction_math;
import com.tool.classfile.pcodes.Instruction_monitorenter;
import com.tool.classfile.pcodes.Instruction_monitorexit;
import com.tool.classfile.pcodes.Instruction_multinewarray;
import com.tool.classfile.pcodes.Instruction_neg;
import com.tool.classfile.pcodes.Instruction_new;
import com.tool.classfile.pcodes.Instruction_newarray;
import com.tool.classfile.pcodes.Instruction_nop;
import com.tool.classfile.pcodes.Instruction_pop;
import com.tool.classfile.pcodes.Instruction_putfield;
import com.tool.classfile.pcodes.Instruction_putstatic;
import com.tool.classfile.pcodes.Instruction_ret;
import com.tool.classfile.pcodes.Instruction_return;
import com.tool.classfile.pcodes.Instruction_shift;
import com.tool.classfile.pcodes.Instruction_swap;
import com.tool.classfile.pcodes.Instruction_switch;
import com.tool.classfile.pcodes.Instruction_throw;
import com.tool.classfile.pcodes.Instruction_var;
import com.tool.classfile.pcodes.Instruction_var_load;
import com.tool.classfile.pcodes.Instruction_var_store;
import com.tool.classfile.pcodes.Label;
import com.tool.classfile.pcodes.LocalVariable;
import com.tool.classfile.sc;
import java.util.Hashtable;
import java.util.Vector;

public class CodesReader
extends ByteCodes {
    public CodesReader(MethodDefinition method, CodeAttribute attr) {
        new _reader(method, attr).read();
    }

    private class _reader {
        ConstantPool pool;
        MethodDefinition method;
        CodeAttribute code;
        Vector labels = new Vector();
        Vector instrs = new Vector();
        ByteCodeReader in;
        private Hashtable var_used = new Hashtable();

        _reader(MethodDefinition _method, CodeAttribute _code) {
            this.method = _method;
            this.pool = this.method.parent.pool;
            Context.setConstantPool(this.pool);
            this.code = _code;
            this.labels.setSize(this.code.code.length + 1);
            this.instrs.setSize(this.code.code.length + 1);
            this.in = new ByteCodeReader(this.code.code);
        }

        void read() {
            LocalVariableAttribute lva;
            CodesReader.this.max_stack = this.code.max_stack;
            CodesReader.this.max_locals = this.code.max_locals;
            int i = 0;
            while (i < this.code.exception_table.length) {
                CodeAttribute.exception_table_struct item = this.code.exception_table[i];
                CodesReader.this.exception_table.addElement(new ByteCodes.ExceptionTable(this.getLabel(item.start_pc), this.getLabel(item.end_pc), this.getLabel(item.handler_pc), this.pool.getClass(item.catch_type)));
                ++i;
            }
            LineNumberAttribute lna = (LineNumberAttribute)this.code.attributes.lookupInfo(this.pool, "LineNumberTable");
            if (lna != null) {
                int i2 = 0;
                while (i2 < lna.line_number_table.length) {
                    Label line_start = this.getLabel(lna.line_number_table[i2].start_pc);
                    line_start.line_number = lna.line_number_table[i2].line_number;
                    ++i2;
                }
            }
            if ((lva = (LocalVariableAttribute)this.code.attributes.lookupInfo(this.pool, "LocalVariableTable")) != null) {
                int i3 = 0;
                while (i3 < lva.local_variable_table.length) {
                    LocalVariableAttribute.local_variable_struct item = lva.local_variable_table[i3];
                    String varName = this.pool.getString(item.name_index);
                    String varType = this.pool.getString(item.descriptor_index);
                    LocalVariable var = item.start_pc == 0 && varName.equals("this") ? this.method._this : new LocalVariable(varName, varType, item.index);
                    ByteCodes.LocalVariableTable vitem = new ByteCodes.LocalVariableTable(var, this.getLabel(item.start_pc), this.getLabel(item.start_pc + item.length));
                    CodesReader.this.local_variable_table.addElement(vitem);
                    ++i3;
                }
            }
            while (!this.in.eof()) {
                int start_pc = this.in.current_pc();
                this.setInstr(start_pc, this.nextInstr());
            }
            int i4 = 0;
            while (i4 <= this.code.code.length) {
                Instruction instr;
                Label label = (Label)this.labels.elementAt(i4);
                if (label != null) {
                    CodesReader.this.codes.addElement(label);
                }
                if ((instr = (Instruction)this.instrs.elementAt(i4)) != null) {
                    CodesReader.this.codes.addElement(instr);
                }
                ++i4;
            }
        }

        Label getLabel(int start_pc) {
            Label label = (Label)this.labels.elementAt(start_pc);
            if (label == null) {
                label = new Label();
                label.start_pc = start_pc;
                this.labels.setElementAt(label, start_pc);
            }
            return label;
        }

        void setInstr(int start_pc, Instruction instr) {
            this.instrs.setElementAt(instr, start_pc);
            instr.start_pc = start_pc;
        }

        Instruction getInstr(int start_pc) {
            Instruction instr = (Instruction)this.instrs.elementAt(start_pc);
            CodeException.assertThat(instr != null);
            return instr;
        }

        Instruction getPrevInstr(int start_pc) {
            while (start_pc-- > 0) {
                if (this.instrs.elementAt(start_pc) == null) continue;
                return (Instruction)this.instrs.elementAt(start_pc);
            }
            return null;
        }

        private boolean isStoreCode(int op_code) {
            switch (op_code) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    return true;
                }
            }
            return false;
        }

        private String getVariableType(int op_code) {
            switch (op_code) {
                case 21: 
                case 54: 
                case 132: {
                    return "I";
                }
                case 22: 
                case 55: {
                    return "J";
                }
                case 23: 
                case 56: {
                    return "F";
                }
                case 24: 
                case 57: {
                    return "D";
                }
                case 25: 
                case 58: 
                case 169: {
                    return "Ljava/lang/Object;";
                }
            }
            throw new CodeException("unknown opcode '" + op_code + "'");
        }

        private int parameterIndex(int index) {
            if (this.method._this != null && index == 0) {
                return -1;
            }
            int i = 0;
            while (i < this.method.args.length) {
                if (this.method.args[i].index == index) {
                    return i;
                }
                ++i;
            }
            return -2;
        }

        private Instruction_var new_var_instr(int op_code, LocalVariable var, int index, int inc_value) {
            if (op_code == 132) {
                return new Instruction_iinc(var, index, inc_value);
            }
            if (op_code == 169) {
                return new Instruction_ret(var, index);
            }
            if (this.isStoreCode(op_code)) {
                return new Instruction_var_store(op_code, var, index);
            }
            return new Instruction_var_load(op_code, var, index);
        }

        private Instruction var_instruction(int op_code, int index, int value, int start_pc, int end_pc) {
            LocalVariable var = null;
            String type = this.getVariableType(op_code);
            Instruction_var instr = null;
            int i = 0;
            while (i < CodesReader.this.local_variable_table.size()) {
                ByteCodes.LocalVariableTable item = (ByteCodes.LocalVariableTable)CodesReader.this.local_variable_table.elementAt(i);
                int declare_pc = item.start.start_pc;
                if (declare_pc != 0) {
                    declare_pc = this.getPrevInstr((int)declare_pc).start_pc;
                }
                if (item.var.index == index && declare_pc <= start_pc) {
                    if (item.var.name != null) {
                        if (item.end.start_pc >= end_pc) {
                            var = item.var;
                            if (index > this.method.args_max_index || this.isStoreCode(op_code) || this.var_used.containsKey(var)) break;
                            var.isParameter = true;
                            int pindex = this.parameterIndex(index);
                            if (pindex >= 0) {
                                this.method.args[pindex] = var;
                                break;
                            }
                            this.method._this = var;
                            break;
                        }
                    } else if (type.equals(sc.pcodeType(item.var.type))) {
                        item.end = this.getLabel(end_pc);
                        var = item.var;
                        break;
                    }
                }
                ++i;
            }
            if (var != null) {
                instr = this.new_var_instr(op_code, var, index, value);
            }
            if (var == null) {
                if (index <= this.method.args_max_index && !this.isStoreCode(op_code)) {
                    int pindex = this.parameterIndex(index);
                    var = pindex == -1 ? this.method._this : this.method.args[pindex];
                    instr = this.new_var_instr(op_code, var, index, value);
                    CodeException.assertThat(pindex >= -1);
                    CodesReader.this.local_variable_table.addElement(new ByteCodes.LocalVariableTable(var, this.getLabel(0), this.getLabel(this.code.code.length)));
                } else {
                    var = new LocalVariable(null, this.getVariableType(op_code), index);
                    instr = this.new_var_instr(op_code, var, index, value);
                    CodesReader.this.local_variable_table.addElement(new ByteCodes.LocalVariableTable(var, this.getLabel(start_pc + instr.length()), this.getLabel(end_pc)));
                }
            }
            this.var_used.put(var, var);
            return instr;
        }

        Instruction nextInstr() {
            int start_pc = this.in.current_pc();
            int op_code = this.in.readu1();
            switch (op_code) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return new Instruction_const(new Const(op_code - 3));
                }
                case 9: {
                    return new Instruction_const(new Const(0L));
                }
                case 10: {
                    return new Instruction_const(new Const(1L));
                }
                case 11: {
                    return new Instruction_const(new Const(0.0f));
                }
                case 12: {
                    return new Instruction_const(new Const(1.0f));
                }
                case 13: {
                    return new Instruction_const(new Const(2.0f));
                }
                case 14: {
                    return new Instruction_const(new Const(0.0));
                }
                case 15: {
                    return new Instruction_const(new Const(1.0));
                }
                case 16: {
                    int value = this.in.readByte();
                    return new Instruction_const(new Const(value));
                }
                case 17: {
                    int value = this.in.readShort();
                    return new Instruction_const(new Const(value));
                }
                case 18: {
                    int index = this.in.readu1();
                    return new Instruction_const((Const)this.pool.get(index));
                }
                case 19: 
                case 20: {
                    int index = this.in.readu2();
                    return new Instruction_const((Const)this.pool.get(index));
                }
                case 1: {
                    return new Instruction_const(null);
                }
                case 0: {
                    return new Instruction_nop();
                }
                case 87: 
                case 88: {
                    return new Instruction_pop(op_code);
                }
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: {
                    return new Instruction_dup(op_code);
                }
                case 95: {
                    return new Instruction_swap();
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    return new Instruction_math(op_code);
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    return new Instruction_neg(op_code);
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: {
                    return new Instruction_shift(op_code);
                }
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    return new Instruction_bitwise(op_code);
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    return new Instruction_convert(op_code);
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    return new Instruction_cmp(op_code);
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    return new Instruction_return(op_code);
                }
                case 190: {
                    return new Instruction_arraylength();
                }
                case 191: {
                    return new Instruction_throw();
                }
                case 194: {
                    return new Instruction_monitorenter();
                }
                case 195: {
                    return new Instruction_monitorexit();
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    return new Instruction_array_load(op_code);
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    return new Instruction_array_store(op_code);
                }
                case 196: {
                    int op_code2 = this.in.readu1();
                    int index = this.in.readu2();
                    int value = op_code2 == 132 ? this.in.readShort() : 0;
                    return this.var_instruction(op_code2, index, value, start_pc, this.in.current_pc());
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    int index = this.in.readu1();
                    return this.var_instruction(op_code, index, 0, start_pc, this.in.current_pc());
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    int index = op_code - 26;
                    return this.var_instruction(21, index, 0, start_pc, this.in.current_pc());
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    int index = op_code - 30;
                    return this.var_instruction(22, index, 0, start_pc, this.in.current_pc());
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    int index = op_code - 34;
                    return this.var_instruction(23, index, 0, start_pc, this.in.current_pc());
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int index = op_code - 38;
                    return this.var_instruction(24, index, 0, start_pc, this.in.current_pc());
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int index = op_code - 42;
                    return this.var_instruction(25, index, 0, start_pc, this.in.current_pc());
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    int index = op_code - 59;
                    return this.var_instruction(54, index, 0, start_pc, this.in.current_pc());
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    int index = op_code - 63;
                    return this.var_instruction(55, index, 0, start_pc, this.in.current_pc());
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    int index = op_code - 67;
                    return this.var_instruction(56, index, 0, start_pc, this.in.current_pc());
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    int index = op_code - 71;
                    return this.var_instruction(57, index, 0, start_pc, this.in.current_pc());
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int index = op_code - 75;
                    return this.var_instruction(58, index, 0, start_pc, this.in.current_pc());
                }
                case 132: {
                    int index = this.in.readu1();
                    int value = this.in.readByte();
                    return this.var_instruction(op_code, index, value, start_pc, this.in.current_pc());
                }
                case 169: {
                    int index = this.in.readu1();
                    return this.var_instruction(op_code, index, 0, start_pc, this.in.current_pc());
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    int offset = this.in.readShort();
                    return new Instruction_if(op_code, this.getLabel(start_pc + offset));
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    int offset = this.in.readShort();
                    return new Instruction_if_cmp(op_code, this.getLabel(start_pc + offset));
                }
                case 167: {
                    int offset = this.in.readShort();
                    return new Instruction_goto(op_code, this.getLabel(start_pc + offset));
                }
                case 168: {
                    int offset = this.in.readShort();
                    return new Instruction_jsr(op_code, this.getLabel(start_pc + offset));
                }
                case 198: 
                case 199: {
                    int offset = this.in.readShort();
                    return new Instruction_if_null(op_code, this.getLabel(start_pc + offset));
                }
                case 200: {
                    int offset = this.in.readInt();
                    return new Instruction_goto(op_code, this.getLabel(start_pc + offset));
                }
                case 201: {
                    int offset = this.in.readInt();
                    return new Instruction_jsr(op_code, this.getLabel(start_pc + offset));
                }
                case 170: {
                    while (this.in.current_pc() % 4 != 0) {
                        this.in.readu1();
                    }
                    int offset = this.in.readInt();
                    Label defaultLabel = this.getLabel(start_pc + offset);
                    int min_value = this.in.readInt();
                    int max_value = this.in.readInt();
                    Label[] targets = new Label[max_value - min_value + 1];
                    int i = 0;
                    while (i < targets.length) {
                        offset = this.in.readInt();
                        targets[i] = this.getLabel(start_pc + offset);
                        ++i;
                    }
                    return new Instruction_switch(min_value, max_value, targets, defaultLabel);
                }
                case 171: {
                    while (this.in.current_pc() % 4 != 0) {
                        this.in.readu1();
                    }
                    int offset = this.in.readInt();
                    Label defaultLabel1 = this.getLabel(start_pc + offset);
                    int count1 = this.in.readu4();
                    int[] values1 = new int[count1];
                    Label[] cases1 = new Label[count1];
                    int i = 0;
                    while (i < count1) {
                        values1[i] = this.in.readInt();
                        offset = this.in.readInt();
                        cases1[i] = this.getLabel(start_pc + offset);
                        ++i;
                    }
                    return new Instruction_lookup(values1, cases1, defaultLabel1);
                }
                case 178: {
                    int index = this.in.readu2();
                    return new Instruction_getstatic((FieldRef)this.pool.get(index));
                }
                case 179: {
                    int index = this.in.readu2();
                    return new Instruction_putstatic((FieldRef)this.pool.get(index));
                }
                case 180: {
                    int index = this.in.readu2();
                    return new Instruction_getfield((FieldRef)this.pool.get(index));
                }
                case 181: {
                    int index = this.in.readu2();
                    return new Instruction_putfield((FieldRef)this.pool.get(index));
                }
                case 182: 
                case 183: {
                    int index = this.in.readu2();
                    return new Instruction_invoke(op_code, (MethodRef)this.pool.get(index));
                }
                case 184: {
                    int index = this.in.readu2();
                    return new Instruction_invokestatic((MethodRef)this.pool.get(index));
                }
                case 185: {
                    int index = this.in.readu2();
                    int arg_count = this.in.readu1();
                    this.in.readu1();
                    InterfaceMethodRef imr = (InterfaceMethodRef)this.pool.get(index);
                    CodeException.assertThat(imr.parameterTypes.length + 1 == arg_count);
                    return new Instruction_invoke(op_code, imr);
                }
                case 187: {
                    int index = this.in.readu2();
                    return new Instruction_new(this.pool.getClass(index));
                }
                case 189: {
                    int index = this.in.readu2();
                    return new Instruction_newarray(op_code, this.pool.getClass(index));
                }
                case 192: {
                    int index = this.in.readu2();
                    return new Instruction_checkcast(this.pool.getClass(index));
                }
                case 193: {
                    int index = this.in.readu2();
                    return new Instruction_instanceof(this.pool.getClass(index));
                }
                case 197: {
                    int index = this.in.readu2();
                    int dims = this.in.readu1();
                    return new Instruction_multinewarray(this.pool.getClass(index), dims);
                }
                case 188: {
                    int array_type = this.in.readu1();
                    String class_type = null;
                    switch (array_type) {
                        case 4: {
                            class_type = "Z";
                            break;
                        }
                        case 8: {
                            class_type = "B";
                            break;
                        }
                        case 5: {
                            class_type = "C";
                            break;
                        }
                        case 9: {
                            class_type = "S";
                            break;
                        }
                        case 10: {
                            class_type = "I";
                            break;
                        }
                        case 11: {
                            class_type = "J";
                            break;
                        }
                        case 6: {
                            class_type = "F";
                            break;
                        }
                        case 7: {
                            class_type = "D";
                            break;
                        }
                        default: {
                            CodeException.assertThat(false);
                        }
                    }
                    return new Instruction_newarray(op_code, class_type);
                }
            }
            throw new CodeException("unknown instruction '" + op_code + "'");
        }
    }
}

