/*
 * Decompiled with CFR 0.152.
 */
package com.tool.simplecode;

import com.tool.classfile.CodeException;
import com.tool.classfile.sc;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.Unit;
import java.io.IOException;

public class Bitwise
extends Unit {
    Unit value1;
    Unit value2;
    String oper;

    public Bitwise(Unit _value1, String _oper, Unit _value2) {
        super(Bitwise.getLevel(_oper));
        this.value1 = Unit.toUnit(_value1);
        this.value2 = Unit.toUnit(_value2);
        this.oper = _oper;
    }

    private static int getLevel(String oper) {
        if (oper.equals("&")) {
            return 8;
        }
        if (oper.equals("^")) {
            return 9;
        }
        if (oper.equals("|")) {
            return 10;
        }
        throw new CodeException("Invoke operator '" + oper + "'");
    }

    protected String genCodes(BuildEnv env, String requiredType) throws IOException {
        String type1 = this.value1.buildCodes(env, "N");
        String type2 = this.value2.buildCodes(env, "N");
        CodeException.assertThat(type1.equals(type2));
        if (!sc.isIntOrLong(type1)) {
            throw new CodeException("invalid bitwise type '" + type1 + "'");
        }
        env.current_block._bitwise(this.oper, type1);
        return type1;
    }

    protected void genSource(BuildEnv env) throws IOException {
        this.value1.buildSource(env, this.level);
        env.out.writeString(" " + this.oper + " ");
        this.value2.buildSource(env, this.level);
    }
}

