/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event;

import com.kingdee.bos.event.EventContextData;
import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.EventExtendedData;
import com.kingdee.bos.event.EventPriority;
import com.kingdee.bos.event.EventSeverity;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.IEventBizHandler;
import com.kingdee.bos.event.IEventContextData;
import com.kingdee.bos.event.IEventExtendedData;
import com.kingdee.bos.event.SystemEntironment;
import com.kingdee.bos.event.exception.EventCompletionException;
import com.kingdee.bos.event.exception.EventValidationException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommonEvent
implements ICommonEvent {
    private static final long serialVersionUID = -7014280968078579286L;
    private String id = Uuid.create().toString();
    private String name = null;
    private String version = null;
    private String solutionName = null;
    private String dataCenterName = null;
    private String hostName = null;
    private String hostIP = null;
    private String group = null;
    private String eventType = null;
    private String eventDefId = null;
    private EventPriority priority = null;
    private EventSeverity severity = null;
    private Date createdTime = null;
    private Date expiredTime = null;
    private Map aliases = new HashMap(3);
    private Map descriptions = null;
    private List eventExtendedDatas = null;
    private List eventContextDatas = null;
    private IEventBizHandler bizHandler = null;

    public CommonEvent(String eventName) {
        this();
        this.name = eventName;
    }

    public CommonEvent() {
        this.createdTime = new Date();
        this.hostIP = SystemEntironment.getInstance().getHostIP();
        this.hostName = SystemEntironment.getInstance().getHostName();
        this.descriptions = new HashMap(3);
        this.eventExtendedDatas = new ArrayList();
        this.eventContextDatas = new ArrayList();
    }

    @Override
    public String getEventDefId() {
        return this.eventDefId;
    }

    @Override
    public void setEventDefId(String eventDefId) {
        this.eventDefId = eventDefId;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public String getDataCenterName() {
        return this.dataCenterName;
    }

    @Override
    public String getSolutionName() {
        return this.solutionName;
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias(Locale locale) {
        return (String)this.aliases.get(locale);
    }

    @Override
    public EventPriority getPriority() {
        return this.priority;
    }

    @Override
    public EventSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public String getDescription(Locale locale) {
        return (String)this.descriptions.get(locale);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setAlias(Locale locale, String alias) {
        this.aliases.put(locale, alias);
    }

    @Override
    public void setSolutionName(String solutionName) {
        this.solutionName = solutionName;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public void setDataCenterName(String dataCenterName) {
        this.dataCenterName = dataCenterName;
    }

    @Override
    public void setDescription(Locale locale, String description) {
        this.descriptions.put(locale, description);
    }

    @Override
    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPriority(EventPriority priority) {
        this.priority = priority;
    }

    @Override
    public void setSeverity(EventSeverity severity) {
        this.severity = severity;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void complete() throws EventCompletionException, EventValidationException {
        if (this.bizHandler != null) {
            this.bizHandler.completeEvent(this);
        }
    }

    @Override
    public IEventBizHandler getBizHandler() {
        return this.bizHandler;
    }

    @Override
    public void addExtendedData(IEventExtendedData extendedData) throws EventValidationException {
        extendedData.validate();
        if (!this.existExtendedData(extendedData.getName())) {
            this.eventExtendedDatas.add(extendedData);
        }
    }

    @Override
    public void addExtendedData(String name, EventDataType eventDataType, Object value) throws EventValidationException {
        if (!this.existExtendedData(name)) {
            EventExtendedData extendedData = new EventExtendedData(name, eventDataType, value);
            extendedData.validate();
            this.eventExtendedDatas.add(extendedData);
        }
    }

    @Override
    public boolean existExtendedData(String name) {
        int size = this.eventExtendedDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventExtendedData extendedData = (IEventExtendedData)this.eventExtendedDatas.get(i);
            if (!extendedData.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEventExtendedData getExtendedData(String name) {
        int size = this.eventExtendedDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventExtendedData extendedData = (IEventExtendedData)this.eventExtendedDatas.get(i);
            if (!extendedData.getName().equals(name)) continue;
            return extendedData;
        }
        return null;
    }

    @Override
    public Object getExtendedDataValue(String name) {
        IEventExtendedData extendedData = this.getExtendedData(name);
        if (extendedData != null) {
            return extendedData.getValue();
        }
        return null;
    }

    @Override
    public List getExtendedDatas() {
        return this.eventExtendedDatas;
    }

    @Override
    public void removeExtendedData(String name) {
        Iterator iterator = this.eventExtendedDatas.iterator();
        while (iterator.hasNext()) {
            IEventExtendedData extendedData = (IEventExtendedData)iterator.next();
            if (!extendedData.getName().equals(name)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public void setExtendedDataValue(String name, EventDataType eventDataType, Object value) throws EventValidationException {
        int size = this.eventExtendedDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventExtendedData extendedData = (IEventExtendedData)this.eventExtendedDatas.get(i);
            if (!extendedData.getName().equals(name)) continue;
            EventDataType oldDataType = extendedData.getDataType();
            Object oldValue = extendedData.getValue();
            extendedData.setDataType(eventDataType);
            extendedData.setValue(value);
            try {
                extendedData.validate();
                continue;
            }
            catch (EventValidationException e) {
                extendedData.setDataType(oldDataType);
                extendedData.setValue(oldValue);
                throw e;
            }
        }
    }

    @Override
    public void setExtendedDataValue(String name, Object value) {
        int size = this.eventExtendedDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventExtendedData extendedData = (IEventExtendedData)this.eventExtendedDatas.get(i);
            if (!extendedData.getName().equals(name)) continue;
            extendedData.setValue(value);
        }
    }

    @Override
    public void addContextData(IEventContextData contextData) {
        if (!this.existContextData(contextData.getName())) {
            this.eventContextDatas.add(contextData);
        }
    }

    @Override
    public void addContextData(String name, String value) {
        if (!this.existContextData(name)) {
            EventContextData contextData = new EventContextData(name, value);
            this.eventContextDatas.add(contextData);
        }
    }

    @Override
    public boolean existContextData(String name) {
        int size = this.eventExtendedDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventExtendedData extendedData = (IEventExtendedData)this.eventExtendedDatas.get(i);
            if (!extendedData.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEventContextData getContextData(String name) {
        int size = this.eventContextDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventContextData contextData = (IEventContextData)this.eventContextDatas.get(i);
            if (!contextData.getName().equals(name)) continue;
            return contextData;
        }
        return null;
    }

    @Override
    public List getContextDatas() {
        return this.eventContextDatas;
    }

    @Override
    public String getContextDataValue(String name) {
        IEventContextData eventContextData = this.getContextData(name);
        if (eventContextData != null) {
            return eventContextData.getValue();
        }
        return null;
    }

    @Override
    public void removeContextData(String name) {
        Iterator iterator = this.eventContextDatas.iterator();
        while (iterator.hasNext()) {
            IEventContextData contextData = (IEventContextData)iterator.next();
            if (!contextData.getName().equals(name)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public void setContextDataValue(String name, String value) {
        int size = this.eventContextDatas.size();
        for (int i = 0; i < size; ++i) {
            IEventContextData contextData = (IEventContextData)this.eventContextDatas.get(i);
            if (!contextData.getName().equals(name)) continue;
            contextData.setValue(value);
        }
    }

    @Override
    public void setBizHandler(IEventBizHandler bizHandler) {
        this.bizHandler = bizHandler;
    }

    @Override
    public void validate() throws EventValidationException {
        if (StringUtils.isEmpty((String)this.name) || StringUtils.isEmpty((String)this.id)) {
            throw new EventValidationException("Event name or id is empty");
        }
    }

    @Override
    public Map getAliases() {
        return this.aliases;
    }

    @Override
    public Map getDescriptions() {
        return this.descriptions;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public Date getExpiredTime() {
        return this.expiredTime;
    }

    @Override
    public void setExpiredTime(Date expiredTime) {
        this.expiredTime = expiredTime;
    }
}

