/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.event.adapter.BOSEventServiceAdapter;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.util.ServerUtils;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.ServiceManagerFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class BOSEventListener
implements ServletContextListener {
    Logger logger = Logger.getLogger(BOSEventListener.class);
    BOSEventServiceAdapter bosAdapter;

    public void contextInitialized(ServletContextEvent arg0) {
        BOSEventUtils.debugLogger(this.logger, "========== BOSEventListener initialized ==========");
        this.initBOSEventAdapter();
        this.startServer();
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        BOSEventUtils.debugLogger(this.logger, "========== BOSEventListener Destroyed ==========");
        try {
            ServiceManagerFactory.getServiceManager().unregisterService((IServiceAdapter)this.bosAdapter);
            ServiceManagerFactory.getServiceManager().disableService((IServiceAdapter)this.bosAdapter);
        }
        catch (CannotCreateServiceManagerException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initBOSEventAdapter() {
        try {
            this.bosAdapter = new BOSEventServiceAdapter();
            ServiceManagerFactory.getServiceManager().registerService((IServiceAdapter)this.bosAdapter);
            ServiceManagerFactory.getServiceManager().enableService((IServiceAdapter)this.bosAdapter);
        }
        catch (CannotCreateServiceManagerException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void startServer() {
        ServerUtils.getEventServer(ServerUtils.generateServerKey());
    }
}

