/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.event.adapter.BOSEntityMappingInfo;
import com.kingdee.bos.event.adapter.BOSParameterMappingInfo;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BOSEventMappingConfig {
    private Logger logger = Logger.getLogger(BOSEventMappingConfig.class);
    private static BOSEventMappingConfig instance;
    private static final String EAS_DEPLOY = "eas.deploy";
    public static final String CONFIGFILE_NAME = "eventMappingConfig.xml";
    private static final String DEFAULT_MAPPINGRULE = "com.kingdee.bos.event.adapter.DefaultEventMappingRule";
    private List eventMappingInfos = new ArrayList();
    private String mappingRule = "com.kingdee.bos.event.adapter.DefaultEventMappingRule";
    private String configFilePath = null;

    private BOSEventMappingConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOSEventMappingConfig getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<BOSEventMappingConfig> clazz = BOSEventMappingConfig.class;
        synchronized (BOSEventMappingConfig.class) {
            if (instance == null) {
                instance = new BOSEventMappingConfig();
                instance.loadConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadConfig() {
        String deployDir = System.getProperty(EAS_DEPLOY);
        if (!StringUtils.isEmpty((String)deployDir)) {
            this.configFilePath = deployDir + "/" + CONFIGFILE_NAME;
            try {
                this.parseConfigFile(this.configFilePath);
            }
            catch (IOException e) {
                this.logger.error((Object)("can't parse " + this.configFilePath + ",please checkout the file format!"), (Throwable)e);
            }
        } else {
            this.logger.error((Object)"fatal error,Can't find 'eas.deploy' config path,please check!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConfigFile(String filePath) throws IOException {
        this.ondemandCreate(filePath);
        try (FileInputStream input = new FileInputStream(new File(filePath));){
            Document doc = new SAXBuilder().build((InputStream)input);
            Element elementRoot = doc.getRootElement();
            List eventList = elementRoot.getChildren();
            this.mappingRule = elementRoot.getAttributeValue("mappingRule");
            int length = eventList.size();
            for (int i = 0; i < length; ++i) {
                Element ele = (Element)eventList.get(i);
                EventMappingInfo info = this.parseElement(ele);
                this.eventMappingInfos.add(info);
            }
        }
    }

    private void ondemandCreate(String filePath) {
        try {
            File configFile = new File(filePath);
            if (!configFile.exists()) {
                Document doc = new Document();
                Element rootElement = new Element("config");
                rootElement.setAttribute("mappingRule", "");
                doc.setRootElement(rootElement);
                this.save(doc);
            }
        }
        catch (IOException e) {
            this.logger.warn((Object)("ondemand create " + filePath + " failed." + e));
        }
    }

    private EventMappingInfo parseElement(Element ele) {
        EventMappingInfo info = new EventMappingInfo();
        info.setName(ele.getAttributeValue("name"));
        info.setProducer(ele.getAttributeValue("producer"));
        info.setMappingRule(ele.getAttributeValue("mappingRule"));
        List mapping = ele.getChildren();
        ArrayList<BOSEntityMappingInfo> entityMappingInfos = new ArrayList<BOSEntityMappingInfo>();
        for (int i = 0; i < mapping.size(); ++i) {
            Element element = (Element)mapping.get(i);
            entityMappingInfos.add(this.parseMappingElement(element));
        }
        info.setEventMappingInfos(entityMappingInfos);
        return info;
    }

    private BOSEntityMappingInfo parseMappingElement(Element element) {
        BOSEntityMappingInfo info = new BOSEntityMappingInfo();
        info.setBosType(element.getAttributeValue("bosType"));
        info.setMethodName(element.getAttributeValue("methodName"));
        info.setMethodPk(element.getAttributeValue("methodPk"));
        info.setEntityName(element.getAttributeValue("entityName"));
        info.setEntityDescription(element.getAttributeValue("description"));
        ArrayList<BOSParameterMappingInfo> parameterMappings = new ArrayList<BOSParameterMappingInfo>();
        Element parameterMappingsElement = element.getChild("parameterMappings");
        if (parameterMappingsElement != null) {
            List children = parameterMappingsElement.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element pmElement = (Element)children.get(i);
                parameterMappings.add(this.parseParameterMappingElement(pmElement));
            }
        }
        info.setParameterMappings(parameterMappings);
        return info;
    }

    private BOSParameterMappingInfo parseParameterMappingElement(Element pmElement) {
        BOSParameterMappingInfo info = new BOSParameterMappingInfo();
        info.setFormalParameterName(pmElement.getAttributeValue("formalParameterName"));
        info.setActualParameterIndex(pmElement.getAttributeValue("actualParameterIndex"));
        info.setBOPK(Boolean.valueOf(pmElement.getAttributeValue("isBOPK")));
        info.setDescription(pmElement.getAttributeValue("description"));
        return info;
    }

    private boolean isExist(EventMappingInfo eventMappingInfo) {
        for (EventMappingInfo info : this.eventMappingInfos) {
            if (!this.isEqueal(eventMappingInfo, info)) continue;
            return true;
        }
        return false;
    }

    private boolean isExist(String eventName) {
        for (EventMappingInfo info : this.eventMappingInfos) {
            if (eventName == null || !eventName.equalsIgnoreCase(info.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isEqueal(EventMappingInfo eventMappingInfo, EventMappingInfo info) {
        String src = eventMappingInfo.getName();
        String dom = info.getName();
        return src != null && src.equalsIgnoreCase(dom);
    }

    private boolean isEqueal(Element eventMappingInfoElement, Element element) {
        String src = eventMappingInfoElement.getAttributeValue("name");
        String dom = element.getAttributeValue("name");
        return src != null && src.equalsIgnoreCase(dom);
    }

    private boolean isEqual(String src, String str) {
        return src != null && src.equalsIgnoreCase(str);
    }

    public void saveEventMappingInfo(EventMappingInfo eventMappingInfo) throws IOException {
        Element eventMappingInfoElement = this.genEventMappingInfoElement(eventMappingInfo);
        if (!this.isExist(eventMappingInfo)) {
            try {
                Document doc = new SAXBuilder().build(this.configFilePath);
                doc.getRootElement().addContent((Content)eventMappingInfoElement);
                this.save(doc);
                this.eventMappingInfos.add(eventMappingInfo);
            }
            catch (JDOMException e) {
                this.logger.error((Object)"", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        } else {
            try {
                int index;
                Document doc = new SAXBuilder().build(this.configFilePath);
                List list = doc.getRootElement().getChildren("commonevent");
                for (index = 0; index < list.size(); ++index) {
                    Element e = (Element)list.get(index);
                    if (!this.isEqueal(eventMappingInfoElement, e)) continue;
                    list.remove(e);
                    list.add(index, eventMappingInfoElement);
                    break;
                }
                this.save(doc);
                for (index = 0; index < this.eventMappingInfos.size(); ++index) {
                    EventMappingInfo info = (EventMappingInfo)this.eventMappingInfos.get(index);
                    if (!this.isEqueal(eventMappingInfo, info)) continue;
                    this.eventMappingInfos.remove(info);
                    this.eventMappingInfos.add(index, eventMappingInfo);
                    break;
                }
            }
            catch (JDOMException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
    }

    public void deleteEventMappingInfo(String eventName) throws IOException {
        if (this.isExist(eventName)) {
            try {
                int index;
                Document doc = new SAXBuilder().build(this.configFilePath);
                List list = doc.getRootElement().getChildren("commonevent");
                for (index = 0; index < list.size(); ++index) {
                    Element e = (Element)list.get(index);
                    if (!this.isEqual(eventName, e.getAttributeValue("name"))) continue;
                    list.remove(e);
                    break;
                }
                this.save(doc);
                for (index = 0; index < this.eventMappingInfos.size(); ++index) {
                    EventMappingInfo info = (EventMappingInfo)this.eventMappingInfos.get(index);
                    if (!this.isEqual(eventName, info.getName())) continue;
                    this.eventMappingInfos.remove(info);
                    break;
                }
            }
            catch (JDOMException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
    }

    private void save(Document doc) throws IOException {
        if (this.configFilePath != null) {
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(this.configFilePath));
                XMLOutputter out = new XMLOutputter();
                Format format = Format.getPrettyFormat();
                out.setFormat(format);
                out.output(doc, os);
            }
            catch (IOException e) {
                this.logger.error((Object)"", (Throwable)e);
                throw e;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e);
                    }
                }
            }
        }
    }

    private Element genEventMappingInfoElement(EventMappingInfo eventMappingInfo) {
        Element element = new Element("commonevent");
        element.addContent((Content)new Comment("CES Gen CommentEvent Mapping"));
        element.setAttribute("name", this.toStringValue(eventMappingInfo.getName()));
        element.setAttribute("producer", this.toStringValue(eventMappingInfo.getProducer()));
        element.setAttribute("mappingRule", this.toStringValue(eventMappingInfo.getMappingRule()));
        if (eventMappingInfo.getEventMappingInfos() != null) {
            for (BOSEntityMappingInfo entityMappingInfo : eventMappingInfo.getEventMappingInfos()) {
                element.addContent((Content)this.genBOSEntitiyMappingInfo(entityMappingInfo));
            }
        }
        return element;
    }

    private Element genBOSEntitiyMappingInfo(BOSEntityMappingInfo entityMappingInfo) {
        Element element = new Element("mapping");
        element.setAttribute("bosType", this.toStringValue(entityMappingInfo.getBosType()));
        element.setAttribute("entityName", this.toStringValue(entityMappingInfo.getEntityName()));
        element.setAttribute("methodName", this.toStringValue(entityMappingInfo.getMethodName()));
        element.setAttribute("methodPk", this.toStringValue(entityMappingInfo.getMethodPk()));
        element.setAttribute("description", this.toStringValue(entityMappingInfo.getEntityDescription()));
        if (entityMappingInfo.getParameterMappings() != null) {
            Element pms = new Element("parameterMappings");
            for (BOSParameterMappingInfo parameterMappingInfo : entityMappingInfo.getParameterMappings()) {
                pms.addContent((Content)this.genBOSParameterMappingInfo(parameterMappingInfo));
            }
            element.addContent((Content)pms);
        }
        return element;
    }

    private Element genBOSParameterMappingInfo(BOSParameterMappingInfo parameterMappingInfo) {
        Element element = new Element("parameterMapping");
        element.setAttribute("formalParameterName", this.toStringValue(parameterMappingInfo.getFormalParameterName()));
        element.setAttribute("actualParameterIndex", this.toStringValue(parameterMappingInfo.getActualParameterIndex()));
        element.setAttribute("isBOPK", Boolean.toString(parameterMappingInfo.isBOPK()));
        element.setAttribute("description", this.toStringValue(parameterMappingInfo.getDescription()));
        return element;
    }

    private String toStringValue(String str) {
        return str == null ? "" : str;
    }

    public List getEventMappingInfos() {
        return this.eventMappingInfos;
    }

    public String getMappingRule() {
        return this.mappingRule;
    }

    public String getDefaultMappingRule() {
        return DEFAULT_MAPPINGRULE;
    }
}

