/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.adapter.BOSEntityMappingInfo;
import com.kingdee.bos.event.adapter.BOSEventMappingConfig;
import com.kingdee.bos.event.adapter.BOSEventServiceConfig;
import com.kingdee.bos.event.adapter.DefaultEventMappingRule;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.adapter.IEventMappingRule;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.event.model.IResourceHandler;
import com.kingdee.bos.event.model.ResourceHandler;
import com.kingdee.bos.event.model.cem.CEMFactory;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.event.model.cem.DocumentRoot;
import com.kingdee.bos.event.model.cem.ExtendedData;
import com.kingdee.bos.event.util.Utilities;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.FormalParameterCollection;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.event.ParameterMappingCollection;
import com.kingdee.bos.metadata.event.ParameterMappingInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class BOSEventUtils {
    private static final Logger logger = Logger.getLogger(BOSEventUtils.class);

    public static boolean getEventAdapterStatus() {
        return BOSEventServiceConfig.getInstance().isEnable();
    }

    public static void debugLogger(Logger logger, Object debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug(debugInfo);
        }
    }

    public static EventMappingInfo[] getMatchedEventMappingInfos(IServiceContext serviceContext) {
        try {
            return BOSEventUtils.getEventMappingRule().getMatchedEventMappingInfos(serviceContext);
        }
        catch (CommonEventException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static EventMappingInfo[] getMatchedEventMappingInfos(String mappingRule, IServiceContext serviceContext) {
        try {
            return BOSEventUtils.getEventMappingRule(mappingRule).getMatchedEventMappingInfos(serviceContext);
        }
        catch (CommonEventException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static BOSEntityMappingInfo[] getMatchedMappingInfos(IServiceContext serviceContext, EventMappingInfo mappingInfo) {
        try {
            return BOSEventUtils.getEventMappingRule().getMatchedMappingInfos(serviceContext, mappingInfo);
        }
        catch (CommonEventException e) {
            logger.error((Object)e);
            return null;
        }
    }

    private static IEventMappingRule getEventMappingRule(String mappingRule) {
        IEventMappingRule rule = null;
        if (StringUtils.isEmpty((String)mappingRule)) {
            mappingRule = BOSEventMappingConfig.getInstance().getDefaultMappingRule();
        }
        try {
            Class<?> ruleClass = Class.forName(mappingRule);
            rule = (IEventMappingRule)ruleClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"BOSEventUtils.getEventMappingRule Excecption..", (Throwable)e);
        }
        return rule;
    }

    private static IEventMappingRule getEventMappingRule() {
        String mappingRule = BOSEventMappingConfig.getInstance().getMappingRule();
        if (StringUtils.isEmpty((String)mappingRule)) {
            mappingRule = BOSEventMappingConfig.getInstance().getDefaultMappingRule();
        }
        IEventMappingRule rule = new DefaultEventMappingRule();
        try {
            Class<?> ruleClass = Class.forName(mappingRule);
            rule = (IEventMappingRule)ruleClass.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"BOSEventUtils.getEventMappingRule Excecption..", (Throwable)e);
        }
        return rule;
    }

    public static String getMethodNamebyOperationPk(BOSObjectType boType, IMetaDataPK methodPk, Context context) {
        if (boType == null || methodPk == null || context == null) {
            return "";
        }
        String methodName = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)context);
        EntityObjectInfo entity = loader.getEntity(boType);
        MethodCollection methodCollection = entity.getAllMethodsRuntime();
        for (int i = 0; i < methodCollection.size(); ++i) {
            MethodInfo methodInfo = methodCollection.get(i);
            if (!methodInfo.getInnerID().equalsIgnoreCase(methodPk.toString())) continue;
            methodName = methodInfo.getName();
            break;
        }
        return methodName;
    }

    public static List getMatchedEventMappingInfoByBosType(BOSObjectType boType) {
        ArrayList<EventMappingInfo> result = new ArrayList<EventMappingInfo>();
        List allInfos = BOSEventMappingConfig.getInstance().getEventMappingInfos();
        block0: for (int i = 0; i < allInfos.size(); ++i) {
            EventMappingInfo info = (EventMappingInfo)allInfos.get(i);
            List mappingInfos = info.getEventMappingInfos();
            for (int j = 0; j < mappingInfos.size(); ++j) {
                BOSEntityMappingInfo mappingInfo = (BOSEntityMappingInfo)mappingInfos.get(j);
                if (StringUtils.isEmpty((String)mappingInfo.getBosType()) || !mappingInfo.getBosType().equalsIgnoreCase(boType.toString())) continue;
                result.add(info);
                continue block0;
            }
        }
        return result;
    }

    public static String[] getBoId(ServiceContext serviceContext) {
        Object[] params = serviceContext.getOperationParameters();
        if (params == null || params.length <= 0) {
            return new String[0];
        }
        Object param = params[0];
        if (param == null) {
            return new String[0];
        }
        if (param instanceof Context && params.length > 1 && params[1] != null) {
            param = params[1];
        }
        if (param instanceof IObjectPK || param instanceof BOSUuid) {
            return new String[]{param.toString()};
        }
        if (param instanceof IObjectValue) {
            IObjectValue objVal = (IObjectValue)param;
            return new String[]{BOSEventUtils.getBopkByObjectValue(objVal)};
        }
        if (param instanceof IObjectPK[]) {
            IObjectPK[] objectPKs = (IObjectPK[])param;
            String[] result = new String[objectPKs.length];
            for (int i = 0; i < objectPKs.length; ++i) {
                result[i] = objectPKs[i].toString();
            }
            return result;
        }
        if (param instanceof IObjectCollection) {
            IObjectCollection objectCollection = (IObjectCollection)param;
            String[] result = new String[objectCollection.size()];
            for (int i = 0; i < objectCollection.size(); ++i) {
                IObjectValue objectValue = objectCollection.getObject(i);
                result[i] = BOSEventUtils.getBopkByObjectValue(objectValue);
            }
            return result;
        }
        return new String[0];
    }

    private static String getBopkByObjectValue(IObjectValue objectValue) {
        String objValPkField = objectValue.getPKField();
        if (objValPkField == null || objValPkField.length() == 0) {
            logger.error((Object)("objectValue's PkField is null. class '" + objectValue.getClass().getName() + "'"));
        }
        return objectValue.get(objValPkField) != null ? objectValue.get(objValPkField).toString() : "";
    }

    public static String getOperationType(ServiceContext serviceContext) {
        String methodName = BOSEventUtils.getMethodNamebyOperationPk(serviceContext.getBoType(), serviceContext.getOperationPK(), serviceContext.getContext());
        if (StringUtils.isEmpty((String)methodName)) {
            return "other";
        }
        if (methodName.startsWith("addnew") || methodName.startsWith("submit") || methodName.startsWith("save")) {
            return "add";
        }
        if (methodName.startsWith("update")) {
            return "update";
        }
        if (methodName.startsWith("delete")) {
            return "delete";
        }
        return "other";
    }

    public static String getCanonicalName(Object value) {
        if (value == null) {
            return null;
        }
        return BOSEventUtils.getCanonicalName(value.getClass());
    }

    public static String getCanonicalName(Class c) {
        if (c == null) {
            return null;
        }
        if (c.isArray()) {
            Class<?> ct = c.getComponentType();
            return ct.getName() + "[]";
        }
        return c.getName();
    }

    public static void generateCEMFromBOSEvent(EventInfo[] eventInfos, String savePath) throws BOSException {
        BOSEventUtils.validataArgs(eventInfos, savePath);
        Element mappingElementRoot = BOSEventUtils.getMappingElementRoot();
        ResourceHandler resourceHandler = new ResourceHandler();
        for (int i = 0; i < eventInfos.length; ++i) {
            CommonEvent cemodel = BOSEventUtils.generateCEMFromBOSEvent(eventInfos[i], savePath, resourceHandler);
            BOSEventUtils.generateEventMapping(mappingElementRoot, cemodel, eventInfos[i]);
        }
        BOSEventUtils.storeEventMapping(mappingElementRoot, savePath + "/" + "eventMappingConfig.xml");
    }

    public static CommonEvent generateCEMFromBOSEvent(EventInfo eventInfo, String savePath) throws BOSException {
        if (eventInfo == null || StringUtils.isEmpty((String)savePath)) {
            throw new BOSException("generateCEMFromBOSEvent args can't be null");
        }
        return BOSEventUtils.generateCEMFromBOSEvent(eventInfo, savePath, new ResourceHandler());
    }

    public static String bosTypeToCommoneventType(String bosDataType) throws BOSException {
        if (StringUtils.isEmpty((String)bosDataType)) {
            return "";
        }
        Class paramClass = null;
        if (bosDataType.trim().equalsIgnoreCase(DataType.OBJECTVALUE.toString())) {
            return "com.kingdee.bos.dao.IObjectValue";
        }
        if (bosDataType.trim().equalsIgnoreCase(DataType.OBJECTCOLLECTION.getName())) {
            return "com.kingdee.bos.dao.IObjectValue[]";
        }
        paramClass = ObjectUtils.getArgumentTypeClass((String)bosDataType);
        EventDataType type = EventDataType.getEnum(BOSEventUtils.getCanonicalName(paramClass));
        if (type == null) {
            type = EventDataType.TYPE_OBJECT;
        }
        return type.getValue();
    }

    private static void storeEventMapping(Element mappingElementRoot, String savePath) throws BOSException {
        try {
            FileOutputStream fileOut = new FileOutputStream(savePath);
            XMLOutputter outputter = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            outputter.setFormat(format);
            format.setEncoding("utf-8");
            outputter.output(mappingElementRoot.getDocument(), (OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static CommonEvent generateCEMFromBOSEvent(EventInfo eventInfo, String savePath, IResourceHandler resourceHandler) throws BOSException {
        CommonEvent ce = CEMFactory.eINSTANCE.createCommonEvent();
        String entityName = eventInfo.getExtendedProperty("entityFullName");
        String eventName = entityName + "." + eventInfo.getName();
        ce.setId(BOSUuid.create((String)"COMMNEVT").toString());
        ce.setName(eventName);
        ce.setAlias(eventInfo.getAlias());
        ce.setDescription(eventInfo.getDescription());
        ce.setVersion("1.0");
        ce.setGroup("BOSEvent");
        ce.setType("BOSGen");
        ce.setExpirationDate(BOSEventUtils.generateDefaultExpiredDate());
        ce.setPriority(String.valueOf(50));
        ce.setSeverity(String.valueOf(20));
        if (ce.getExtendedDatas() == null) {
            ce.setExtendedDatas(CEMFactory.eINSTANCE.createExtendedDatas());
        }
        FormalParameterCollection formalParameterCollection = eventInfo.getFormalParameters();
        for (FormalParameterInfo formalParameterInfo : formalParameterCollection) {
            ParameterInfo parameterInfo = formalParameterInfo.getParameter();
            if (parameterInfo == null) continue;
            ExtendedData data = CEMFactory.eINSTANCE.createExtendedData();
            data.setName(parameterInfo.getName());
            data.setDataType(BOSEventUtils.bosTypeToCommoneventType(parameterInfo.getDataType()));
            data.setMappingParameterName(parameterInfo.getMetaDataRef());
            ce.getExtendedDatas().getExtendedData().add((Object)data);
        }
        try {
            DocumentRoot documentRoot = CEMFactory.eINSTANCE.createDocumentRoot();
            documentRoot.setCommonEvent(ce);
            resourceHandler.saveResource(BOSEventUtils.concatFilePath(savePath, eventName), documentRoot);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ce;
    }

    private static String genBOSType(String pk) {
        if (pk != null) {
            int hash = pk.hashCode();
            String type = Integer.toHexString(hash).toUpperCase();
            if (type.length() > 8) {
                type = type.substring(0, 8);
            } else if (type.length() < 8) {
                int n = type.length();
                for (int i = 0; i < 8 - n; ++i) {
                    type = "0" + type;
                }
            }
            return type;
        }
        return "";
    }

    private static void validataArgs(EventInfo[] eventInfos, String savePath) throws BOSException {
        boolean sucess;
        if (eventInfos == null || StringUtils.isEmpty((String)savePath)) {
            throw new BOSException("generateCEMFromBOSEvent args can't be null");
        }
        if (eventInfos.length <= 0) {
            return;
        }
        File dir = new File(savePath);
        if (dir.exists() && !dir.isDirectory()) {
            throw new BOSException("the savePath must be directory");
        }
        if (!dir.exists() && !(sucess = dir.mkdirs())) {
            throw new BOSException("create directory fail.please check" + dir.toString());
        }
    }

    private static String concatFilePath(String directoryPath, String eventName) {
        if (eventName.indexOf(".") > -1) {
            eventName = StringUtils.replace((String)eventName, (String)".", (String)"/");
        }
        return directoryPath + "/" + eventName + ".cem";
    }

    private static void generateEventMapping(Element mappingElementRoot, CommonEvent cemodel, EventInfo eventInfo) {
        if (mappingElementRoot == null || cemodel == null || eventInfo == null || eventInfo.getEventMethods().size() <= 0) {
            return;
        }
        Element[] mappingElement = BOSEventUtils.generateMappingElement(eventInfo);
        if (mappingElementRoot.getChild(cemodel.getName()) != null) {
            Element ele = mappingElementRoot.getChild(cemodel.getName());
            for (int i = 0; i < mappingElement.length; ++i) {
                ele.addContent((Content)mappingElement[i]);
            }
        } else {
            Element eventElement = new Element("commonevent");
            eventElement.setAttribute("name", BOSEventUtils.formatString(cemodel.getName()));
            eventElement.setAttribute("producer", "");
            for (int i = 0; i < mappingElement.length; ++i) {
                eventElement.addContent((Content)mappingElement[i]);
            }
            mappingElementRoot.addContent((Content)eventElement);
        }
    }

    private static Element[] generateMappingElement(EventInfo eventInfo) {
        EventMethodCollection eventMethods = eventInfo.getEventMethods();
        Element[] mappingElement = new Element[eventMethods.size()];
        for (int i = 0; i < eventMethods.size(); ++i) {
            EventMethodInfo method = eventMethods.get(i);
            mappingElement[i] = new Element("mapping");
            mappingElement[i].setAttribute("bosType", BOSEventUtils.formatString(BOSEventUtils.genBOSType(eventInfo.getExtendedProperty("entityBosType"))));
            mappingElement[i].setAttribute("entityName", BOSEventUtils.formatString(eventInfo.getExtendedProperty("entityFullName")));
            mappingElement[i].setAttribute("methodName", BOSEventUtils.formatString(method.getMethodRef().getName()));
            mappingElement[i].setAttribute("methodPk", BOSEventUtils.formatString(method.getMethodRef().getInnerID()));
            mappingElement[i].setAttribute("description", BOSEventUtils.formatString(method.getDescription()));
            Element parameterMappings = BOSEventUtils.generateParameterMappings(eventInfo, method);
            if (parameterMappings == null) continue;
            mappingElement[i].addContent((Content)parameterMappings);
        }
        return mappingElement;
    }

    private static Element generateParameterMappings(EventInfo eventInfo, EventMethodInfo method) {
        if (method.getParameterMappings() == null || method.getParameterMappings().size() <= 0) {
            return null;
        }
        Element parametermappingsElement = new Element("parameterMappings");
        ParameterMappingCollection parameterMappings = method.getParameterMappings();
        for (int i = 0; i < parameterMappings.size(); ++i) {
            ParameterMappingInfo parameterMappingInfo = parameterMappings.get(i);
            Element parametermappingElement = new Element("parameterMapping");
            String name = BOSEventUtils.getFormalParameterName(eventInfo, parameterMappingInfo.getFormalParameterInnerID());
            if (StringUtils.isEmpty((String)name)) {
                return null;
            }
            parametermappingElement.setAttribute("formalParameterName", BOSEventUtils.formatString(name));
            parametermappingElement.setAttribute("actualParameterIndex", BOSEventUtils.formatString(String.valueOf(parameterMappingInfo.getActualParameterIndex())));
            parametermappingElement.setAttribute("isBOPK", BOSEventUtils.formatString(String.valueOf(parameterMappingInfo.isBOPK())));
            parametermappingElement.setAttribute("description", BOSEventUtils.formatString(parameterMappingInfo.getDescription()));
            parametermappingsElement.addContent((Content)parametermappingElement);
        }
        return parametermappingsElement;
    }

    private static String getFormalParameterName(EventInfo eventInfo, String innerId) {
        String parameterName = "";
        FormalParameterCollection formalParameterCollection = eventInfo.getFormalParameters();
        for (int i = 0; i < formalParameterCollection.size(); ++i) {
            FormalParameterInfo formalParameterInfo = formalParameterCollection.get(i);
            if (!formalParameterInfo.getInnerID().equalsIgnoreCase(innerId)) continue;
            parameterName = formalParameterInfo.getParameter().getName();
            break;
        }
        return parameterName;
    }

    private static String formatString(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        return s;
    }

    private static Element getMappingElementRoot() {
        Element root = new Element("config");
        root.setAttribute("mappingRule", "");
        Document doc = new Document();
        doc.setRootElement(root);
        return root;
    }

    public static String generateDefaultExpiredDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2050, 1, 1, 0, 0, 0);
        Date timeStamp = calendar.getTime();
        String ts = Utilities.DF_TIMESTAMP.format(timeStamp);
        return ts;
    }
}

