/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.event.adapter.BOSEntityMappingInfo;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.adapter.IEventMappingRule;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class DyanmicBillEventMappingRule
implements IEventMappingRule {
    @Override
    public EventMappingInfo[] getMatchedEventMappingInfos(IServiceContext serviceContext) throws CommonEventException {
        if (serviceContext == null) {
            return null;
        }
        BOSObjectType boType = serviceContext.getBoType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        if (boType == null) {
            return null;
        }
        ArrayList<EventMappingInfo> matchedList = new ArrayList<EventMappingInfo>();
        List eventMappingInfos = BOSEventUtils.getMatchedEventMappingInfoByBosType(boType);
        block0: for (int i = 0; i < eventMappingInfos.size(); ++i) {
            EventMappingInfo info = (EventMappingInfo)eventMappingInfos.get(i);
            List mappingInfos = info.getEventMappingInfos();
            for (int j = 0; j < mappingInfos.size(); ++j) {
                BOSEntityMappingInfo mappingInfo = (BOSEntityMappingInfo)mappingInfos.get(j);
                if (mappingInfo.getBosType() == null || !this.isMatched(serviceContext, mappingInfo)) continue;
                matchedList.add(info);
                continue block0;
            }
        }
        return matchedList.toArray(new EventMappingInfo[0]);
    }

    @Override
    public BOSEntityMappingInfo[] getMatchedMappingInfos(IServiceContext serviceContext, EventMappingInfo eventMappingInfo) throws CommonEventException {
        if (serviceContext == null || eventMappingInfo == null) {
            return null;
        }
        BOSObjectType boType = serviceContext.getBoType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        if (boType == null) {
            return null;
        }
        List mappingInfos = eventMappingInfo.getEventMappingInfos();
        ArrayList<BOSEntityMappingInfo> matchedList = new ArrayList<BOSEntityMappingInfo>();
        for (int i = 0; i < mappingInfos.size(); ++i) {
            BOSEntityMappingInfo mappingInfo = (BOSEntityMappingInfo)mappingInfos.get(i);
            if (mappingInfo.getBosType() == null || !this.isMatched(serviceContext, mappingInfo)) continue;
            matchedList.add(mappingInfo);
        }
        return matchedList.toArray(new BOSEntityMappingInfo[0]);
    }

    private boolean isMatched(IServiceContext serviceContext, BOSEntityMappingInfo mappingInfo) {
        BOSObjectType boType = serviceContext.getBoType();
        String operationName = null;
        if (serviceContext.getOperationParameters() != null && serviceContext.getOperationParameters().length >= 2) {
            operationName = (String)serviceContext.getOperationParameters()[1];
        }
        if (boType == null || StringUtils.isEmpty(operationName)) {
            return false;
        }
        return boType.toString().equals(mappingInfo.getBosType()) && operationName.toString().equalsIgnoreCase(mappingInfo.getMethodName());
    }
}

