/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.DispatchWorker;
import com.kingdee.bos.event.core.EventConfig;
import com.kingdee.bos.event.core.EventDispatcher;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.IEventDispatcher;
import com.kingdee.bos.event.core.IEventProcessor;
import com.kingdee.bos.event.core.RunnableExtend;
import com.kingdee.bos.event.exception.EventServerException;
import org.apache.log4j.Logger;

public class EventProcessor
extends RunnableExtend
implements IEventProcessor {
    private static final Logger logger = Logger.getLogger(EventProcessor.class);
    private EventServer server = null;
    private EventConfig config = null;
    private IEventDispatcher dispatcher;
    private String name = "";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventProcessor(EventServer server, String name) {
        this.server = server;
        this.name = name;
        this.config = server.getConfig();
    }

    @Override
    public void dispatchEvent(ICommonEvent commonEvent) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this.server);
        }
        DispatchWorker worker = new DispatchWorker(this.dispatcher, commonEvent);
        this.server.getThreadPool().run((Runnable)worker);
    }

    @Override
    public void run() {
        logger.debug((Object)"EventProcessor prapare to run");
        super.run();
        this.server.getEventQueue().setImmediateTimeOut(false);
        ICommonEvent commonEvent = null;
        while (!this.isStop()) {
            commonEvent = (ICommonEvent)this.server.getEventQueue().get(this.config.getTimeout());
            if (commonEvent == null) {
                logger.info((Object)"CommonEvent is null");
                continue;
            }
            this.dispatchEvent(commonEvent);
        }
    }

    @Override
    public void startListen() throws EventServerException {
        new Thread((Runnable)this, this.name).start();
    }

    @Override
    public void stopListen() throws EventServerException {
        this.stop();
    }
}

