/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.launcher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.event.core.launcher.DummyEventLauncher;
import com.kingdee.bos.event.core.launcher.EventLauncher;
import com.kingdee.bos.event.core.launcher.EventLauncherOrmrpcProxy;
import com.kingdee.bos.event.core.launcher.IEventLauncher;
import com.kingdee.bos.event.core.launcher.IEventLauncherOrmrpcProxy;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.util.StringUtils;

public class EventLauncherFactory {
    public static IEventLauncherOrmrpcProxy getRemoteEventLauncher(String rpcURL) throws CommonEventException {
        IEventLauncherOrmrpcProxy launcher;
        try {
            launcher = (IEventLauncherOrmrpcProxy)BOSObjectFactory.createRemoteObject((String)rpcURL, (String)EventLauncherOrmrpcProxy.class.getName(), IEventLauncherOrmrpcProxy.class);
        }
        catch (BOSException e) {
            throw new CommonEventException("getRomoteEventLauncher BOSException : ", e);
        }
        if (launcher == null) {
            throw new CommonEventException("EventLauncherFactory Cant't getRemoteEventLauncher ,launcher is null");
        }
        return launcher;
    }

    public static IEventLauncher getVMEventLauncher() throws CommonEventException {
        return new EventLauncher();
    }

    public static IEventLauncher getEventLauncher(String protocal, String uri) throws CommonEventException {
        if (StringUtils.isEmpty((String)protocal)) {
            return new DummyEventLauncher();
        }
        if ("vm".equalsIgnoreCase(protocal)) {
            return EventLauncherFactory.getVMEventLauncher();
        }
        if ("ormrpc".equalsIgnoreCase(protocal)) {
            return EventLauncherFactory.getRemoteEventLauncher(uri);
        }
        throw new CommonEventException("TODO,unsupport protocal");
    }

    public static IEventLauncher getEventLauncher(String URI2) throws CommonEventException {
        if (StringUtils.isEmpty((String)URI2) || URI2.indexOf("#") == -1) {
            throw new CommonEventException("Event Server URI format error! URI is : " + URI2);
        }
        String[] serverUrls = URI2.split("#");
        if (serverUrls == null || serverUrls.length != 2) {
            throw new CommonEventException("Event Server URI format error! URI is : " + URI2);
        }
        return EventLauncherFactory.getEventLauncher(serverUrls[0], serverUrls[1]);
    }
}

