/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.queue;

import com.kingdee.bos.event.core.EventConfig;
import com.kingdee.bos.event.core.queue.Queue;
import com.kingdee.bos.event.core.queue.QueueEvent;
import com.kingdee.bos.event.exception.InterruptedError;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EventQueue
extends Queue {
    private boolean isBufferMode = true;
    private static Logger logger = Logger.getLogger(EventQueue.class);
    private static final int MAX_ROLLBACK_RETRY_TIMES = EventConfig.getInstance().getQueueMaxRollbackRetryTimes();
    private Map listeners = Collections.synchronizedMap(new LinkedHashMap());
    private Map failedObjs = Collections.synchronizedMap(new HashMap());
    private boolean isFireEvent = true;
    private InnerListener innerListener;
    private final String name;
    private final IBuddyObject buddy;

    public Map getListeners() {
        return this.listeners;
    }

    public EventQueue(String name) {
        this(name, true);
    }

    public EventQueue(String name, boolean isBufferMode) {
        this.name = name;
        this.isBufferMode = isBufferMode;
        this.innerListener = new InnerListener();
        this.registerListener(this.innerListener, 36);
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        try {
            this.buddy.initialize();
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }

    public String getName() {
        return this.name;
    }

    public void init() {
        this.fireEvent(1, null);
    }

    public void registerListener(Object listener, int eventCode) {
        Integer code = new Integer(eventCode);
        if (this.listeners.containsKey(listener)) {
            code = new Integer(code | eventCode);
        }
        this.listeners.put(listener, code);
    }

    public void removeAllListeners() {
        this.listeners.clear();
        this.registerListener(this.innerListener, 36);
    }

    public void addInnerListener() {
        this.innerListener = new InnerListener();
        this.registerListener(this.innerListener, 36);
    }

    public void setFireEvent(boolean isFireEvent) {
        this.isFireEvent = isFireEvent;
    }

    public void removeListener(Object listener) {
        this.listeners.remove(listener);
    }

    public void clearListener() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout) {
        Object obj = null;
        if (this.isBufferMode) {
            obj = super.get(timeout);
        } else {
            long startTime = System.currentTimeMillis();
            do {
                long currentTime = System.currentTimeMillis();
                obj = this.fireEvent(2, null);
                if (obj != null) continue;
                if (currentTime - startTime >= timeout) break;
                try {
                    long rest = timeout - currentTime + startTime;
                    EventQueue eventQueue = this;
                    synchronized (eventQueue) {
                        this.wait(rest);
                    }
                }
                catch (InterruptedException e) {
                    EventQueue eventQueue = this;
                    synchronized (eventQueue) {
                        this.notifyAll();
                    }
                    throw new InterruptedError();
                }
            } while (obj == null);
        }
        Object o = this.fireEvent(4, obj);
        if (o instanceof String) {
            if ("ABORT_EXECUTE".equals(o)) {
                if (this.isBufferMode) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    super.put(obj);
                    this.innerListener.removeDirtyObject(obj);
                }
                return null;
            }
            if ("TIME_OUT".equals(o)) {
                if (this.isBufferMode) {
                    this.innerListener.removeDirtyObject(obj);
                }
                return null;
            }
        }
        return obj;
    }

    @Override
    public Object get() {
        return this.get(Long.MAX_VALUE);
    }

    @Override
    public synchronized Object get(Object obj) {
        super.get(obj);
        Object o = this.fireEvent(4, obj);
        if (o instanceof String) {
            if ("ABORT_EXECUTE".equals(o)) {
                if (this.isBufferMode) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    super.put(obj);
                    this.innerListener.removeDirtyObject(obj);
                }
                return null;
            }
            if ("TIME_OUT".equals(o)) {
                if (this.isBufferMode) {
                    this.innerListener.removeDirtyObject(obj);
                }
                return null;
            }
        }
        return obj;
    }

    @Override
    public synchronized void put(Object obj, boolean isSilent) {
        this.fireEvent(8, obj);
        if (this.isBufferMode) {
            super.put(obj, isSilent);
        }
        this.fireEvent(16, obj);
    }

    @Override
    public synchronized void put(Object obj) {
        this.put(obj, false);
    }

    public void commit(Object obj) {
        this.fireEvent(32, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Object obj) {
        this.fireEvent(64, obj);
        Map map = this.failedObjs;
        synchronized (map) {
            if (this.failedObjs.containsKey(obj)) {
                int failedCnt = (Integer)this.failedObjs.get(obj) + 1;
                if (failedCnt >= MAX_ROLLBACK_RETRY_TIMES) {
                    this.failedObjs.remove(obj);
                    this.innerListener.removeDirtyObject(obj);
                    this.commit(obj);
                    this.fireEvent(512, obj);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Object:" + obj + "\thas retried " + MAX_ROLLBACK_RETRY_TIMES + " times,stop it!"));
                    }
                } else {
                    this.failedObjs.put(obj, new Integer(failedCnt));
                    if (this.isBufferMode) {
                        super.put(obj);
                    } else {
                        this.fireEvent(1024, obj);
                    }
                }
            } else {
                this.failedObjs.put(obj, new Integer(1));
                this.fireEvent(256, obj);
                if (this.isBufferMode) {
                    super.put(obj);
                } else {
                    this.fireEvent(1024, obj);
                }
            }
        }
        this.fireEvent(128, obj);
    }

    private Object fireEvent(int eventCode, Object obj) {
        Object rtnVal = null;
        if (!this.isFireEvent) {
            return rtnVal;
        }
        for (Object listener : this.listeners.keySet()) {
            int listenEvent = (Integer)this.listeners.get(listener);
            if ((listenEvent & eventCode) == 0) continue;
            QueueEvent event = new QueueEvent(obj, eventCode);
            rtnVal = this.invoke(listener, event);
            if (4 == eventCode && "ABORT_EXECUTE".equals(rtnVal)) {
                return rtnVal;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Event:" + QueueEvent.getMethodName(event.getEventCode()) + "\tis happend!"));
        }
        return rtnVal;
    }

    private Object invoke(Object listener, QueueEvent event) {
        Object o = null;
        Method method = null;
        String methodName = QueueEvent.getMethodName(event.getEventCode());
        try {
            method = listener.getClass().getMethod(methodName, QueueEvent.class);
        }
        catch (NoSuchMethodException nsmex) {
            method = null;
        }
        catch (SecurityException se) {
            method = null;
        }
        if (method == null) {
            return null;
        }
        try {
            o = method.invoke(listener, event);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("SuperQueue IllegalArgumentException refelect invoke method[" + method.toString() + "]"), (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("SuperQueue IllegalAccessException refelect invoke method[" + method.toString() + "]"), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            logger.error((Object)("SuperQueue InvokeException refelect invoke method[" + method.toString() + "]"), t);
            if (t instanceof Exception) {
                throw new RuntimeException(t);
            }
            throw new UndeclaredThrowableException(t, "Undeclared Throwable");
        }
        catch (ExceptionInInitializerError e) {
            logger.error((Object)("SuperQueue ExceptionInInitializerError refelect invoke method[" + method.toString() + "]"), (Throwable)e);
            throw new UndeclaredThrowableException(e, "Undeclared Throwable");
        }
        return o;
    }

    public Object[] dirtyValues() {
        return this.innerListener.getDirtyObjects();
    }

    public synchronized boolean contains(Object entry) {
        boolean isContain = false;
        int n = this.values().length;
        for (int i = 0; i < n; ++i) {
            if (this.values()[i] != entry) continue;
            isContain = true;
            break;
        }
        return isContain;
    }

    public synchronized Object[] allValues() {
        Object[] objs = null;
        if (this.isBufferMode) {
            Object[] dirtyValues = this.dirtyValues();
            Object[] values = this.values();
            objs = new Object[dirtyValues.length + values.length];
            System.arraycopy(dirtyValues, 0, objs, 0, dirtyValues.length);
            System.arraycopy(values, 0, objs, dirtyValues.length, values.length);
        }
        return objs;
    }

    public synchronized void clear() {
        while (super.get(0L) != null) {
        }
        this.innerListener.clearDirtyObjects();
        this.failedObjs.clear();
        this.buddy.operationPerformed("clear");
    }

    private class InnerListener {
        private List dirtyObjects = Collections.synchronizedList(new ArrayList());

        private InnerListener() {
        }

        public void afterGet(QueueEvent event) {
            if (event != null && event.getObj() != null && !this.dirtyObjects.contains(event.getObj())) {
                this.dirtyObjects.add(event.getObj());
            }
        }

        public void onCommit(QueueEvent event) {
            if (event != null && event.getObj() != null) {
                this.removeDirtyObject(event.getObj());
            }
        }

        public Object[] getDirtyObjects() {
            return this.dirtyObjects.toArray();
        }

        public void removeDirtyObject(Object obj) {
            this.dirtyObjects.remove(obj);
        }

        public void clearDirtyObjects() {
            this.dirtyObjects.clear();
        }
    }
}

