/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.dyansubscribe;

import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.EventRepositoryService;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.event.model.cem.ExtendedData;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.model.es.EventSubscribePointRelation;
import com.kingdee.bos.event.util.ServerUtils;
import com.kingdee.util.StringUtils;
import org.eclipse.emf.common.util.EList;

public class EventSubscribeManager {
    private EventServer server = ServerUtils.getEventServer(ServerUtils.generateServerKey());

    public boolean subscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation espr, boolean isPersistent) throws EventRepositoryException {
        EventRepositoryService ers = (EventRepositoryService)this.server.getRepositoryService();
        if (ers.getEventSubscribePointByName(sp.getName()) == null) {
            ers.createEventSubscribePoint(sp, isPersistent);
        }
        ers.saveEventSubscribe(sp, espr, isPersistent);
        return true;
    }

    public boolean subscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation[] esprs, boolean isPersistent) throws EventRepositoryException {
        for (int i = 0; i < esprs.length; ++i) {
            this.subscribeEvent(sp, esprs[i], isPersistent);
        }
        return true;
    }

    public boolean unsubscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation espr, boolean isPersistent) throws EventRepositoryException {
        EventRepositoryService ers = (EventRepositoryService)this.server.getRepositoryService();
        if (espr.getId() != null && ers.getEventSubscribePointRelation(espr.getId()) != null) {
            ers.deleteEventSubscribePointRelation(espr.getId(), isPersistent);
        }
        return true;
    }

    public boolean unsubscribeEvent(EventSubscribePoint sp, EventSubscribePointRelation[] espr, boolean isPersistent) throws EventRepositoryException {
        if (espr != null) {
            for (int i = 0; i < espr.length; ++i) {
                this.unsubscribeEvent(sp, espr[i], isPersistent);
            }
        }
        return true;
    }

    public String[] getAllCommonEventDefNames() throws EventRepositoryException {
        CommonEvent[] ceArray = this.server.getRepositoryService().getAllCommonEvents();
        String[] cedNames = new String[ceArray.length];
        for (int i = 0; i < ceArray.length; ++i) {
            CommonEvent ce = ceArray[i];
            cedNames[i] = ce.getName();
        }
        return cedNames;
    }

    public CommonEvent getCommonEventDefByName(String eventName) throws EventRepositoryException {
        CommonEvent ce = this.server.getRepositoryService().getCommonEventByCommonEventName(eventName);
        return ce;
    }

    public String getCommonEventDefExtDataSchemaName(String eventName) throws EventRepositoryException {
        String extTypeXSDName = null;
        CommonEvent ce = this.server.getRepositoryService().getCommonEventByCommonEventName(eventName);
        if (ce != null && ce.getExtendedDatas() != null) {
            EList exts = ce.getExtendedDatas().getExtendedData();
            for (ExtendedData extData : exts) {
                if (!StringUtils.isEmpty((String)extData.getMappingParameterName())) continue;
                extTypeXSDName = extData.getMappingParameterName();
            }
        }
        if (extTypeXSDName != null) {
            // empty if block
        }
        return extTypeXSDName;
    }
}

