/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.EventRepositoryServiceOrmrpcProxy;
import com.kingdee.bos.event.model.IEventRepositoryService;
import com.kingdee.bos.event.model.IEventRepositoryServiceOrmrpcProxy;
import com.kingdee.bos.event.util.ServerUtils;

public class EventRepositoryServiceFactory {
    private static IEventRepositoryServiceOrmrpcProxy getRemoteEventRepositoryService(String rpcUrl) throws EventRepositoryException {
        IEventRepositoryServiceOrmrpcProxy service = null;
        try {
            service = (IEventRepositoryServiceOrmrpcProxy)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)EventRepositoryServiceOrmrpcProxy.class.getName(), IEventRepositoryServiceOrmrpcProxy.class);
        }
        catch (BOSException e) {
            throw new EventRepositoryException("EventRepositoryServiceFactory.getRemoteEventRepositoryService BOSException  " + (Object)((Object)e));
        }
        if (service == null) {
            throw new EventRepositoryException("EventRepositoryServiceFactory.getRemoteEventRepositoryService Exception,service is null");
        }
        return service;
    }

    public static IEventRepositoryService getVMEventRepositoryService() {
        return ServerUtils.getEventServer(ServerUtils.generateServerKey()).getRepositoryService();
    }

    public static IEventRepositoryService getEventRepositoryService(String protocol, String uri) throws EventRepositoryException {
        if ("vm".equalsIgnoreCase(protocol)) {
            return EventRepositoryServiceFactory.getVMEventRepositoryService();
        }
        if ("ormrpc".equalsIgnoreCase(protocol)) {
            return EventRepositoryServiceFactory.getRemoteEventRepositoryService(uri);
        }
        throw new EventRepositoryException("TODO,unsupport protocol: " + protocol);
    }
}

