/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.subscribe;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.EventNotificationException;
import com.kingdee.bos.event.subscribe.IEventSubscriber;
import com.kingdee.bos.event.subscribe.ISubscriberInformant;
import org.apache.log4j.Logger;

public abstract class AbstractSubscriberInformant
implements ISubscriberInformant {
    static Logger logger = Logger.getLogger(AbstractSubscriberInformant.class);
    protected IEventSubscriber esb = null;
    protected EventSubscribePoint esp = null;

    protected AbstractSubscriberInformant(EventSubscribePoint subscriber) {
        this.esp = subscriber;
    }

    @Override
    public EventSubscribePoint getSubscribePoint() {
        return this.esp;
    }

    @Override
    public boolean isConnected() {
        return this.getEventSubscriber() != null;
    }

    @Override
    public void informSubscriber(ICommonEvent event) throws EventNotificationException {
        if (event == null || this.getEventSubscriber() == null) {
            logger.error((Object)("SubscriberInformant.informSubscriber,event and evnetSubscriber can't be null,event:" + event));
            throw new EventNotificationException("SubscriberInformant.informSubscriber,event and evnetSubscriber can't be null");
        }
        try {
            logger.debug((Object)("SubscriberInformant inform Subscriber [" + this.esp.getName() + "],Event [" + event.getName() + "  |  " + event.getId() + "]"));
            this.getEventSubscriber().onEvent(event);
        }
        catch (Exception e) {
            throw new EventNotificationException(e);
        }
    }

    public abstract IEventSubscriber getEventSubscriber();
}

