/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.subscribe;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.queue.EventPullQueueListener;
import com.kingdee.bos.event.core.queue.EventPushQueueListener;
import com.kingdee.bos.event.core.queue.EventQueue;
import com.kingdee.bos.event.core.queue.EventQueueFactory;
import com.kingdee.bos.event.core.queue.IEventQueueListener;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.EventSubscriberDefObj;
import com.kingdee.bos.event.subscribe.ISubscriberInformant;
import com.kingdee.bos.event.subscribe.SubscribeInformantUtils;
import com.kingdee.bos.event.subscribe.SubscriberInformantFactory;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DispatcherManager {
    Logger logger = Logger.getLogger(DispatcherManager.class);
    private EventServer server = null;
    private Map subscriberInformantMap = Collections.synchronizedMap(new HashMap());
    private Map subscriberListenerMap = Collections.synchronizedMap(new HashMap());

    public DispatcherManager(EventServer server) {
        this.server = server;
    }

    public void dispatchEventToSubQueues(ICommonEvent event, EventSubscribePoint[] esps) {
        if (event == null || esps == null || esps.length == 0) {
            return;
        }
        for (int i = 0; i < esps.length; ++i) {
            this.dispatchEventToSubQueues(event, esps[i]);
        }
    }

    public void dispatchEventToSubQueues(ICommonEvent event, EventSubscribePoint esp) {
        if (event == null || esp == null || StringUtils.isEmpty((String)esp.getDestination())) {
            return;
        }
        this.logger.debug((Object)"===DispatcherManager dispatchEvent to subQueue===");
        String destination = esp.getDestination();
        if (StringUtils.isEmpty((String)destination)) {
            this.logger.info((Object)"DispatcherManager.dispatchEventToSubQueues EventSubscribePoint'uri is empty");
            return;
        }
        ISubscriberInformant si = this.getSubscriberInformant(destination, esp);
        EventQueue subscriberQueue = this.getSubscriberQueue(destination, esp.getName());
        IEventQueueListener listener = this.getSubscribeQueueListener(destination, si);
        this.ensureRegisterListener(destination, subscriberQueue, listener);
        subscriberQueue.put(event);
    }

    private EventQueue getSubscriberQueue(String destination, String subscriberName) {
        EventSubscriberDefObj esd = SubscribeInformantUtils.getEventSubscriberDefObj(destination);
        EventQueue subscriberQueue = null;
        subscriberQueue = esd.getMethod().equalsIgnoreCase("pull") ? EventQueueFactory.getPullSubscriberEventQueue(destination) : EventQueueFactory.getEventQueue(destination);
        return subscriberQueue;
    }

    private void ensureRegisterListener(String uri, EventQueue subscriberQueue, IEventQueueListener listener) {
        if (listener != null && !subscriberQueue.getListeners().containsKey(listener)) {
            EventSubscriberDefObj esd = SubscribeInformantUtils.getEventSubscriberDefObj(uri);
            if (esd.getMethod().equalsIgnoreCase("push")) {
                subscriberQueue.registerListener(listener, 57);
            } else if (esd.getMethod().equalsIgnoreCase("pull")) {
                subscriberQueue.registerListener(listener, 57);
            }
        }
    }

    private IEventQueueListener getSubscribeQueueListener(String uri, ISubscriberInformant si) {
        if (StringUtils.isEmpty((String)uri) || si == null) {
            return null;
        }
        if (this.subscriberListenerMap.get(uri) == null) {
            EventSubscriberDefObj esd = SubscribeInformantUtils.getEventSubscriberDefObj(uri);
            IEventQueueListener listener = null;
            if (esd.getMethod().equalsIgnoreCase("push")) {
                listener = new EventPushQueueListener(si, this.server);
            } else if (esd.getMethod().equalsIgnoreCase("pull")) {
                listener = new EventPullQueueListener(uri, this.server);
            }
            this.subscriberListenerMap.put(uri, listener);
        }
        return (IEventQueueListener)this.subscriberListenerMap.get(uri);
    }

    private ISubscriberInformant getSubscriberInformant(String uri, EventSubscribePoint esp) {
        ISubscriberInformant esbi;
        if (StringUtils.isEmpty((String)uri)) {
            return null;
        }
        if (this.subscriberInformantMap.get(uri) == null && (esbi = SubscriberInformantFactory.getSubscriberInformant(esp)) != null) {
            this.subscriberInformantMap.put(uri, esbi);
        }
        return (ISubscriberInformant)this.subscriberInformantMap.get(uri);
    }
}

