/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.transform;

import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.EventContextData;
import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.EventExtendedData;
import com.kingdee.bos.event.EventPriority;
import com.kingdee.bos.event.EventSeverity;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.IEventContextData;
import com.kingdee.bos.event.IEventExtendedData;
import com.kingdee.bos.event.exception.EventCreationException;
import com.kingdee.bos.event.exception.EventTransformException;
import com.kingdee.bos.event.transform.IEventTransformer;
import com.kingdee.bos.event.util.Utilities;
import com.kingdee.bos.event.util.XmlUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class EventTransformerImpl
implements IEventTransformer {
    private static final Logger logger = Logger.getLogger(EventTransformerImpl.class);

    @Override
    public String eventToXML(ICommonEvent commonEvent) throws EventTransformException {
        return this.eventToXML(commonEvent, true);
    }

    @Override
    public String eventToXML(ICommonEvent commonEvent, boolean format) throws EventTransformException {
        if (commonEvent == null) {
            throw new EventTransformException("commonEvent is null");
        }
        StringBuffer document = new StringBuffer();
        document.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        document.append(XmlUtils.LINE_SEPARATOR);
        document.append("<CommonEvent xmlns=\"http://www.kingdee.com/commonevent1_0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/commonevent1_0/commonevent1_0.xsd\">");
        document.append(XmlUtils.LINE_SEPARATOR);
        StringBuffer simpleElement = this.simpleElement2Xml(commonEvent);
        document.append(simpleElement);
        document.append(XmlUtils.LINE_SEPARATOR);
        StringBuffer complexElement = this.complexElement2Xml(commonEvent);
        document.append(complexElement);
        document.append(XmlUtils.LINE_SEPARATOR);
        document.append("</CommonEvent>");
        return document.toString();
    }

    private StringBuffer complexElement2Xml(ICommonEvent commonEvent) throws EventTransformException {
        int i;
        if (commonEvent == null) {
            throw new EventTransformException("CommonEvent is null");
        }
        StringBuffer complexBuffer = new StringBuffer();
        if (commonEvent.getContextDatas().size() > 0) {
            complexBuffer.append("\t");
            complexBuffer.append("<EventContextDatas>");
            List contexts = commonEvent.getContextDatas();
            for (i = 0; i < contexts.size(); ++i) {
                complexBuffer.append(XmlUtils.LINE_SEPARATOR);
                IEventContextData context = (IEventContextData)contexts.get(i);
                complexBuffer.append("\t\t");
                complexBuffer.append("<EventContextData name=\"");
                complexBuffer.append(context.getName());
                complexBuffer.append("\"  value=\"");
                complexBuffer.append(context.getValue()).append("\" />");
            }
            complexBuffer.append(XmlUtils.LINE_SEPARATOR);
            complexBuffer.append("\t");
            complexBuffer.append("</EventContextDatas>");
        }
        if (commonEvent.getExtendedDatas().size() > 0) {
            complexBuffer.append(XmlUtils.LINE_SEPARATOR);
            complexBuffer.append("\t");
            complexBuffer.append("<EventExtendedDatas>");
            List extendedDatas = commonEvent.getExtendedDatas();
            for (i = 0; i < extendedDatas.size(); ++i) {
                IEventExtendedData data = (IEventExtendedData)extendedDatas.get(i);
                complexBuffer.append(XmlUtils.LINE_SEPARATOR);
                complexBuffer.append("\t\t");
                complexBuffer.append("<EventExtendedData name=\"");
                complexBuffer.append(data.getName());
                complexBuffer.append("\"  datatype=\"");
                complexBuffer.append(data.getDataType().getValue()).append("\"");
                complexBuffer.append(" mappingParameterName=\"");
                complexBuffer.append(data.getMappingParameterName()).append("\"");
                complexBuffer.append(" value=\"");
                complexBuffer.append(this.obj2Xml(data.getValue(), data.getDataType())).append("\" />");
            }
        }
        complexBuffer.append(XmlUtils.LINE_SEPARATOR);
        complexBuffer.append("\t");
        complexBuffer.append("</EventExtendedDatas>");
        return complexBuffer;
    }

    private Object xml2Obj(String objectValue, EventDataType dataType) throws Exception {
        Object obj = null;
        if (StringUtils.isEmpty((String)objectValue) || dataType == null) {
            return obj;
        }
        if (dataType == EventDataType.TYPE_STRING || dataType == EventDataType.TYPE_BOOLEAN || dataType == EventDataType.TYPE_BYTE || dataType == EventDataType.TYPE_DECIMAL || dataType == EventDataType.TYPE_DOUBLE || dataType == EventDataType.TYPE_FLOAT || dataType == EventDataType.TYPE_INTEGER || dataType == EventDataType.TYPE_LONG || dataType == EventDataType.TYPE_SHORT || dataType == EventDataType.TYPE_OBJECTUUIDPK) {
            obj = Utilities.stringToObj(dataType.getValue(), objectValue);
        } else if (dataType == EventDataType.TYPE_CHARACTER) {
            obj = new Character(objectValue.charAt(0));
        } else if (dataType == EventDataType.TYPE_BOSUUID) {
            obj = BOSUuid.create((String)objectValue);
        } else if (dataType == EventDataType.TYPE_DATE) {
            obj = Utilities.convetToDate(objectValue);
        } else if (dataType == EventDataType.TYPE_TIME) {
            obj = Utilities.convetToTime(objectValue);
        } else if (dataType == EventDataType.TYPE_TIMESTAMP) {
            obj = Utilities.convetToTimeStamp(objectValue);
        } else if (dataType == EventDataType.TYPE_STRING_ARRAY || dataType == EventDataType.TYPE_BOOLEAN_ARRAY || dataType == EventDataType.TYPE_BYTE_ARRAY || dataType == EventDataType.TYPE_DECIMAL_ARRAY || dataType == EventDataType.TYPE_DOUBLE_ARRAY || dataType == EventDataType.TYPE_FLOAT_ARRAY || dataType == EventDataType.TYPE_INTEGER_ARRAY || dataType == EventDataType.TYPE_LONG_ARRAY || dataType == EventDataType.TYPE_SHORT_ARRAY || dataType == EventDataType.TYPE_OBJECTUUIDPK_ARRAY) {
            String[] values = objectValue.split(",");
            Object[] objects = new Object[values.length];
            String objectMeta = dataType.getValue();
            objectMeta = objectMeta.substring(0, objectMeta.length() - 2);
            for (int i = 0; i < values.length; ++i) {
                objects[i] = Utilities.stringToObj(objectMeta, values[i]);
            }
            obj = objects;
        } else {
            obj = XmlUtils.processXml2Object(objectValue);
        }
        return obj;
    }

    private String obj2Xml(Object value, EventDataType dataType) {
        StringBuffer objectBuffer = new StringBuffer();
        if (value == null || dataType == null || StringUtils.isEmpty((String)dataType.getValue())) {
            return objectBuffer.toString();
        }
        if (value instanceof Object[]) {
            objectBuffer.append(this.processArray((Object[])value, dataType));
        } else if (dataType == EventDataType.TYPE_STRING || dataType == EventDataType.TYPE_BOOLEAN || dataType == EventDataType.TYPE_BYTE || dataType == EventDataType.TYPE_BOSUUID || dataType == EventDataType.TYPE_CHARACTER || dataType == EventDataType.TYPE_DECIMAL || dataType == EventDataType.TYPE_DOUBLE || dataType == EventDataType.TYPE_TIMESTAMP || dataType == EventDataType.TYPE_FLOAT || dataType == EventDataType.TYPE_INTEGER || dataType == EventDataType.TYPE_LONG || dataType == EventDataType.TYPE_OBJECTUUIDPK || dataType == EventDataType.TYPE_SHORT || dataType == EventDataType.TYPE_TIME) {
            objectBuffer.append(value);
        } else if (dataType == EventDataType.TYPE_DATE) {
            Date date = (Date)value;
            objectBuffer.append(new Timestamp(date.getTime()));
        } else {
            return XmlUtils.processObject2Xml(value);
        }
        return objectBuffer.toString();
    }

    private String processArray(Object[] value, EventDataType dataType) {
        StringBuffer arrayBuffer = new StringBuffer();
        if (value == null || dataType == null || StringUtils.isEmpty((String)dataType.getValue())) {
            return arrayBuffer.toString();
        }
        if (dataType == EventDataType.TYPE_STRING_ARRAY || dataType == EventDataType.TYPE_BOOLEAN_ARRAY || dataType == EventDataType.TYPE_BYTE_ARRAY || dataType == EventDataType.TYPE_BOSUUID_ARRAY || dataType == EventDataType.TYPE_CHARACTER_ARRAY || dataType == EventDataType.TYPE_DATE_ARRAY || dataType == EventDataType.TYPE_DECIMAL_ARRAY || dataType == EventDataType.TYPE_DOUBLE_ARRAY || dataType == EventDataType.TYPE_FLOAT_ARRAY || dataType == EventDataType.TYPE_INTEGER_ARRAY || dataType == EventDataType.TYPE_LONG_ARRAY || dataType == EventDataType.TYPE_OBJECTUUIDPK_ARRAY || dataType == EventDataType.TYPE_SHORT_ARRAY || dataType == EventDataType.TYPE_TIME_ARRAY || dataType == EventDataType.TYPE_TIMESTAMP_ARRAY) {
            for (int i = 0; i < value.length; ++i) {
                arrayBuffer.append(value[i]);
                arrayBuffer.append(",");
            }
        } else {
            return XmlUtils.processObject2Xml(value);
        }
        arrayBuffer.deleteCharAt(arrayBuffer.length() - 1);
        return arrayBuffer.toString();
    }

    private StringBuffer simpleElement2Xml(ICommonEvent commonEvent) {
        String value;
        Locale locale;
        Iterator iterator;
        StringBuffer simpleElement = new StringBuffer();
        if (!StringUtils.isEmpty((String)commonEvent.getId())) {
            simpleElement.append("\t");
            simpleElement.append("<Id>");
            simpleElement.append(commonEvent.getId());
            simpleElement.append("</Id>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getName())) {
            simpleElement.append("\t");
            simpleElement.append("<Name>");
            simpleElement.append(commonEvent.getName());
            simpleElement.append("</Name>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getEventDefId())) {
            simpleElement.append("\t");
            simpleElement.append("<EventDefId>");
            simpleElement.append(commonEvent.getEventDefId());
            simpleElement.append("</EventDefId>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getDataCenterName())) {
            simpleElement.append("\t");
            simpleElement.append("<DataCenterName>");
            simpleElement.append(commonEvent.getDataCenterName());
            simpleElement.append("</DataCenterName>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getSolutionName())) {
            simpleElement.append("\t");
            simpleElement.append("<SolutionName>");
            simpleElement.append(commonEvent.getSolutionName());
            simpleElement.append("</SolutionName>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getHostIP())) {
            simpleElement.append("\t");
            simpleElement.append("<HostIp>");
            simpleElement.append(commonEvent.getHostIP());
            simpleElement.append("</HostIp>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getHostName())) {
            simpleElement.append("\t");
            simpleElement.append("<HostName>");
            simpleElement.append(commonEvent.getHostName());
            simpleElement.append("</HostName>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getVersion())) {
            simpleElement.append("\t");
            simpleElement.append("<Version>");
            simpleElement.append(commonEvent.getVersion());
            simpleElement.append("</Version>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)commonEvent.getGroup())) {
            simpleElement.append("\t");
            simpleElement.append("<Group>");
            simpleElement.append(commonEvent.getGroup());
            simpleElement.append("</Group>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getEventType() != null) {
            simpleElement.append("\t");
            simpleElement.append("<Type>");
            simpleElement.append(commonEvent.getEventType());
            simpleElement.append("</Type>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getCreatedTime() != null) {
            simpleElement.append("\t");
            simpleElement.append("<CreatedTime>");
            simpleElement.append(new Timestamp(commonEvent.getCreatedTime().getTime()).toString());
            simpleElement.append("</CreatedTime>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getExpiredTime() != null) {
            simpleElement.append("\t");
            simpleElement.append("<ExpirationDate>");
            simpleElement.append(new Timestamp(commonEvent.getExpiredTime().getTime()).toString());
            simpleElement.append("</ExpirationDate>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getPriority() != null) {
            simpleElement.append("\t");
            simpleElement.append("<Priority>");
            simpleElement.append(commonEvent.getPriority().getValue());
            simpleElement.append("</Priority>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getSeverity() != null) {
            simpleElement.append("\t");
            simpleElement.append("<Severity>");
            simpleElement.append(commonEvent.getSeverity().getValue());
            simpleElement.append("</Severity>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getAliases().size() > 0) {
            simpleElement.append("\t");
            simpleElement.append("<Alias>");
            Map aliases = commonEvent.getAliases();
            iterator = aliases.keySet().iterator();
            while (iterator.hasNext()) {
                simpleElement.append(XmlUtils.LINE_SEPARATOR);
                locale = (Locale)iterator.next();
                value = (String)aliases.get(locale);
                simpleElement.append("\t\t");
                simpleElement.append("<Locale key=\"");
                simpleElement.append(locale).append("\"");
                simpleElement.append(" value=\"");
                simpleElement.append(XmlUtils.normalize(value)).append("\" />");
            }
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
            simpleElement.append("\t");
            simpleElement.append("</Alias>");
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
        }
        if (commonEvent.getDescriptions().size() > 0) {
            simpleElement.append("\t");
            simpleElement.append("<Description>");
            Map descriptions = commonEvent.getDescriptions();
            iterator = descriptions.keySet().iterator();
            while (iterator.hasNext()) {
                simpleElement.append(XmlUtils.LINE_SEPARATOR);
                locale = (Locale)iterator.next();
                value = (String)descriptions.get(locale);
                simpleElement.append("\t\t");
                simpleElement.append("<Locale key=\"");
                simpleElement.append(locale).append("\"");
                simpleElement.append(" value=\"");
                simpleElement.append(XmlUtils.normalize(value)).append("\" />");
            }
            simpleElement.append(XmlUtils.LINE_SEPARATOR);
            simpleElement.append("\t");
            simpleElement.append("</Description>");
        }
        return simpleElement;
    }

    @Override
    public ICommonEvent xmlToEvent(String xml) throws EventTransformException {
        if (StringUtils.isEmpty((String)xml)) {
            return null;
        }
        ICommonEvent commonEvent = null;
        try {
            Document doc = XMLParser.parseXML((InputStream)new ByteArrayInputStream(xml.getBytes()));
            Element root = doc.getRootElement();
            commonEvent = this.parseCommonEvent(root);
        }
        catch (JDOMException e) {
            logger.error((Object)("xmlToEvent : Document Parser Error,JDOMException :" + (Object)((Object)e)));
            throw new EventTransformException(e);
        }
        catch (IOException e) {
            logger.error((Object)("xmlToEvent : Document Parser Error,IOException :" + e));
            throw new EventTransformException(e);
        }
        catch (EventCreationException e) {
            logger.error((Object)("xmlToEvent : Document Parser Error,EventCreationException :" + (Object)((Object)e)));
            throw new EventTransformException((Throwable)((Object)e));
        }
        return commonEvent;
    }

    private ICommonEvent parseCommonEvent(Element root) throws EventCreationException {
        if (root == null) {
            return null;
        }
        CommonEvent commonEvent = new CommonEvent();
        List children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element element = (Element)children.get(i);
            this.constructEvent(commonEvent, element, root);
        }
        return commonEvent;
    }

    private void constructEvent(ICommonEvent commonEvent, Element element, Element parentElement) throws EventCreationException {
        if (element.getName().equalsIgnoreCase("Id")) {
            commonEvent.setId(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("Name")) {
            commonEvent.setName(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("EventDefId")) {
            commonEvent.setEventDefId(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("Type")) {
            commonEvent.setEventType(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("Version")) {
            commonEvent.setVersion(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("Priority")) {
            commonEvent.setPriority(EventPriority.getEnum(Integer.parseInt(element.getTextNormalize())));
        } else if (element.getName().equalsIgnoreCase("Severity")) {
            commonEvent.setSeverity(EventSeverity.getEnum(Integer.parseInt(element.getTextNormalize())));
        } else if (element.getName().equalsIgnoreCase("Group")) {
            commonEvent.setGroup(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("HostIp")) {
            commonEvent.setHostIP(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("HostName")) {
            commonEvent.setHostName(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("SolutionName")) {
            commonEvent.setSolutionName(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("DataCenterName")) {
            commonEvent.setDataCenterName(element.getTextNormalize());
        } else if (element.getName().equalsIgnoreCase("CreatedTime")) {
            String timeString = element.getTextNormalize();
            try {
                commonEvent.setCreatedTime(Utilities.convetToDate(timeString));
            }
            catch (ParseException e) {
                logger.error((Object)("constructEvent : convertCreatedTime ParseException" + e));
            }
        } else if (element.getName().equalsIgnoreCase("ExpirationDate")) {
            String timeString = element.getTextNormalize();
            try {
                commonEvent.setExpiredTime(Utilities.convetToDate(timeString));
            }
            catch (ParseException e) {
                logger.error((Object)("constructEvent : convertExpirationDate ParseException" + e));
            }
        } else if (element.getName().equalsIgnoreCase("Alias") || element.getName().equalsIgnoreCase("Description") || element.getName().equalsIgnoreCase("EventContextDatas") || element.getName().equalsIgnoreCase("EventExtendedDatas")) {
            this.fillEventByChildElement(commonEvent, element);
        } else if (element.getName().equalsIgnoreCase("Locale")) {
            String key = element.getAttributeValue("key");
            String value = XmlUtils.denormalize(element.getAttributeValue("value"));
            if (parentElement.getName().equalsIgnoreCase("Alias")) {
                commonEvent.setAlias(new Locale(key), value);
            }
            if (parentElement.getName().equalsIgnoreCase("Description")) {
                commonEvent.setDescription(new Locale(key), value);
            }
        } else if (element.getName().equalsIgnoreCase("EventContextData")) {
            EventContextData data = new EventContextData(element.getAttributeValue("name"), element.getAttributeValue("value"));
            commonEvent.addContextData(data);
        } else if (element.getName().equalsIgnoreCase("EventExtendedData")) {
            String name = element.getAttributeValue("name");
            EventDataType dataType = EventDataType.getEnum(element.getAttributeValue("datatype"));
            String objectValue = element.getAttributeValue("value");
            String mappingParameter = element.getAttributeValue("mappingParameterName");
            try {
                Object object = this.xml2Obj(objectValue, dataType);
                EventExtendedData data = new EventExtendedData(name, dataType, object, mappingParameter);
                commonEvent.addExtendedData(data);
            }
            catch (Exception e) {
                throw new EventCreationException(e);
            }
        } else {
            throw new EventCreationException("Unsupport Element");
        }
    }

    private void fillEventByChildElement(ICommonEvent commonEvent, Element element) throws EventCreationException {
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            this.constructEvent(commonEvent, child, element);
        }
    }
}

