/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.filters;

import com.kingdee.eas.cp.common.web.util.AntiXssUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;

public final class AntiXssRequestWrapper
extends HttpServletRequestWrapper {
    private Logger logger = Logger.getLogger((String)AntiXssRequestWrapper.class.getName());

    public AntiXssRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXSS(values[i]);
        }
        return encodedValues;
    }

    public Map getParameterMap() {
        return super.getParameterMap();
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.cleanXSS(value);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return this.cleanXSS(value);
    }

    public StringBuffer getRequestURL() {
        String value = this.cleanXSS(super.getRequestURL().toString());
        return new StringBuffer(value);
    }

    public String getRequestURI() {
        return this.cleanXSS(super.getRequestURI());
    }

    public String getQueryString() {
        String queryString = super.getQueryString();
        if (queryString == null || "".equals(queryString)) {
            return queryString;
        }
        String[] queryStringArray = queryString.split("&");
        StringBuffer stringWithClean = new StringBuffer();
        for (int i = 0; i < queryStringArray.length; ++i) {
            stringWithClean.append(this.cleanXSS(queryStringArray[i])).append("&");
        }
        if (stringWithClean.length() > 0) {
            stringWithClean.deleteCharAt(stringWithClean.length() - 1);
        }
        return stringWithClean.toString();
    }

    private String cleanXSS(String value) {
        String result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("cleanXSS before:" + value));
        }
        if ((result = AntiXssUtil.cleanXSS(value)) == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("cleanXSS after:" + result.toString()));
        }
        return result.toString();
    }
}

