/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.buffalo.request.RequestContext;
import net.buffalo.request.SynchronizableMap;

public class RequestContextUtil {
    public static void createRequestContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        RequestContext context = new RequestContext(new HashMap());
        context.setServletContext(servletContext);
        context.setHttpRequest(request);
        context.setHttpResponse(response);
        RequestContext.setContext(context);
        context.setApplication(RequestContextUtil.createApplicationMap(servletContext));
        context.setSession(RequestContextUtil.createSessionMap(request));
        context.setCookie(RequestContextUtil.createCookieMap(request));
        context.setParameter(request.getParameterMap());
    }

    private static Map createCookieMap(HttpServletRequest request) {
        SynchronizableMap.CookieMap map = new SynchronizableMap.CookieMap();
        Cookie[] cookies = request.getCookies();
        map.copyCookies(cookies);
        return map;
    }

    private static Map createSessionMap(HttpServletRequest request) {
        SynchronizableMap.SessionMap map = new SynchronizableMap.SessionMap();
        HttpSession httpSession = request.getSession();
        if (httpSession == null) {
            httpSession = request.getSession(true);
        }
        map.copySessionVariables(httpSession);
        return map;
    }

    private static Map createApplicationMap(ServletContext servletContext) {
        SynchronizableMap.ApplicationMap map = new SynchronizableMap.ApplicationMap();
        map.copyServletContextVariables(servletContext);
        return map;
    }
}

