/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParser;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import nanoxml.XMLParseException;
import org.apache.log4j.Logger;

public class UserSyncConfigManager {
    private static final String PORTAL_CONFIG = "portal.config";
    private static final String LDAP_CONFIG = "ldapConfig.xml";
    public static final String USER_SYNC_CONFIG = "userSyncConfig.xml";
    private static HashMap userSyncResourcesMap = new HashMap();
    private static Logger logger = Logger.getLogger((String)UserSyncConfigManager.class.getName());

    public static void loadConfig() throws UserSyncConfigParseException, IOException {
        String configFile = UserSyncConfigManager.getConfigAbsolutePath() + USER_SYNC_CONFIG;
        File file = new File(configFile);
        if (!file.exists() && !(file = new File(UserSyncConfigManager.getConfigAbsolutePath() + LDAP_CONFIG)).exists()) {
            throw new UserSyncConfigParseException("Eas auth pattern config file is not exist.config file path =[" + configFile + "]");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            UserSyncConfigParser parser = new UserSyncConfigParser();
            userSyncResourcesMap = parser.parser(bis);
            logger.debug((Object)("ldapConfig:" + configFile + " is just loaded successfully."));
        }
        catch (IOException ioe) {
            throw new UserSyncConfigParseException(ioe);
        }
        catch (XMLParseException pe) {
            throw new UserSyncConfigParseException(pe);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getConfigFile() throws IOException {
        String configFile = UserSyncConfigManager.getConfigAbsolutePath() + USER_SYNC_CONFIG;
        return configFile;
    }

    public static String getConfigAbsolutePath() throws IOException {
        String portalConfig = System.getProperty(PORTAL_CONFIG);
        if (portalConfig == null || "".equals(portalConfig)) {
            throw new IOException("Eas portal config file is not exist. must set system property portal.config=[" + portalConfig + "]");
        }
        File portalConfigFile = new File(portalConfig);
        String path = portalConfigFile.getParentFile().getAbsolutePath() + "/";
        return path;
    }

    public static HashMap getUserSyncResourcesMap() {
        return (HashMap)userSyncResourcesMap.clone();
    }

    public static UserResource get(String ldapResxKey) {
        return (UserResource)userSyncResourcesMap.get(ldapResxKey);
    }

    public static void init() {
        try {
            UserSyncConfigManager.loadConfig();
        }
        catch (Exception e) {
            UserSyncConfigManager.destory();
            System.err.println("[Eas multi auth]Ldap config init fails.");
            e.printStackTrace();
        }
    }

    private static void destory() {
        userSyncResourcesMap.clear();
    }

    public static void main(String[] args) {
        switch (args.length) {
            case 1: {
                String configPath = args[0];
                try {
                    UserSyncConfigManager.store(configPath, UserSyncConfigManager.getUserSyncResourcesMap(), "UTF-8");
                }
                catch (UserSyncConfigParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("finish creating ldap config file:" + configPath);
                break;
            }
            case 3: {
                String pwd;
                String doWhat = args[0];
                String username = args[1];
                String result = pwd = args[2];
                result = "encode".equalsIgnoreCase(doWhat) ? "encrypt:" + PasswordUtils.encodePassword(username, pwd) : PasswordUtils.decodePassword(username, pwd);
                System.out.println(doWhat + " user[" + username + "]'s password[" + pwd + "] ," + doWhat + "d password is " + result);
            }
        }
    }

    public static void store(HashMap ldapResxMap, String charset) throws UserSyncConfigParseException, IOException {
        String configFile = UserSyncConfigManager.getConfigAbsolutePath() + USER_SYNC_CONFIG;
        UserSyncConfigManager.store(configFile, ldapResxMap, charset);
    }

    public static void store(String configFile, HashMap ldapResxMap, String charset) throws UserSyncConfigParseException, IOException {
        UserSyncConfigWriter writer = new UserSyncConfigWriter();
        writer.store(configFile, ldapResxMap, charset);
    }

    static {
        UserSyncConfigManager.init();
    }
}

