/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigElementInfo;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.user.ValidatorManager;
import com.kingdee.eas.cp.eip.sso.user.XmlUtils;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import com.kingdee.eas.cp.eip.sso.xml.NodeFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserSyncConfigWriter {
    private static Logger logger = Logger.getLogger((String)UserSyncConfigWriter.class.getName());

    private void addResources(INode root, HashMap ldapResxMap) {
        INode resxNode = null;
        UserResource resx = null;
        String key = "";
        String resxNodeName = UserSyncConfigElementInfo.getResourceNodeName();
        String resourceNodeAttrName = UserSyncConfigElementInfo.getResourceNodeAttrName();
        String resxNodeAttrName = UserSyncConfigElementInfo.getResourceNodeAttrresourceType();
        Iterator ite = ldapResxMap.entrySet().iterator();
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            key = (String)entry.getKey();
            resx = (UserResource)entry.getValue();
            resxNode = this.createResourceNode(resxNodeName, resx);
            resxNode.setAttribute(resourceNodeAttrName, key);
            resxNode.setAttribute(resxNodeAttrName, resx.getResourceType());
            root.addChild(resxNode);
        }
    }

    private void addUserSyncConfigItems(INode resxNode, HashMap userSyncConfigItemMap) {
        String key = "";
        UserSyncConfigItem configItem = null;
        INode syncItemNode = null;
        String nodeName = UserSyncConfigElementInfo.getUserSyncNodeName();
        String nodeAttrName = UserSyncConfigElementInfo.getUserSyncNodeAttrName();
        Iterator ite = userSyncConfigItemMap.entrySet().iterator();
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            configItem = (UserSyncConfigItem)entry.getValue();
            key = (String)entry.getKey();
            syncItemNode = this.createUserSyncConfigItemNode(nodeName, configItem);
            syncItemNode.setAttribute(nodeAttrName, key);
            resxNode.addChild(syncItemNode);
        }
    }

    private INode createRootNode() {
        INode root = NodeFactory.createNode(UserSyncConfigElementInfo.getRootNodeName());
        return root;
    }

    private INode createResourceNode(String nodeName, UserResource resx) {
        INode resxNode = NodeFactory.createNode(nodeName);
        resxNode.setAttribute(UserSyncConfigElementInfo.getResourceNodeAttrresourceType(), resx.getResourceType());
        String[] resxChildNodeNames = UserSyncConfigElementInfo.getResourceChildNodeNames();
        String[] resxChildNodeValues = this.getResourceChildNodeValues(resx);
        INode ldapResxChildNode = null;
        for (int i = 0; i < resxChildNodeValues.length; ++i) {
            ldapResxChildNode = NodeFactory.createNode(resxChildNodeNames[i]);
            ldapResxChildNode.setNodeValue(resxChildNodeValues[i]);
            resxNode.addChild(ldapResxChildNode);
        }
        this.addUserSyncConfigItems(resxNode, resx.getUserSyncConfigItemMap());
        return resxNode;
    }

    private INode createUserSyncConfigItemNode(String syncNodeName, UserSyncConfigItem configItem) {
        INode configItemNode = NodeFactory.createNode(syncNodeName);
        String[] childNodeNames = UserSyncConfigElementInfo.getUserSyncChildNodeNames();
        String[] childNodeValues = this.getUserSyncChildNodeValues(configItem);
        INode childNode = null;
        for (int i = 0; i < childNodeValues.length; ++i) {
            childNode = NodeFactory.createNode(childNodeNames[i]);
            childNode.setNodeValue(childNodeValues[i]);
            configItemNode.addChild(childNode);
        }
        return configItemNode;
    }

    private void createConfigFile(String configFile, INode root) throws UserSyncConfigParseException {
        OutputStreamWriter writer = null;
        try {
            File file = new File(configFile);
            writer = new FileWriter(file);
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
            root.write(writer);
            writer.flush();
        }
        catch (IOException ioe) {
            throw new UserSyncConfigParseException(ioe);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void createConfigFileWithUTF8(String configFile, String outStr, String outCharset) throws UserSyncConfigParseException {
        String encoding = System.getProperty("file.encoding");
        logger.debug((Object)("Default System Encoding: " + encoding));
        FileOutputStream fileos = null;
        OutputStreamWriter writer = null;
        try {
            File file = new File(configFile);
            fileos = new FileOutputStream(file);
            String charset = outCharset;
            if (charset == null || "".equals(charset)) {
                charset = "UTF-8";
            }
            String xmlHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
            fileos.write(xmlHeader.getBytes(charset));
            byte[] outBytes = outStr.getBytes(charset);
            int bufSize = 4096;
            int start = 0;
            int len = bufSize;
            int i = 1;
            while (start < outBytes.length) {
                if (start + len > outBytes.length) {
                    len = outBytes.length - start;
                }
                fileos.write(outBytes, start, len);
                start = bufSize * (++i - 1);
            }
            fileos.flush();
        }
        catch (IOException ioe) {
            throw new UserSyncConfigParseException(ioe);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fileos != null) {
                    fileos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String[] getResourceChildNodeValues(UserResource resx) {
        String[] result = new String[]{resx.getContextFactory(), resx.getProviderURL(), resx.getAuthentication(), resx.getPrincipal(), resx.getCredentials(), resx.getJndiName(), resx.getLastTime(), resx.getResourceList(), resx.getUserID(), resx.getSyncClass(), resx.getConDN(), resx.getSyncImport()};
        return result;
    }

    private String[] getUserSyncChildNodeValues(UserSyncConfigItem configItem) {
        String[] result = new String[]{configItem.getExecutor(), configItem.getDefaultPwd(), configItem.getUsernameSuffix(), configItem.getBaseDN(), configItem.getFilter(), new Integer(configItem.getSearchScope()).toString(), configItem.getLastSync(), configItem.getReturningAttributes(), configItem.getMapToEasUserNumber(), configItem.getMapToEasUserName(), configItem.getLastSyncUbound(), configItem.getUsernumber(), configItem.getLanguage()};
        return result;
    }

    private String genResourceNode(UserResource resx) {
        StringBuffer result = new StringBuffer("");
        String[] resxChildNodeNames = UserSyncConfigElementInfo.getResourceChildNodeNames();
        String[] resxChildNodeValues = this.getResourceChildNodeValues(resx);
        for (int i = 0; i < resxChildNodeValues.length; ++i) {
            this.outputElementWithoutAttrBegin(result, resxChildNodeNames[i]);
            result.append(XmlUtils.encodedXmlData(resxChildNodeValues[i]));
            this.outputElementEnd(result, resxChildNodeNames[i]);
            this.outputNextLine(result);
        }
        String userSyncNodeStr = this.genUserSyncConfigItems(resx.getUserSyncConfigItemMap());
        result.append(userSyncNodeStr);
        return result.toString();
    }

    private String genUserSyncConfigItems(HashMap userSyncConfigItemMap) {
        StringBuffer result = new StringBuffer("");
        String key = "";
        UserSyncConfigItem configItem = null;
        String nodeName = UserSyncConfigElementInfo.getUserSyncNodeName();
        String nodeAttrName = UserSyncConfigElementInfo.getUserSyncNodeAttrName();
        Iterator ite = userSyncConfigItemMap.entrySet().iterator();
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            configItem = (UserSyncConfigItem)entry.getValue();
            key = (String)entry.getKey();
            this.outputElementWithOneAttrBegin(result, nodeName, nodeAttrName, key);
            result.append(this.genUserSyncConfigItemNode(configItem));
            this.outputElementEnd(result, nodeName);
            this.outputNextLine(result);
        }
        return result.toString();
    }

    private String genUserSyncConfigItemNode(UserSyncConfigItem configItem) {
        StringBuffer result = new StringBuffer("");
        String[] childNodeNames = UserSyncConfigElementInfo.getUserSyncChildNodeNames();
        String[] childNodeValues = this.getUserSyncChildNodeValues(configItem);
        for (int i = 0; i < childNodeValues.length; ++i) {
            this.outputElementWithoutAttrBegin(result, childNodeNames[i]);
            result.append(XmlUtils.encodedXmlData(childNodeValues[i]));
            this.outputElementEnd(result, childNodeNames[i]);
            this.outputNextLine(result);
        }
        return result.toString();
    }

    private String genResources(HashMap ldapResxMap) {
        StringBuffer result = new StringBuffer("");
        String resxNodeStr = "";
        UserResource resx = null;
        String key = "";
        String resxNodeName = UserSyncConfigElementInfo.getResourceNodeName();
        String resxNodeAttrName = UserSyncConfigElementInfo.getResourceNodeAttrName();
        String resxNodeAttrName1 = UserSyncConfigElementInfo.getResourceNodeAttrresourceType();
        Iterator ite = ldapResxMap.entrySet().iterator();
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            key = (String)entry.getKey();
            resx = (UserResource)entry.getValue();
            this.outputElementWithOneAttrBegin(result, resxNodeName, resxNodeAttrName, key, resxNodeAttrName1, resx.getResourceType());
            resxNodeStr = this.genResourceNode(resx);
            result.append(resxNodeStr);
            this.outputElementEnd(result, resxNodeName);
            this.outputNextLine(result);
        }
        return result.toString();
    }

    private void outputNextLine(StringBuffer sb) {
        String lineEnd = "\r\n";
        sb.append(lineEnd);
    }

    private void outputElementEnd(StringBuffer sb, String nodeName) {
        sb.append("</");
        sb.append(nodeName);
        sb.append(">");
    }

    private void outputElementWithoutAttrBegin(StringBuffer sb, String nodeName) {
        sb.append("<");
        sb.append(nodeName);
        sb.append(">");
    }

    private void outputElementWithOneAttrBegin(StringBuffer result, String nodeName, String attrName, String attrValue) {
        result.append("<");
        result.append(nodeName);
        result.append(" ");
        result.append(attrName);
        result.append("=\"");
        result.append(XmlUtils.encodedXmlData(attrValue));
        result.append("\"");
        result.append(">");
        this.outputNextLine(result);
    }

    private void outputElementWithOneAttrBegin(StringBuffer result, String nodeName, String attrName, String attrValue, String resattrName, String resattrValue) {
        result.append("<");
        result.append(nodeName);
        result.append(" ");
        result.append(attrName);
        result.append("=\"");
        result.append(XmlUtils.encodedXmlData(attrValue));
        result.append("\"");
        result.append(" ");
        result.append(resattrName);
        result.append("=\"");
        result.append(XmlUtils.encodedXmlData(resattrValue));
        result.append("\"");
        result.append(">");
        this.outputNextLine(result);
    }

    public void store(String configFile, HashMap ldapResxMap, String charset) throws UserSyncConfigParseException, IOException {
        if (!ValidatorManager.validateConfig(ldapResxMap)) {
            String excMsg = "[Eas multi auth]user sync config file is invalid.";
            throw new UserSyncConfigParseException(excMsg);
        }
        StringBuffer sb = new StringBuffer("");
        this.outputElementWithoutAttrBegin(sb, UserSyncConfigElementInfo.getRootNodeName());
        this.outputNextLine(sb);
        String resxStr = this.genResources(ldapResxMap);
        sb.append(resxStr);
        this.outputNextLine(sb);
        this.outputElementEnd(sb, UserSyncConfigElementInfo.getRootNodeName());
        this.outputNextLine(sb);
        if (configFile == null || "".equals(configFile)) {
            throw new IOException("[Eas user sync] no set ouput file path and name.");
        }
        this.createConfigFileWithUTF8(configFile, sb.toString(), charset);
    }

    public void store(String configFile, HashMap ldapResxMap) throws UserSyncConfigParseException, IOException {
        INode root = this.createRootNode();
        this.addResources(root, ldapResxMap);
        if (configFile == null || "".equals(configFile)) {
            throw new IOException("[Eas user sync] no set ouput file path and name.");
        }
        this.createConfigFile(configFile, root);
    }
}

