/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.eas.cp.eip.sso.user.DbConfigValidator;
import com.kingdee.eas.cp.eip.sso.user.IConfigValidator;
import com.kingdee.eas.cp.eip.sso.user.LdapConfigValidator;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ValidatorManager {
    private static Logger logger = Logger.getLogger((String)ValidatorManager.class.getName());
    private static HashMap validatorMap = new HashMap();

    public static void register(String resourceType, IConfigValidator conVal) {
        String key = resourceType.toLowerCase();
        validatorMap.put(key, conVal);
    }

    public static IConfigValidator getValidator(String resxType) {
        String key = resxType.toLowerCase();
        return (IConfigValidator)validatorMap.get(key);
    }

    public static void registerDefaultImpl() {
        DbConfigValidator dbConfigValidator = new DbConfigValidator();
        ValidatorManager.register("database", dbConfigValidator);
        LdapConfigValidator ldapConfigValidator = new LdapConfigValidator();
        ValidatorManager.register("ldap", ldapConfigValidator);
    }

    public static boolean validateResourceType(String resxType) {
        boolean result = true;
        String key = resxType.toLowerCase();
        if (!validatorMap.containsKey(key)) {
            result = false;
        }
        return result;
    }

    public static boolean validateConfig(HashMap ldapResxMap) {
        boolean result = true;
        if (ldapResxMap == null || ldapResxMap.isEmpty()) {
            result = false;
            logger.debug((Object)"[Eas multi auth]user sync config file is no any resource emement.");
        } else {
            Iterator ite = ldapResxMap.entrySet().iterator();
            UserResource ldapResx = null;
            HashMap syncItemMap = null;
            Map.Entry entry = null;
            String resxType = null;
            while (ite.hasNext()) {
                entry = ite.next();
                ldapResx = (UserResource)entry.getValue();
                resxType = ldapResx.getResourceType();
                if (!ValidatorManager.validateResourceType(resxType)) {
                    result = false;
                    break;
                }
                IConfigValidator configVal = ValidatorManager.getValidator(resxType);
                if (!configVal.validateUserSyncResource(ldapResx)) {
                    result = false;
                    break;
                }
                syncItemMap = ldapResx.getUserSyncConfigItemMap();
                if (configVal.validateUserSyncConfigItems(syncItemMap)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    static {
        ValidatorManager.registerDefaultImpl();
    }
}

