/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LocaleManager {
    private static final Logger logger = Logger.getLogger(LocaleManager.class);
    public static final String LOCALE_EN_KEY = "L1#en_US";
    public static final String LOCALE_EN_NAME = "English";
    private static Map sortedLangMap = new TreeMap();

    public static Map getAllSupportLanguage() {
        if (sortedLangMap.size() > 0) {
            return sortedLangMap;
        }
        String bosConfigFile = System.getProperty("EAS_HOME") + "/server/profiles/server1/config/bosconfig.xml";
        String supportLanguageXpath = "/config/configitem[@name='supportlanguage']/attribute";
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        builder.setValidation(false);
        try {
            Document doc = builder.build(bosConfigFile);
            List supportLanguageEle = XPath.selectNodes((Object)doc, (String)supportLanguageXpath);
            if (supportLanguageEle != null) {
                sortedLangMap = new TreeMap();
                for (Element language : supportLanguageEle) {
                    sortedLangMap.put(language.getAttributeValue("key"), language.getAttributeValue("value"));
                }
                logger.info((Object)("sortedLangMap size:" + sortedLangMap.size()));
            } else {
                logger.info((Object)"supportlanguage is null, use default locale L2.");
                sortedLangMap = new TreeMap();
                sortedLangMap.put("L2#CH", "\u7b80\u4f53\u4e2d\u6587");
            }
        }
        catch (JDOMException e) {
            logger.warn((Object)e);
            sortedLangMap = new TreeMap();
            sortedLangMap.put("L2#CH", "\u7b80\u4f53\u4e2d\u6587");
        }
        catch (IOException e) {
            logger.warn((Object)e);
            sortedLangMap = new TreeMap();
            sortedLangMap.put("L2#CH", "\u7b80\u4f53\u4e2d\u6587");
        }
        return sortedLangMap;
    }

    static class NoOpEntityResolver
    implements EntityResolver {
        NoOpEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }
}

