/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesUtil {
    private static HashMap cache = new HashMap();
    private static Logger logger = Logger.getLogger((String)PropertiesUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String configFile) {
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            properties.load(is);
            cache.put(configFile, properties);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }

    public static void unload(String configFile) {
        cache.remove(configFile);
    }

    public static void clearAll() {
        cache.clear();
    }

    public static Properties getProperties(String configFile) {
        if (!cache.containsKey(configFile)) {
            PropertiesUtil.load(configFile);
        }
        return (Properties)cache.get(configFile);
    }

    public static String getDefaultFullName(String relativeFileName) {
        String portalConfig = System.getProperty("portal.config");
        if (portalConfig == null || "".equals(portalConfig)) {
            System.err.println("[Eas Portal] please set system property [portal.config].");
        }
        File portalConfigFile = new File(portalConfig);
        String configPath = portalConfigFile.getParentFile().getAbsolutePath() + "/" + relativeFileName;
        return configPath;
    }

    public static void setProperties(String configFile, String key, String value) {
        if (!cache.containsKey(configFile)) {
            PropertiesUtil.load(configFile);
        }
        ((Properties)cache.get(configFile)).setProperty(key, value);
    }

    public static void store() {
    }
}

