/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.QRCodeUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.cp.eip.sso.web.CloudManagerService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudActivateServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CloudActivateServlet.class);
    private static final long serialVersionUID = 1L;
    private ServletContext context = null;

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String authCode = request.getParameter("authCode");
        String userNumber = request.getParameter("userNumber");
        if (!StringUtils.isEmpty((String)userNumber)) {
            userNumber = BASE64Util.decodeAsString(userNumber);
        }
        if (!StringUtils.isEmpty((String)authCode)) {
            authCode = BASE64Util.decodeAsString(authCode);
        }
        String dataCenter = request.getParameter("dataCenter");
        String language = request.getParameter("language");
        String method = request.getParameter("method");
        String pwd = request.getParameter("pwd");
        String oldPwd = request.getParameter("oldPwd");
        String needChangePwd = request.getParameter("needChangePwd");
        String phone = request.getParameter("phone");
        org.json.JSONObject obj = new org.json.JSONObject();
        boolean succ = false;
        try {
            Context context = CloudParamUtil.getContext(dataCenter, language, userNumber);
            String clientIP = request.getHeader("nap_proxy_client_ip");
            if (StringUtils.isEmpty((String)clientIP)) {
                clientIP = request.getRemoteAddr();
            }
            if (!StringUtils.isEmpty((String)clientIP)) {
                context.setClientHostIP(clientIP);
                context.setClientHostName(clientIP);
            }
            if ("checkAuthCode".equals(method)) {
                ICloudRegistSrv cloudInstance = CloudRegistSrvAgentFactory.getLocalInstance((Context)context);
                succ = cloudInstance.checkErpUserSecurityCode(userNumber, authCode);
                if (succ && !"true".equals(needChangePwd)) {
                    if (ControlPolicy.isBySubscriptionRegOnline((Context)context)) {
                        StringBuilder permSql = new StringBuilder();
                        permSql.append("select fid,fcell,femail from t_pm_user where LOWER(fnumber)=?");
                        IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new Object[]{userNumber.toLowerCase()});
                        if (rs.next()) {
                            cloudInstance.addActivedErpUser(userNumber, rs.getString("fcell"), rs.getString("femail"));
                        } else {
                            obj.put("errorInfo", (Object)"\u7528\u6237\u8d26\u53f7\u4e0d\u6b63\u786e");
                        }
                    } else {
                        cloudInstance.addActivedErpUser(userNumber);
                    }
                }
            } else if ("getEasSecurityPolicy".equals(method)) {
                if (this.checkParam(userNumber)) {
                    obj.put("errorInfo", (Object)"\u975e\u6cd5\u53c2\u6570\uff0c\u8bf7\u52ff\u968f\u610f\u4fee\u6539\uff01");
                } else {
                    String easSecurityPolicy = "";
                    StringBuilder permSql = new StringBuilder();
                    permSql.append("select  fid from t_pm_user where LOWER(fnumber)='").append(userNumber.toLowerCase()).append("'");
                    IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString());
                    if (rs != null && rs.size() > 0 && rs.next()) {
                        IUser iUser = UserFactory.getLocalInstance((Context)context);
                        SelectorItemCollection sc = new SelectorItemCollection();
                        sc.add(new SelectorItemInfo("*"));
                        sc.add(new SelectorItemInfo("security.*"));
                        String userId = rs.getString("fid");
                        UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId), sc);
                        SecurityValidator securityValidator = new SecurityValidator(context, userInfo);
                        easSecurityPolicy = securityValidator.getSecurityPolicy();
                    }
                    obj.put("easSecurityPolicy", (Object)easSecurityPolicy);
                }
                succ = true;
            } else if ("updatePwd".equals(method)) {
                String orgDataCenter = BASE64Util.decodeAsString(dataCenter);
                String orgLanguage = BASE64Util.decodeAsString(language);
                String ogrUserNumber = userNumber;
                String orgPwd = BASE64Util.decodeAsString(pwd);
                String orgOldPwd = BASE64Util.decodeAsString(oldPwd);
                context = CloudParamUtil.getContext(orgDataCenter, orgLanguage, ogrUserNumber);
                if (this.checkParam(userNumber)) {
                    obj.put("errorInfo", (Object)"\u975e\u6cd5\u53c2\u6570\uff0c\u8bf7\u52ff\u968f\u610f\u4fee\u6539\uff01");
                } else {
                    StringBuilder permSql = new StringBuilder();
                    permSql.append("select fid userCount,fpassword from t_pm_user where LOWER(fnumber)='").append(ogrUserNumber.toLowerCase()).append("'");
                    IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString());
                    if (rs != null && rs.size() > 0) {
                        while (rs.next()) {
                            UserInfo userInfo;
                            String userId = rs.getString("USERCOUNT");
                            context.setCaller((IObjectPK)new ObjectUuidPK(userId));
                            if (orgOldPwd != null && orgOldPwd.length() == 0) {
                                orgOldPwd = null;
                            }
                            if (!PermissionUtils.matchPassword((UserInfo)(userInfo = UserFactory.getLocalInstance((Context)context).getUserInfoByNumber(userNumber)), (String)orgOldPwd)) {
                                obj.put("errorInfo", (Object)ResourceBase.getString((String)"com.kingdee.eas.cp.eip.sso.web.auth.LoginRegResxResource", (String)"reg.input.oldpwdwrong", (Locale)context.getLocale()));
                                obj.put("errorCode", (Object)"oldfail");
                                continue;
                            }
                            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)userId));
                            Class<?> clazz = Class.forName("com.kingdee.eas.base.permission.UserFacadeFactory");
                            Method md = clazz.getDeclaredMethod("getLocalInstance", Context.class);
                            Object user = md.invoke(clazz, context);
                            Class<?> cla = user.getClass();
                            Method mt = cla.getDeclaredMethod("resetPass", String.class, String.class);
                            mt.invoke(user, userId, orgPwd);
                            succ = true;
                        }
                    }
                }
            } else if ("getActiveUrl".equals(method)) {
                String activeUrl = CloudManagerService.getActiveUrl(context, authCode);
                if (activeUrl != null && activeUrl.length() > 0) {
                    activeUrl = activeUrl.replace("http://", "https://");
                    obj.put("activeUrl", (Object)activeUrl);
                    succ = true;
                }
            } else {
                if ("getActiveUrlAndActive".equals(method)) {
                    try {
                        JSONObject result = CloudManagerService.getActiveUrlAndActive(context, authCode);
                        obj.put("errcode", (Object)result.getInteger("errcode"));
                        if (result.getInteger("errcode") != 0) {
                            logger.error(result.toString());
                        }
                        succ = true;
                    }
                    catch (Exception e) {
                        logger.error("EasCloud.getActiveCode error", (Throwable)e);
                        obj.put("offineline", true);
                        throw e;
                    }
                }
                if ("activeErpUser".equals(method)) {
                    ICloudRegistSrv cloudInstance = CloudRegistSrvAgentFactory.getLocalInstance((Context)context);
                    if (ControlPolicy.isBySubscriptionRegOnline((Context)context)) {
                        StringBuilder permSql = new StringBuilder();
                        permSql.append("select fid,fcell,femail from t_pm_user where LOWER(fnumber)=?");
                        IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new Object[]{userNumber.toLowerCase()});
                        if (rs.next()) {
                            cloudInstance.addActivedErpUser(userNumber, rs.getString("fcell"), rs.getString("femail"));
                        } else {
                            obj.put("errorInfo", (Object)"\u7528\u6237\u8d26\u53f7\u4e0d\u6b63\u786e");
                        }
                    } else {
                        cloudInstance.addActivedErpUser(userNumber);
                    }
                    succ = true;
                } else if ("activeErpAndCloudUser".equals(method)) {
                    StringBuilder permSql = new StringBuilder();
                    permSql.append("select fid from t_pm_user where LOWER(fnumber)=?");
                    IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new Object[]{userNumber.toLowerCase()});
                    if (rs.next()) {
                        context.setCaller((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
                        UserFacadeFactory.getLocalInstance((Context)context).resetErpAndCloudPass(rs.getString("fid"), pwd, authCode);
                        succ = true;
                    } else {
                        obj.put("errorInfo", (Object)"\u975e\u6cd5\u53c2\u6570\uff0c\u8bf7\u52ff\u968f\u610f\u4fee\u6539\uff01");
                    }
                } else if ("checkPhone".equals(method)) {
                    if (StringUtils.isEmpty((String)phone)) {
                        obj.put("errorInfo", (Object)"\u624b\u673a\u53f7\u4e0d\u6b63\u786e\uff01");
                    } else {
                        String sql = "select fcell from t_pm_user where LOWER(fnumber) =?";
                        IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{userNumber == null ? "" : userNumber.toLowerCase()});
                        if (rs.next() && phone.equals(rs.getString(1))) {
                            succ = true;
                        } else {
                            obj.put("errorInfo", (Object)"\u624b\u673a\u53f7\u4e0d\u6b63\u786e\uff01");
                        }
                    }
                } else if ("getQrCode".equalsIgnoreCase(method)) {
                    response.setHeader("Paragma", "no-cache");
                    response.setHeader("Cache-Control", "no-cache");
                    response.setDateHeader("Expires", 0L);
                    response.setContentType("image/jpeg");
                    String offineQrcodeUrl = CloudManagerService.getOffineQrcodeUrl(context, userNumber);
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("barcode", offineQrcodeUrl);
                    config.put("height", "300");
                    config.put("width", "300");
                    QRCodeUtils.generateBarcodePicture((OutputStream)response.getOutputStream(), (BarcodeFormat)BarcodeFormat.QR_CODE, config);
                } else if ("getActiveCodeUrl".equals(method)) {
                    String uid = request.getParameter("uid");
                    String prod_inst_code = request.getParameter("prod_inst_code");
                    String wholePhone = request.getParameter("phone");
                    String email1 = request.getParameter("email");
                    String isReg = request.getParameter("isReg");
                    JSONObject result = null;
                    try {
                        result = "true".equalsIgnoreCase(isReg) ? EasCloud.getActiveCode((String)uid, (String)prod_inst_code, (String)wholePhone, (String)email1) : EasCloud.getActiveCode((String)uid, (String)prod_inst_code, (String)wholePhone, (String)email1, (String)"2");
                    }
                    catch (Exception e) {
                        logger.error("EasCloud.getActiveCode error", (Throwable)e);
                        obj.put("offineline", true);
                        throw e;
                    }
                    obj.put("errcode", (Object)result.getInteger("errcode"));
                    if (result.getInteger("errcode") != 0) {
                        logger.error(result.toString());
                        throw new Exception(result.getString(EasCloud.DESCRIPTION_CN));
                    }
                    CloudParamUtil.logGetAuthCode(context);
                    obj.put("resend_in", (Object)JSONObject.parseObject((String)result.getString("data")).getInteger("resend_in"));
                } else {
                    obj.put("errorInfo", (Object)"\u8c03\u7528\u7684\u65b9\u6cd5\u4e0d\u5b58\u5728\uff01");
                    obj.put("errorCode", (Object)"methodnull");
                }
            }
            obj.put("success", succ);
        }
        catch (Exception e) {
            logger.error("CloudActivateServlet error ===", (Throwable)e);
            try {
                obj.put("errorInfo", (Object)e.getMessage());
                obj.put("errorCode", (Object)"other");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.writeResponse(response, obj.toString());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String encryptStr(Context ctx, String str, String pwd) {
        String result = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.base.permission.app.util.PermissionUtil");
            Method md = clazz.getDeclaredMethod("encrypt", String.class, String.class);
            Object obj = md.invoke(clazz, str, pwd);
            if (obj != null) {
                result = obj.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private boolean checkParam(String str) {
        boolean result = false;
        if (str != null && str.length() > 0 && (str.indexOf(".") > -1 || str.indexOf("%2f") > -1 || str.indexOf("%2F") > -1 || str.indexOf("'") > -1 || str.indexOf("%27") > -1 || str.indexOf("(") > -1)) {
            result = true;
        }
        return result;
    }

    private void writeResponse(HttpServletResponse response, String result) {
        try {
            response.setContentType("text/html");
            response.getOutputStream().write(result.toString().getBytes("utf-8"));
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }
}

