/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.cp.eip.sso.qrcode.IQrCodeService;
import com.kingdee.eas.cp.eip.sso.qrcode.QrCodeServiceFactory;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AjaxException;
import com.kingdee.eas.cp.eip.sso.web.qrcode.ResponseWriteUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = -1693631274964051631L;
    private static final Logger logger = LoggerFactory.getLogger(QrCodeLoginServlet.class);
    private ServletContext context = null;

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String dataCenter = req.getParameter("dataCenter");
        String language = req.getParameter("language");
        if (dataCenter != null) {
            try {
                boolean match = false;
                ArrayList list = DCManager.getInstance().getDCList();
                for (DCInfo dc : list) {
                    if (!dc.getNumber().equalsIgnoreCase(dataCenter)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    logger.error("dataCenter[" + dataCenter + "] is invaild,can not found matched dc!");
                    ResponseWriteUtil.writeAjaxData(resp, false, "can not found matched dc by number[" + dataCenter + "]", "param is invaild");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(language == null || "en".equalsIgnoreCase(language) || "tw".equalsIgnoreCase(language) || "ch".equalsIgnoreCase(language))) {
            logger.error("language[" + language + "] is invaild,it must in [tw,en,ch]");
            ResponseWriteUtil.writeAjaxData(resp, false, "language[" + language + "] is invaild", "param is invaild");
            return;
        }
        IQrCodeService service = QrCodeServiceFactory.create();
        String retJosn = null;
        try {
            retJosn = service.getLoginQrCode(dataCenter, language);
        }
        catch (AjaxException e) {
            e.printStackTrace();
            ResponseWriteUtil.writeAjaxData(resp, true, e.getMessage(), e.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseWriteUtil.writeAjaxData(resp, true, e.getMessage(), e.getMessage());
            return;
        }
        JSONObject data = JSON.parseObject((String)retJosn);
        ResponseWriteUtil.writeAjaxData(resp, true, "200", data);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

