/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.CubeData;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.TreenodeAbility;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.util.StringUtil;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class CalculateMemberBuilderUIPanel
extends KDPanel {
    private static final long serialVersionUID = -2954934267733797470L;
    private static final String[][] keyborad = new String[][]{{"9", "8", "7", "/"}, {"6", "5", "4", "*"}, {"3", "2", "1", "-"}, {"0", ".", "%", "+"}, {"(", ")", "{", "}"}};
    private static final int KEYBOARD_ROW = keyborad.length;
    private static final int KEYBOARD_COL = keyborad[0].length;
    private static final int PANEL_HEIGHT = 250;
    private static final int KEYBOARD_WIDTH = 120;
    private static final int COMMENT_HEIGHT = 30;
    private static final int FORMAT_HEIGHT = 30;
    private static final int LABEL_HEIGHT = 20;
    private static final int SPACING_WIDTH1 = 10;
    private static final int SPACING_WIDTH2 = 5;
    private static final int TREE_PREFER_WIDTH = 10;
    private static final int INSERT_BUTTON_HEIGHT = 40;
    private static final String defaultMdxFunctionXmlFilePathName = "MDXFunction-zh.xml";
    private KDLabel dataLabel = new KDLabel(BIComponentResource.getString(BIComponentResource.class, (String)"DataLabelCaption"));
    private KDLabel formularLabel = new KDLabel(BIComponentResource.getString(BIComponentResource.class, (String)"FunctionLabelCaption"));
    private KDLabel commentPrompt = new KDLabel("");
    private KDLabel formatPrompt = new KDLabel("");
    private KDButton insertButton = new KDButton(BIComponentResource.getString(BIComponentResource.class, (String)"InsertButtonCaption"));
    private KDTree dataTree = null;
    private KDTree formularTree = null;
    private KDTree nowSelectionTree = null;
    private TableLayout layout = null;
    private KDWorkButton[][] keyboradButton = new KDWorkButton[KEYBOARD_ROW][KEYBOARD_COL];
    private String buildedString = "";
    private String formatString = "";
    private String xmlFilePathName = "";
    private OlapModel olapModel = null;
    private KeyboardActionListener keyboardActionListener = new KeyboardActionListener();
    private MyTreeSelectionListener treeSelectionListener = new MyTreeSelectionListener();
    private TreeMouseAdapter treeMouseAdapter = new TreeMouseAdapter();
    public static final int PREFER_HEIGHT = 250;

    public CalculateMemberBuilderUIPanel(OlapModel olapModel) {
        this(olapModel, "");
    }

    public CalculateMemberBuilderUIPanel(OlapModel olapModel, String xmlFilePathName) {
        this.xmlFilePathName = xmlFilePathName.equals("") ? defaultMdxFunctionXmlFilePathName : xmlFilePathName;
        this.olapModel = olapModel;
        this.initComponent();
        this.layoutComponent();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(DataChangeListener.class, listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    public String getBuildedString() {
        return this.buildedString;
    }

    protected void fireDataChanged(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    private void initComponent() {
        this.buildFormularTree();
        this.buildDataTree();
        this.buildKeyboardButton();
        this.insertButton.setEnabled(false);
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculateMemberBuilderUIPanel.this.adjustBuildedString();
                CalculateMemberBuilderUIPanel.this.fireDataChanged(new DataChangeEvent((Object)CalculateMemberBuilderUIPanel.this));
            }
        });
        this.commentPrompt.setAlignmentY(0.0f);
        this.formatPrompt.setAlignmentY(0.0f);
    }

    private void layoutComponent() {
        if (this.layout == null) {
            this.layout = new TableLayout(3, 1);
            this.setLayout((LayoutManager)this.layout);
        }
        this.layout.style().setSize(-100, 250);
        this.layout.rowStyle(1).lockHeight(30);
        this.layout.rowStyle(2).lockHeight(30);
        Table sub0 = this.layout.cell(0).splitCol(3);
        sub0.colStyle(0).setMarginRight(10);
        sub0.colStyle(0).setWidth(10);
        sub0.colStyle(1).setMarginRight(5);
        sub0.colStyle(1).setWidth(10);
        sub0.colStyle(2).lockWidth(120);
        Table sub01 = sub0.cell(0).splitRow(2);
        sub01.rowStyle(0).lockHeight(20);
        Table sub02 = sub0.cell(1).splitRow(2);
        sub02.rowStyle(0).lockHeight(20);
        Table sub03 = sub0.cell(2).splitRow(3);
        sub03.rowStyle(0).lockHeight(40);
        sub03.rowStyle(0).setAlignmentY((short)4);
        sub03.rowStyle(2).lockHeight(40);
        Table sub04 = sub03.cell(1).split(KEYBOARD_ROW, KEYBOARD_COL);
        sub04.style().setSize(-100, -100);
        this.add((Component)this.dataLabel, sub01.cell(0));
        this.add((Component)new KDScrollPane((Component)this.dataTree), sub01.cell(1));
        this.add((Component)this.formularLabel, sub02.cell(0));
        this.add((Component)new KDScrollPane((Component)this.formularTree), sub02.cell(1));
        this.add((Component)this.insertButton, sub03.cell(0));
        this.addKeyboardButton(sub04);
        this.add((Component)this.commentPrompt, this.layout.cell(1));
        this.add((Component)this.formatPrompt, this.layout.cell(2));
    }

    private void adjustBuildedString() {
        this.buildedString = this.formatString;
    }

    private void setBuildedString(String str) {
        this.setBuildedString(str, false);
    }

    private void setBuildedString(String str, boolean isByKeyborad) {
        if (isByKeyborad) {
            this.buildedString = str;
        } else {
            this.formatString = str;
            this.buildedString = str;
        }
    }

    private DefaultKingdeeTreeNode createTreeNode(Object obj, DefaultKingdeeTreeNode parent) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(obj);
        if (parent != null) {
            parent.add((MutableTreeNode)newNode);
        }
        return newNode;
    }

    private void addTreeNode(KDTree tree, CubeData cubeData, DefaultKingdeeTreeNode parent) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)cubeData);
        newNode.setAllowsChildren(cubeData.hasChild());
        if (!cubeData.hasChild()) {
            newNode.setCustomIcon((Icon)NonIcon.getInstance());
        }
        tree.addNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parent);
    }

    private void buildKeyboardButton() {
        for (int row = 0; row < KEYBOARD_ROW; ++row) {
            for (int col = 0; col < KEYBOARD_COL; ++col) {
                if (this.keyboradButton[row][col] != null) continue;
                this.keyboradButton[row][col] = new KDWorkButton(keyborad[row][col]);
                this.keyboradButton[row][col].setMinimumSize(new java.awt.Dimension(0, 0));
                this.keyboradButton[row][col].addActionListener((ActionListener)this.keyboardActionListener);
            }
        }
    }

    private void buildDataTree() {
        if (this.dataTree != null) {
            return;
        }
        this.dataTree = new KDTree((TreeModel)new DataTreeModel(this.olapModel.getCubeName()), false);
        this.dataTree.setRootVisible(true);
        this.dataTree.setShowsRootHandles(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.dataTree.setSelectionModel((TreeSelectionModel)selectionModel);
        this.dataTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (treeNode.getChildCount() == 0) {
                    CalculateMemberBuilderUIPanel.this.expandNode(treeNode);
                }
            }
        });
        this.dataTree.addTreeSelectionListener((TreeSelectionListener)this.treeSelectionListener);
        this.dataTree.addMouseListener((MouseListener)this.treeMouseAdapter);
    }

    private void expandNode(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof CubeData) {
            CubeData treeNode = (CubeData)node.getUserObject();
            MemberTree memberTree = null;
            switch (treeNode.getType()) {
                case 1: {
                    Dimension dim = this.olapModel.lookupDimension(treeNode.getUniqueName());
                    if (dim == null) {
                        return;
                    }
                    Hierarchy[] hiers = dim.getHierarchies();
                    if (hiers.length <= 0) break;
                    memberTree = OlapModelUtil.getMemberTree(this.olapModel);
                    Level[] levels = hiers[0].getLevels();
                    for (int i = 0; i < levels.length; ++i) {
                        boolean hasChild = memberTree.getRootMembers(levels[i].getHierarchy()).length > 0;
                        this.addTreeNode(this.dataTree, new CubeData(2, levels[i].getUniqueName(), levels[i].getCaption(), hasChild), node);
                    }
                    break;
                }
                case 2: {
                    Level level = this.olapModel.lookupLevel(treeNode.getUniqueName());
                    memberTree = OlapModelUtil.getMemberTree(this.olapModel);
                    ArrayList<Member> memberList = new ArrayList<Member>();
                    memberList.addAll(Arrays.asList(memberTree.getRootMembers(level.getHierarchy())));
                    for (int nLevel = level.getDepth(); nLevel > 0; --nLevel) {
                        ArrayList<Member> tempList = new ArrayList<Member>();
                        for (int i = 0; i < memberList.size(); ++i) {
                            Member member = (Member)memberList.get(i);
                            if (member == null || !memberTree.hasChildren(member)) continue;
                            tempList.addAll(Arrays.asList(memberTree.getChildren(member)));
                        }
                        memberList.clear();
                        memberList.addAll(tempList);
                        if (memberList.size() != 0) continue;
                        break;
                    }
                    for (int i = 0; i < memberList.size(); ++i) {
                        int type;
                        Member member = (Member)memberList.get(i);
                        int n = type = member.getDimension().isMeasure() ? 4 : 3;
                        if (member == null) continue;
                        this.addTreeNode(this.dataTree, new CubeData(type, member.getUniqueName(), member.getCaption(), !member.isLeaf()), node);
                    }
                    break;
                }
                case 3: {
                    Member memberNode = this.olapModel.lookupMember(treeNode.getUniqueName());
                    memberTree = OlapModelUtil.getMemberTree(this.olapModel);
                    if (memberNode == null || !memberTree.hasChildren(memberNode)) break;
                    Member[] memberChildren = memberTree.getChildren(memberNode);
                    for (int i = 0; i < memberChildren.length; ++i) {
                        if (memberChildren[i] == null) continue;
                        this.addTreeNode(this.dataTree, new CubeData(3, memberChildren[i].getUniqueName(), memberChildren[i].getCaption(), !memberChildren[i].isLeaf()), node);
                    }
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean parseForularXml(InputStream is, DefaultKingdeeTreeNode root) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildFormularTree() {
        if (this.formularTree != null) {
            return;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"Formular");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(this.xmlFilePathName);
        if (is != null) {
            this.parseForularXml(is, root);
        }
        this.formularTree = new KDTree((ITreeNode)root, false);
        this.formularTree.setRootVisible(false);
        this.formularTree.setShowsRootHandles(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.formularTree.setSelectionModel((TreeSelectionModel)selectionModel);
        this.formularTree.addTreeSelectionListener((TreeSelectionListener)this.treeSelectionListener);
        this.formularTree.addMouseListener((MouseListener)this.treeMouseAdapter);
    }

    private void addKeyboardButton(Table table) {
        for (int row = 0; row < KEYBOARD_ROW; ++row) {
            for (int col = 0; col < KEYBOARD_COL; ++col) {
                if (this.keyboradButton[row][col] == null) continue;
                this.add((Component)this.keyboradButton[row][col], table.cell(row, col));
            }
        }
    }

    void handleValueChange(KDTree tree) {
        this.nowSelectionTree = tree;
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            TreenodeAbility obj = (TreenodeAbility)node.getUserObject();
            this.setBuildedString(obj.getFormat());
            this.commentPrompt.setText(obj.getComment());
            this.formatPrompt.setText(obj.getFormat());
            this.insertButton.setEnabled(obj.canInsert());
        } else {
            this.setBuildedString("");
            this.commentPrompt.setText("");
            this.formatPrompt.setText("");
            this.insertButton.setEnabled(false);
        }
    }

    class TreeMouseAdapter
    extends MouseAdapter {
        TreeMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof KDTree) {
                KDTree tree = (KDTree)e.getSource();
                if (e.getClickCount() == 1 && tree != CalculateMemberBuilderUIPanel.this.nowSelectionTree) {
                    CalculateMemberBuilderUIPanel.this.handleValueChange(tree);
                } else if (e.getClickCount() == 2 && CalculateMemberBuilderUIPanel.this.insertButton.isEnabled()) {
                    CalculateMemberBuilderUIPanel.this.adjustBuildedString();
                    tree.collapsePath(tree.getSelectionPath());
                    CalculateMemberBuilderUIPanel.this.fireDataChanged(new DataChangeEvent((Object)CalculateMemberBuilderUIPanel.this));
                }
            }
        }
    }

    class KeyboardActionListener
    implements ActionListener {
        KeyboardActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CalculateMemberBuilderUIPanel.this.setBuildedString(e.getActionCommand(), true);
            CalculateMemberBuilderUIPanel.this.fireDataChanged(new DataChangeEvent((Object)CalculateMemberBuilderUIPanel.this));
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getSource() instanceof KDTree) {
                CalculateMemberBuilderUIPanel.this.handleValueChange((KDTree)e.getSource());
            }
        }
    }

    class DataTreeModel
    extends DefaultTreeModel
    implements TreeModel {
        private static final long serialVersionUID = 1L;
        String cubeName;

        DataTreeModel(String cube) {
            super(null, true);
            this.setRoot(this.createRoot(StringUtil.bracketsAround(cube), cube));
            this.cubeName = cube;
            this.expandRoot();
        }

        private TreeNode createRoot(String uniqueName, String caption) {
            CubeData rootData = new CubeData(0, uniqueName, caption, true);
            return new DefaultKingdeeTreeNode((Object)rootData);
        }

        private void expandRoot() {
            Dimension[] dims = CalculateMemberBuilderUIPanel.this.olapModel.getDimensions();
            for (int i = 0; i < dims.length; ++i) {
                boolean hasChild = dims[i].getHierarchies()[0].getLevels().length > 0;
                CalculateMemberBuilderUIPanel.this.createTreeNode(new CubeData(1, dims[i].getUniqueName(), dims[i].getCaption(), hasChild), (DefaultKingdeeTreeNode)this.root);
            }
        }
    }
}

