/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.ICubeModelEditorListener;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.ActionHelper;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.BaseAction;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.DiagramHelper;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.FileStorage;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.IStorage;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.MenuItem;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.NodeData;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.WizardHelper;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.CubeModelDataProvider;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.CubeModelDataProviderFactory;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Dimension;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Join;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Table;
import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLNode;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.ui.TreeView;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CubeModelEditor
extends KDPanel {
    HashMap mapCubeToMapRefCount = new HashMap();
    private List cmListenerList = new ArrayList(1);
    private TreeView treeView;
    KDTree tree;
    KDPanel paneDiagram;
    CubeModelDataProvider dataProvider;
    DiagramHelper diagramHelper;
    WizardHelper wizardHelper = new WizardHelper(this);
    ActionHelper actionHelper = new ActionHelper(this);
    Icon iconCubeModel;
    Icon iconCube;
    Icon iconFact;
    Icon iconDimension;
    Icon iconTable;
    Icon iconJoin;
    Icon iconMeasure;
    Icon iconLevel;
    KDToolBar toolbar;
    KDMenuBar mb;
    JMenu selectedMenu;
    private boolean showOpen;
    private boolean dirty = false;
    final int[] markNodeType = new int[]{10, 0, 20, 60, 70};
    Action extendAfterExitAction;
    Action extendAfterSaveAction;
    public IStorage defaultStorage;
    private IStorage storage;
    private Window window;

    public CubeModelEditor(CubeModelDataProvider dataProvider, boolean showOpen) {
        this.dataProvider = dataProvider;
        this.initIcon();
        this.installComponent();
        this.installListener();
        this.showOpen = showOpen;
    }

    private void initIcon() {
        this.iconCubeModel = Resources.getIcon("icon/cubemodel.gif");
        this.iconCube = Resources.getIcon("icon/cube.gif");
        this.iconDimension = Resources.getIcon("icon/dimension.gif");
        this.iconFact = Resources.getIcon("icon/fact.gif");
        this.iconTable = Resources.getIcon("icon/table.gif");
        this.iconMeasure = Resources.getIcon("icon/measure.gif");
        this.iconJoin = Resources.getIcon("icon/join.gif");
        this.iconLevel = Resources.getIcon("icon/level.gif");
    }

    private void installComponent() {
        this.initTree();
        this.treeView = new TreeView(this.tree);
        this.paneDiagram = new KDPanel((LayoutManager)new BorderLayout());
        this.diagramHelper = new DiagramHelper(this, (JComponent)this.paneDiagram);
        KDSplitPane spl = new KDSplitPane();
        spl.setDividerSize(10);
        spl.setDividerLocation(400);
        spl.setLeftComponent((Component)this.treeView);
        spl.setRightComponent((Component)this.paneDiagram);
        this.setLayout(new BorderLayout());
        this.add((Component)spl, "Center");
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = this.createNode(0, CubeModelResource.getString(CubeModelResource.class, (String)"CubeModel"), "", this.iconCubeModel, null);
        this.tree = new KDTree((ITreeNode)root, false, true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowPopMenuDefaultItem(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer((TreeCellRenderer)new DefaultKingdeeTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return super.getTreeCellRendererComponent(jtree, value, selected, expanded, leaf, row, hasFocus);
            }
        });
    }

    private void installListener() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CubeModelEditor.this.nodeChanged(e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
            }
        });
        this.tree.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent e) {
                return e.getClosestPath() != null && e.getClosestPath().equals(CubeModelEditor.this.tree.getSelectionPath()) && CubeModelEditor.this.tree.getPopupMenu().getComponentCount() > 0;
            }
        });
    }

    private void nodeChanged(TreePath oldPath, TreePath newPath) {
        if (newPath == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)newPath.getLastPathComponent();
        NodeData nodeData = (NodeData)node.getUserObject();
        this.installMenu(this.tree.getPopupMenu(), nodeData.popActionList);
        if (this.selectedMenu != null) {
            this.installMenu(this.selectedMenu, nodeData.popActionList);
        }
        this.actionHelper.doSelect(node);
    }

    private void installMenu(JComponent sys, List items) {
        sys.removeAll();
        for (int i = 0; i < items.size(); ++i) {
            sys.add((Component)((Object)new MenuItem((BaseAction)items.get(i))));
        }
    }

    public KDMenuBar getMenuBar() {
        if (this.mb == null) {
            this.mb = new KDMenuBar();
            this.mb.hideLogo();
            this.mb.setPreferredSize(new Dimension(100, 26));
            JMenu menuFile = new JMenu(CubeModelResource.getString(CubeModelResource.class, (String)"File"));
            if (this.showOpen) {
                menuFile.add((JMenuItem)((Object)new MenuItem(this.getOpenModelAction())));
            }
            menuFile.add((JMenuItem)((Object)new MenuItem(this.getSaveModelAction())));
            menuFile.add((JMenuItem)((Object)new MenuItem(this.getExportAsOLAPConfigFileAction())));
            menuFile.add((JMenuItem)((Object)new MenuItem(this.getExitAction())));
            this.mb.add(menuFile);
            this.selectedMenu = new JMenu(CubeModelResource.getString(CubeModelResource.class, (String)"Selected"));
            this.mb.add(this.selectedMenu);
        }
        return this.mb;
    }

    public KDToolBar getToolBar() {
        if (this.toolbar == null) {
            this.toolbar = new KDToolBar();
        }
        return this.toolbar;
    }

    private BaseAction getOpenModelAction() {
        return new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"Open"), Resources.getIcon("icon/tbtn_open.gif"), -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CubeModelEditor.this.canExit()) {
                    CubeModelEditor.this.actionHelper.doOpenModel();
                }
            }
        };
    }

    private BaseAction getSaveModelAction() {
        return new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"Save"), Resources.getIcon("icon/tbtn_saveas.gif"), -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelEditor.this.save();
            }
        };
    }

    private BaseAction getExportAsOLAPConfigFileAction() {
        return new BaseAction("\u5bfc\u51fa\u4e3aOLAP\u914d\u7f6e\u6587\u4ef6", null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelEditor.this.exportAsOLAPConfigFile();
            }
        };
    }

    private BaseAction getExitAction() {
        return new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"Exit"), Resources.getIcon("icon/tbtn_quit.gif"), -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelEditor.this.exit();
            }
        };
    }

    private List getPopActionList(int type) {
        ArrayList<BaseAction> list = new ArrayList<BaseAction>();
        switch (type) {
            case 0: {
                list.add(new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"NewCubeModel"), null, -1){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CubeModelEditor.this.wizardHelper.doCreateCubeWizard()) {
                            CubeModelEditor.this.fireModifiedChanged(true);
                        }
                    }
                });
                break;
            }
            case 10: {
                list.add(new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"Delete"), null, -1){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CubeModelEditor.this.actionHelper.doDeleteCube(false)) {
                            CubeModelEditor.this.fireModifiedChanged(true);
                        }
                    }
                });
                break;
            }
            case 60: {
                list.add(new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"NewDimension"), null, -1){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CubeModelEditor.this.wizardHelper.doCreateDimensionWizard()) {
                            CubeModelEditor.this.fireModifiedChanged(true);
                        }
                    }
                });
                break;
            }
            case 70: {
                list.add(new BaseAction("\u7f16\u8f91", null, -1){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CubeModelEditor.this.wizardHelper.doEditCubeNodeWizard()) {
                            CubeModelEditor.this.fireModifiedChanged(true);
                        }
                    }
                });
                list.add(new BaseAction(CubeModelResource.getString(CubeModelResource.class, (String)"Delete"), null, -1){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CubeModelEditor.this.actionHelper.doDeleteDimension(false)) {
                            CubeModelEditor.this.fireModifiedChanged(true);
                        }
                    }
                });
                break;
            }
            case 20: {
                list.add(new BaseAction("\u7f16\u8f91", null, -1){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (CubeModelEditor.this.wizardHelper.doEditCubeNodeWizard()) {
                            CubeModelEditor.this.fireModifiedChanged(true);
                        }
                    }
                });
                break;
            }
        }
        return list;
    }

    public void exit() {
        if (this.canExit()) {
            if (this.extendAfterExitAction != null) {
                this.extendAfterExitAction.actionPerformed(null);
            }
            this.getWindow().dispose();
        }
    }

    public void save() {
        if (this.actionHelper.doSaveModel()) {
            this.fireModifiedChanged(false);
            if (this.extendAfterSaveAction != null) {
                this.extendAfterSaveAction.actionPerformed(null);
            }
            WindowUtil.alert((Component)this.getWindow(), (String)CubeModelResource.getString(CubeModelResource.class, (String)"SaveSucceed"));
        }
    }

    public CubeModel getCubeModel() {
        return this.actionHelper.parseCubeModel();
    }

    private void exportAsOLAPConfigFile() {
        if (this.actionHelper.exportAsOLAPConfig()) {
            WindowUtil.alert((Component)this.getWindow(), (String)CubeModelResource.getString(CubeModelResource.class, (String)"SaveSucceed"));
        }
    }

    public boolean canExit() {
        if (this.dirty) {
            int r = MessageDialog.show((Component)this.window, (Object)CubeModelResource.getString(CubeModelResource.class, (String)"ShouldSave"), (String)CubeModelResource.getString(CubeModelResource.class, (String)"Information"), (int)1);
            if (r == 0) {
                if (this.actionHelper.doSaveModel()) {
                    this.fireModifiedChanged(false);
                    return true;
                }
                return false;
            }
            return r == 1;
        }
        return true;
    }

    public void setExtendAfterExitAction(Action action) {
        this.extendAfterExitAction = action;
    }

    public void setExtendAfterSaveAction(Action action) {
        this.extendAfterSaveAction = action;
    }

    DefaultKingdeeTreeNode createNode(int type, String label, String id, Icon icon, XMLNode model) {
        NodeData data = new NodeData();
        data.icon = icon;
        data.id = id;
        data.model = model;
        data.type = type;
        data.popActionList = this.getPopActionList(type);
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        node.setText(label);
        if (icon != null) {
            node.setCustomIcon(icon);
        }
        node.setUserObject((Object)data);
        Color c = Color.BLACK;
        Color b = Color.BLUE.darker();
        Color bb = Color.GREEN.darker();
        Color[] markNodeColor = new Color[]{b, b, bb, b, bb};
        int n = this.markNodeType.length;
        for (int i = 0; i < n; ++i) {
            if (type != this.markNodeType[i]) continue;
            c = markNodeColor[i];
            break;
        }
        node.setTextColor(c);
        return node;
    }

    DefaultKingdeeTreeNode getRootNode() {
        return (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
    }

    DefaultKingdeeTreeNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultKingdeeTreeNode)path.getLastPathComponent();
    }

    DefaultKingdeeTreeNode getSelectedCubeNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object[] nodes = path.getPath();
        if (nodes.length < 2) {
            return null;
        }
        DefaultKingdeeTreeNode cubeNode = (DefaultKingdeeTreeNode)nodes[1];
        return cubeNode;
    }

    DefaultKingdeeTreeNode getSelectedDimensionFolderNode() {
        DefaultKingdeeTreeNode cubeNode = this.getSelectedCubeNode();
        if (cubeNode == null) {
            return null;
        }
        Enumeration children = cubeNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (((NodeData)node.getUserObject()).type != 60) continue;
            return node;
        }
        return null;
    }

    DefaultKingdeeTreeNode getSelectedJoinFolderNode() {
        DefaultKingdeeTreeNode cubeNode = this.getSelectedCubeNode();
        if (cubeNode == null) {
            return null;
        }
        Enumeration children = cubeNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (((NodeData)node.getUserObject()).type != 100) continue;
            return node;
        }
        return null;
    }

    CubeModel_Dimension[] findDimensionUsingJoin(CubeModel_Cube cube, String joinName) {
        CubeModel_Dimension[] dims = cube.getDimensions();
        ArrayList<CubeModel_Dimension> list = new ArrayList<CubeModel_Dimension>(1);
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i].getFactJoinRef() == null || !joinName.equals(dims[i].getFactJoinRef().getName())) continue;
            list.add(dims[i]);
        }
        dims = new CubeModel_Dimension[list.size()];
        list.toArray(dims);
        return dims;
    }

    CubeModel_Join findJoin(CubeModel_Cube cube, String joinName) {
        CubeModel_Join[] joins = cube.getJoins();
        for (int i = 0; i < joins.length; ++i) {
            if (!joins[i].getName().equals(joinName)) continue;
            return joins[i];
        }
        return null;
    }

    CubeModel_Table findTable(CubeModel_Cube cube, String tableName) {
        CubeModel_Table[] tables = cube.getTables();
        for (int i = 0; i < tables.length; ++i) {
            if (!tables[i].getName().equals(tableName)) continue;
            return tables[i];
        }
        return null;
    }

    String tableKey(String str) {
        return "Table:" + str;
    }

    String joinKey(String str) {
        return "Join:" + str;
    }

    void clearAll() {
        this.mapCubeToMapRefCount.clear();
        this.diagramHelper.clear();
        this.tree.removeAllChildrenFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)this.tree.getModel().getRoot()));
        this.tree.invalidate();
    }

    public void setCubeModel(CubeModel cubeModel) throws AnalysisException {
        this.actionHelper.setCubeModel(cubeModel);
    }

    public IStorage getStorage() {
        if (this.storage == null) {
            if (this.defaultStorage == null) {
                this.defaultStorage = new FileStorage(this.getWindow());
            }
            return this.defaultStorage;
        }
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public Window getWindow() {
        return this.window;
    }

    public void autoLayout() {
        this.diagramHelper.autoLayout();
    }

    public void addCubeModelEditorListener(ICubeModelEditorListener l) {
        this.cmListenerList.add(l);
    }

    public void removeCubeModelEditorListener(ICubeModelEditorListener l) {
        this.cmListenerList.remove(l);
    }

    private void fireModifiedChanged(boolean dirty) {
        this.dirty = dirty;
        int n = this.cmListenerList.size();
        for (int i = 0; i < n; ++i) {
            ((ICubeModelEditorListener)this.cmListenerList.get(i)).modifiedChanged(dirty);
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        KDFrame frame = new KDFrame("MD" + CubeModelResource.getString(CubeModelResource.class, (String)"CubeModelDesigner"));
        CubeModelDataProvider sampleDataProvider = CubeModelDataProviderFactory.getCubeModelDataProvider("sample");
        final CubeModelEditor cme = new CubeModelEditor(sampleDataProvider, true);
        frame.getContentPane().add((Component)((Object)cme));
        frame.setSize(800, 600);
        frame.setExtendedState(6);
        frame.setLocationRelativeTo(null);
        if (cme.getToolBar() != null) {
            frame.addToolBar((JToolBar)cme.getToolBar());
        }
        if (cme.getMenuBar() != null) {
            frame.setJMenuBar((JMenuBar)cme.getMenuBar());
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                cme.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        cme.setWindow((Window)frame);
        frame.show();
    }

    public final ActionHelper getActionHelper() {
        return this.actionHelper;
    }
}

