/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.format;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

public class FormatModel {
    public static final int FORMAT_TYPE_NUMBER = 0;
    public static final int FORMAT_TYPE_PERCENT = 1;
    public static final int FORMAT_TYPE_CURRENCY = 2;
    private String s;
    private int formatType;
    private int precision;
    private boolean split;

    public FormatModel(String source) {
        this.s = source;
        this.parse();
    }

    private void parse() {
        String currencySymbol = FormatModel.getCurrencySymbol();
        this.formatType = this.s.indexOf(currencySymbol) != -1 ? 2 : (this.s.indexOf(37) != -1 ? 1 : 0);
        this.split = this.s.indexOf(44) != -1;
        int dot = this.s.indexOf(46);
        this.precision = dot == -1 ? 0 : this.s.length() - dot - 1;
    }

    public boolean isSplit() {
        return this.split;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getFormatType() {
        return this.formatType;
    }

    public static String getNumberFormatString(int precision, boolean split) {
        StringBuffer sb = new StringBuffer();
        FormatModel.appendIntegral(split, sb);
        FormatModel.appendPrecision(precision, sb);
        return sb.toString();
    }

    public static String getPercentFormatString(int precision) {
        StringBuffer sb = new StringBuffer();
        FormatModel.appendIntegral(false, sb);
        FormatModel.appendPrecision(precision, sb);
        sb.append('%');
        return sb.toString();
    }

    public static String getCurrencyFormatString(int precision, boolean split) {
        StringBuffer sb = new StringBuffer(FormatModel.getCurrencySymbol());
        FormatModel.appendIntegral(split, sb);
        FormatModel.appendPrecision(precision, sb);
        return sb.toString();
    }

    private static void appendIntegral(boolean split, StringBuffer sb) {
        if (split) {
            sb.append("#,##0");
        } else {
            sb.append("#");
        }
    }

    private static void appendPrecision(int precision, StringBuffer sb) {
        if (precision > 0) {
            sb.append('.');
            for (int i = 0; i < precision; ++i) {
                sb.append('0');
            }
        }
    }

    public static String getCurrencySymbol() {
        return Currency.getInstance(Locale.getDefault()).getSymbol();
    }

    public static void main(String[] args) throws Exception {
        NumberFormat nf = NumberFormat.getPercentInstance();
    }
}

