/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.AbstractLayoutUI;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIOManager;
import com.kingdee.bos.ctrl.analysis.web.solution.BIComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BITableLayout;

public class TableLayoutUI
extends AbstractLayoutUI {
    private BITableLayout layout = null;

    public TableLayoutUI(BITableLayout layout, UIOManager uioManager, BIReportFilter filter) {
        super(uioManager, filter);
        this.layout = layout;
    }

    private void createFilterUIOInfo(StringBuffer sb) throws BIReportException {
        if (this.filter != null) {
            sb.append("<tr>");
            sb.append("<td colspan='" + this.layout.getColumns() + "'>");
            this.createUIOInfo(this.uioManager.createFilterUIO(this.filter), sb);
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    @Override
    public String generateUI() throws BIReportException {
        StringBuffer sb = new StringBuffer();
        sb.append("TableLayout:");
        int rows = this.layout.getRows();
        int columns = this.layout.getColumns();
        sb.append("<table id='tablelayout_table' class='tablelayout_container' cellpadding='0' cellspacing='5'>");
        this.createFilterUIOInfo(sb);
        for (int index = 0; index < rows; ++index) {
            sb.append("<tr>");
            int rowColumns = this.layout.getRowCellCount(index);
            for (int index2 = 0; index2 < rowColumns; ++index2) {
                int colSpan = this.layout.getCellColSpan(index, index2);
                int rowSpan = this.layout.getCellRowSpan(index, index2);
                BIComponent com = this.layout.getCellComponent(index, index2);
                int width = 100 * colSpan / columns;
                int height = 100 * rowSpan / rows;
                sb.append("<td class='tablelayout' colspan='" + colSpan + "' rowspan='" + rowSpan + "' width='" + width + "%'>");
                if (com != null && com instanceof BIReportComponent) {
                    BIReportComponent component = (BIReportComponent)com;
                    if (component.getType().equals("worksheet")) {
                        this.createUIOInfo(this.uioManager.createWorksheetUIO(component, null, -1), sb);
                    } else if (component.getType().equals("chart")) {
                        this.createUIOInfo(this.uioManager.createChartUIO(component, null, -1), sb);
                    }
                } else {
                    sb.append("");
                }
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private void createUIOInfo(UIO uio, StringBuffer sb) {
        sb.append("\\$\\{ui:" + uio.getId() + "," + uio.getName() + "," + uio.getCaption() + "," + uio.getType() + "\\}");
    }
}

