/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.easkpi;

import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIException;
import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIRange;
import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIUtil;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.MathUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class EASKPI {
    public static int EDGE_TYPE_UP = 1;
    public static int EDGE_TYPE_DOWN = 2;
    public static int EDGE_TYPE_DOUBLE = 0;
    public String kpi;
    private String cu;
    private String ou;
    public String unit;
    public int showPercent;
    public int displayPrecision;
    public String title;
    public String myurl = "";
    public String errorMsg = "";
    public List lstBizDate = new ArrayList();
    public List lstNumValue = new ArrayList();
    public List lstNumMin = new ArrayList();
    public List lstNumMax = new ArrayList();
    public List lstNumMax2 = new ArrayList();
    public List lstNumMin2 = new ArrayList();
    public List lstColorI = new ArrayList();
    public List lstColorII = new ArrayList();
    public List lstColorIII = new ArrayList();

    public EASKPI(String kpi, String ou, String cu) {
        this.kpi = kpi;
        this.ou = ou;
        this.cu = cu;
    }

    public void init(HttpServletRequest request) throws BIReportException {
        Repository rep = BISystem.getRepository(request);
        try {
            if (StringUtils.isEmpty((String)this.kpi)) {
                throw new KPIException("\u672a\u7ed1\u5b9aKPI!");
            }
            String new_kpi = KPIUtil.handleOrgUnit(rep, this.ou, this.cu, this.kpi);
            List lstBizData = KPIUtil.getKPIETLData(rep, new_kpi);
            this.calcKPIData(lstBizData, rep, KPIUtil.getKPIUnitPrefix(request), KPIUtil.getColorSetting(rep), new_kpi);
        }
        catch (KPIException e) {
            this.errorMsg = e.getMessage();
        }
    }

    private Object getRowMapData(Map map, String field) {
        return map.get(field.toLowerCase());
    }

    private void calcKPIData(List lstBizData, Repository rep, String unitPrefix, String[] colorSetting, String kpiid) throws BIReportException, KPIException {
        int size = lstBizData.size();
        for (int j = 0; j < size; ++j) {
            Map mapBizDateRow = (Map)lstBizData.get(j);
            List lstKPIValue = KPIUtil.getKPIData(rep, (Timestamp)this.getRowMapData(mapBizDateRow, "fbizdate"), (Timestamp)this.getRowMapData(mapBizDateRow, "calTime"), kpiid);
            if (lstKPIValue.size() == 0) continue;
            String KPIValueTime = ((Map)lstKPIValue.get(0)).get("KPIValueTime".toLowerCase()).toString();
            this.lstBizDate.add(KPIValueTime);
            Object objUnit = ((Map)lstKPIValue.get(0)).get("KPIUnit".toLowerCase());
            this.unit = unitPrefix + (objUnit == null ? "" : objUnit.toString());
            boolean isPercent = false;
            Object objPercent = ((Map)lstKPIValue.get(0)).get("isPercent".toLowerCase());
            if (objPercent instanceof Number) {
                isPercent = ((Number)objPercent).intValue() == 1;
            }
            this.showPercent = isPercent ? 2 : 1;
            this.displayPrecision = 2;
            Object o = ((Map)lstKPIValue.get(0)).get("displayPrecision".toLowerCase());
            if (o != null || o instanceof Number) {
                this.displayPrecision = ((Number)o).intValue();
            }
            this.title = ((Map)lstKPIValue.get(0)).get("KPIName".toLowerCase()).toString();
            String strEdgeType = ((Map)lstKPIValue.get(0)).get("edgeType".toLowerCase()).toString();
            BigDecimal kpiValue = (BigDecimal)((Map)lstKPIValue.get(0)).get("KPIValue".toLowerCase());
            this.lstNumValue.add(new Double(MathUtil.round(kpiValue.doubleValue(), this.displayPrecision)));
            KPIRange range = KPIUtil.getKPIItemData(strEdgeType, lstKPIValue, this.displayPrecision, this.lstNumMax2, this.lstNumMin2, kpiValue);
            this.lstNumMin.add(new Double(range.min));
            this.lstNumMax.add(new Double(range.max));
            this.lstColorI.add(colorSetting[range.color1]);
            this.lstColorII.add(colorSetting[range.color2]);
            this.lstColorIII.add(colorSetting[range.color3]);
        }
    }
}

