/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.piece;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.chart.RadarChartConfig;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.XMLConfig;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jdom2.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DynamicPiece
implements Piece,
Serializable {
    private static final long serialVersionUID = 717980430741559886L;
    private String name;
    private String caption;
    private String parentPath;
    private String mdx;
    private Object[] params;
    private Object[] filterCaptions;
    private String componentType;
    private String chartType;
    private String schemeName;
    private RadarChartConfig radarConfig;
    private int currentPage;
    private int perPageRows;
    private String subjectName;
    private String reportPath;
    private String themePath;
    private String datacenter;
    private HashMap props = new HashMap();
    private static final String ATTR_PIECE_NAME = "name";
    private static final String ATTR_PIECE_CAPTION = "caption";
    private static final String ATTR_PIECE_TYPE = "type";
    private static final String ATTR_PIECE_CHART_TYPE = "chartType";
    private static final String ATTR_PIECE_CURRENTPAGE = "currentpage";
    private static final String ATTR_PIECE_PERPAGEROWS = "perPageRows";
    private static final String ATTR_PIECE_CHART_RADAR_CONFIG = "radarConfig";
    private static final String ATTR_PIECE_SCHEME = "scheme";
    private static final String ATTR_MDX_VALUE = "value";
    private static final String ATTR_REPORT_REF = "ref";
    private static final String ATTR_FILTER_ITEM_INDEX = "index";
    private static final String ATTR_FILTER_ITEM_VALUE = "value";
    private static final String ATTR_FILTER_ITEM_CAPTION = "caption";
    private static final String TAG_DYNAMIC_PIECE = "dynamic_piece";
    private static final String TAG_MDX = "mdx";
    private static final String TAG_REPORT = "report";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_FILTER_ITEM = "filter_item";
    private static final String TAG_FILTER_ITEM_ITEM = "item";
    private static final String TAG_PROPERTIES = "properties";
    private static final String TAG_PROPERTY = "property";

    public DynamicPiece(String name, String caption, String parentPath, String mdx, Object[] filterParams, Object[] filterCaptions, String subjectName, String reportPath, String componentType, String chartType, String schemeName, String themePath, String datacenter, int currentPage, int perPageRows) {
        this.name = name;
        this.caption = caption;
        this.parentPath = parentPath;
        this.mdx = mdx;
        this.params = filterParams;
        this.filterCaptions = filterCaptions;
        this.subjectName = subjectName;
        this.reportPath = reportPath;
        this.componentType = componentType;
        this.chartType = chartType;
        this.schemeName = schemeName;
        this.themePath = themePath;
        this.datacenter = datacenter;
        this.currentPage = currentPage;
        this.perPageRows = perPageRows;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    @Override
    public String getThemeID() {
        return this.themePath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    public String getChartType() {
        return this.chartType;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPerPageRows() {
        return this.perPageRows;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    public Object[] getFilterParams() {
        return this.params;
    }

    public Object[] getFilterCaptions() {
        return this.filterCaptions;
    }

    public String getMDX() {
        return this.mdx;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public RadarChartConfig getRadarConfig() {
        return this.radarConfig;
    }

    public void setRadarConfig(RadarChartConfig radarConfig) {
        this.radarConfig = radarConfig;
    }

    @Override
    public String save(HttpServletRequest request) throws BIReportException {
        try (Repository rep = null;){
            rep = BISystem.getRepository(request);
            String string = rep.savePiece(this, BISystem.getCurrentUser(request));
            return string;
        }
    }

    private String toXML() {
        Document doc = XmlUtil.createDocument();
        Element root = doc.createElement(TAG_DYNAMIC_PIECE);
        doc.appendChild(root);
        root.setAttribute(ATTR_PIECE_NAME, this.name);
        root.setAttribute("caption", this.caption);
        root.setAttribute(ATTR_PIECE_TYPE, this.componentType);
        root.setAttribute(ATTR_PIECE_CHART_TYPE, this.chartType);
        root.setAttribute(ATTR_PIECE_CURRENTPAGE, new Integer(this.currentPage).toString());
        root.setAttribute(ATTR_PIECE_PERPAGEROWS, new Integer(this.perPageRows).toString());
        root.setAttribute(ATTR_PIECE_SCHEME, this.schemeName);
        if (this.radarConfig != null) {
            root.setAttribute(ATTR_PIECE_CHART_RADAR_CONFIG, this.radarConfig.toJSON().toString());
        }
        Element reportEle = doc.createElement(TAG_REPORT);
        reportEle.setAttribute(ATTR_REPORT_REF, this.themePath);
        root.appendChild(reportEle);
        Element mdxEle = doc.createElement(TAG_MDX);
        mdxEle.setAttribute("value", this.mdx);
        root.appendChild(mdxEle);
        if (this.params != null && this.params.length > 0) {
            Element filterEle = doc.createElement(TAG_FILTER);
            root.appendChild(filterEle);
            for (int i = 0; i < this.params.length; ++i) {
                Element itemEle = doc.createElement(TAG_FILTER_ITEM);
                itemEle.setAttribute(ATTR_FILTER_ITEM_INDEX, "" + i);
                filterEle.appendChild(itemEle);
                if (this.params[i] == null) continue;
                List lstParams = (List)this.params[i];
                List lstCaptions = (List)this.filterCaptions[i];
                for (int j = 0; j < lstParams.size(); ++j) {
                    Element ele = doc.createElement(TAG_FILTER_ITEM_ITEM);
                    String value = (String)lstParams.get(j);
                    ele.setAttribute("value", value);
                    if (lstCaptions != null) {
                        String caption = (String)lstCaptions.get(j);
                        ele.setAttribute("caption", caption);
                    }
                    itemEle.appendChild(ele);
                }
            }
        }
        if (this.props.size() > 0) {
            Element propsEle = doc.createElement(TAG_PROPERTIES);
            root.appendChild(propsEle);
            for (Object key : this.props.keySet()) {
                Object value = this.props.get(key);
                Element propEle = doc.createElement(TAG_PROPERTY);
                propsEle.appendChild(propEle);
                propEle.setAttribute("key", key.toString());
                propEle.setAttribute("value", value.toString());
            }
        }
        StringWriter sw = new StringWriter();
        XmlUtil.print(doc, sw);
        return sw.toString();
    }

    @Override
    public byte[] toBinaryData() {
        try {
            return this.toXML().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static DynamicPiece fromXML(Repository rep, String xml) throws BIReportException {
        XMLConfig xc = null;
        org.jdom2.Element ele = null;
        try {
            xc = new XMLConfig(xml, "UTF-8");
        }
        catch (JDOMException e) {
            throw new BIReportException("\u7247\u6bb5xml\u89e3\u6790\u5931\u8d25!\n" + xml, e);
        }
        catch (IOException e) {
            throw new BIReportException("\u7247\u6bb5xml\u89e3\u6790\u5931\u8d25!\n" + xml, e);
        }
        ele = xc.getNodes("/dynamic_piece")[0];
        String name = ele.getAttributeValue(ATTR_PIECE_NAME);
        String caption = ele.getAttributeValue("caption");
        String componentType = ele.getAttributeValue(ATTR_PIECE_TYPE);
        String chartType = ele.getAttributeValue(ATTR_PIECE_CHART_TYPE);
        int currentPage = 0;
        try {
            currentPage = Integer.parseInt(ele.getAttributeValue(ATTR_PIECE_CURRENTPAGE));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int perPageRows = 0;
        try {
            perPageRows = Integer.parseInt(ele.getAttributeValue(ATTR_PIECE_PERPAGEROWS));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String schemeName = ele.getAttributeValue(ATTR_PIECE_SCHEME);
        String radarConfigJSONString = ele.getAttributeValue(ATTR_PIECE_CHART_RADAR_CONFIG);
        RadarChartConfig radarConfig = radarConfigJSONString != null ? new RadarChartConfig(radarConfigJSONString) : null;
        String parentPath = "";
        org.jdom2.Element eleReport = ele.getChild(TAG_REPORT);
        String themePath = eleReport.getAttributeValue(ATTR_REPORT_REF);
        String ws = "RPT";
        if (!rep.nodeExist(ws, themePath)) {
            throw new BIReportException("\u5173\u8054\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!");
        }
        String subjectName = "";
        String datacenter = null;
        try {
            subjectName = rep.getNodePropertyByPath(ws, themePath, "subject");
        }
        catch (RepositoryException e) {
            throw new BIReportException("\u5173\u8054\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!");
        }
        try {
            datacenter = rep.getNodePropertyByPath(ws, themePath, "datacenter");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        BISubject subject = BISystem.getSolution().lookupSubject(subjectName);
        String reportPath = "";
        try {
            reportPath = rep.getNodePropertyByPath(ws, themePath, "reportPath");
        }
        catch (RepositoryException e) {
            throw new BIReportException("\u5173\u8054\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!");
        }
        BIReport report = subject.lookupReport(reportPath, datacenter);
        if (report == null) {
            throw new BIReportException("\u5173\u8054\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!");
        }
        org.jdom2.Element eleMDX = ele.getChild(TAG_MDX);
        String mdx = "";
        if (eleMDX != null) {
            mdx = eleMDX.getAttributeValue("value");
        }
        Object[] filterParams = null;
        Object[] filterCaptions = null;
        org.jdom2.Element eleFilter = ele.getChild(TAG_FILTER);
        if (eleFilter != null) {
            ArrayList<List<String>> lstValue = new ArrayList<List<String>>();
            ArrayList<List<String>> lstCaption = new ArrayList<List<String>>();
            int itemCount = report.getFilter(null).getItemCount();
            for (int index = 0; index < itemCount; ++index) {
                org.jdom2.Element[] nodes = xc.getNodes("/dynamic_piece/filter/filter_item");
                boolean isEmpty = true;
                for (int j = 0; j < nodes.length; ++j) {
                    if (!("" + index).equalsIgnoreCase(nodes[j].getAttributeValue(ATTR_FILTER_ITEM_INDEX))) continue;
                    isEmpty = false;
                    ArrayList<String> lstTemp = new ArrayList<String>();
                    ArrayList<String> lstTemp2 = new ArrayList<String>();
                    List lst = nodes[j].getChildren();
                    for (org.jdom2.Element eleItem : lst) {
                        lstTemp.add(eleItem.getAttributeValue("value"));
                        lstTemp2.add(eleItem.getAttributeValue("caption"));
                    }
                    String[] sTemp = new String[lstTemp.size()];
                    String[] sTemp2 = new String[lstTemp2.size()];
                    for (int x = 0; x < lstTemp.size(); ++x) {
                        sTemp[x] = (String)lstTemp.get(x);
                        sTemp2[x] = (String)lstTemp2.get(x);
                    }
                    lstValue.add(Arrays.asList(sTemp));
                    lstCaption.add(Arrays.asList(sTemp2));
                }
                if (!isEmpty) continue;
                lstValue.add(new ArrayList());
                lstCaption.add(new ArrayList());
            }
            filterParams = lstValue.toArray();
            filterCaptions = lstCaption.toArray();
        }
        DynamicPiece dp = new DynamicPiece(name, caption, parentPath, mdx, filterParams, filterCaptions, subjectName, reportPath, componentType, chartType, schemeName, themePath, datacenter, currentPage, perPageRows);
        dp.setRadarConfig(radarConfig);
        org.jdom2.Element eleProps = ele.getChild(TAG_PROPERTIES);
        if (eleProps != null) {
            for (org.jdom2.Element eleProp : eleProps.getChildren()) {
                dp.props.put(eleProp.getAttributeValue("key"), eleProp.getAttributeValue("value"));
            }
        }
        return dp;
    }

    public String getProperty(String key) {
        return (String)this.props.get(key);
    }

    public void setProperty(String key, String value) {
        this.props.put(key, value);
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    public String getType() {
        return "dynamic";
    }
}

