/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.impl;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.DataProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.config.BIReportConfig;
import com.kingdee.bos.ctrl.analysis.web.solution.def.DataSourceDef;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BISolutionImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.DataProviderImpl;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BISubjectImpl
implements BISubject {
    private BIReportConfig rptDefConfig = null;
    private String name;
    private String caption;
    private String runtimeVarFilename;

    public BISubjectImpl(String name, String caption, String folder, String runtimeVarFilename) throws BIReportException {
        this.name = name;
        this.caption = caption;
        String subjectsPath = ((BISolutionImpl)BISystem.getSolution()).getSubjectsPath();
        this.rptDefConfig = new BIReportConfig(subjectsPath + folder);
        this.runtimeVarFilename = runtimeVarFilename;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRuntimeVarFilename() {
        return this.runtimeVarFilename;
    }

    @Override
    public String getRuntimeVarClassname() {
        try {
            return this.getVarClassName(this.runtimeVarFilename);
        }
        catch (BIReportException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getVarClassName(String filePathname) throws BIReportException {
        String var = "";
        try {
            Document doc;
            Element rootXML;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            File fileReport = new File(filePathname);
            if (fileReport.exists() && fileReport.length() > 0L && "VarConfig".equalsIgnoreCase((rootXML = (doc = builder.parse(new File(filePathname))).getDocumentElement()).getNodeName())) {
                var = XmlUtil.getNodeAttribute(rootXML, "class");
            }
        }
        catch (Exception e) {
            throw new BIReportException("\u53d8\u91cf\u7c7b\u5b9a\u4e49\u6587\u4ef6" + filePathname + "\u89e3\u6790\u51fa\u9519!", e);
        }
        if (var == null || var.equals("")) {
            var = "com.kingdee.eas.bi.subject.BaseVarProvider";
        }
        return var;
    }

    @Override
    public DataProvider lookupDataProvider(InputStream isDataSource, String datacenter) throws BIReportException {
        DataSourceDef dsf = new DataSourceDef(isDataSource);
        DataProviderImpl dp = new DataProviderImpl(dsf, datacenter);
        dsf.close();
        return dp;
    }

    @Override
    public BIReport lookupReport(String path, String datacenter) throws BIReportException {
        BIReportImpl report = (BIReportImpl)this.rptDefConfig.lookupReport(path, this);
        report.setDatacenter(datacenter);
        return report;
    }

    public String toString() {
        return this.caption;
    }
}

