/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet.span;

import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.NoSpanConfig;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanConfig;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanHeaderFactory;
import java.util.Iterator;

public class SpanCalc {
    int positionCount;
    int hierarchyCount;
    Span[][] spans;
    boolean initialized = false;
    SpanConfig config = new NoSpanConfig();
    boolean[][] forcePositionBreak;

    public SpanCalc(Span[][] spans) {
        this.spans = spans;
    }

    public SpanCalc(Axis axis) {
        this.positionCount = axis.getPositions().size();
        this.hierarchyCount = axis.getHierarchies().length;
        this.spans = new Span[this.positionCount][];
        for (int i = 0; i < this.positionCount; ++i) {
            this.spans[i] = new Span[this.hierarchyCount];
        }
        Iterator it = axis.getPositions().iterator();
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            Position p = (Position)it.next();
            this.createSpansFromAxis(axis, p, posIndex, this.spans[posIndex]);
        }
    }

    void createSpansFromAxis(Axis axis, Position position, int posIndex, Span[] spans) {
        Member[] members = position.getMembers();
        for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
            Member member = members[hierIndex];
            spans[hierIndex] = new Span(axis, position, member);
        }
    }

    void initialize() {
        if (!this.initialized) {
            this.positionCount = this.spans.length;
            if (this.positionCount > 0) {
                this.hierarchyCount = this.spans[0].length;
            }
            this.initSpans();
            this.calcSpans();
            this.calcIndent();
            this.initialized = true;
        }
    }

    void initSpans() {
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
                this.spans[posIndex][hierIndex].initialize(posIndex, hierIndex);
            }
        }
    }

    void calcSpans() {
        this.forcePositionBreak = new boolean[this.positionCount][this.hierarchyCount];
        for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
            for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
                int count;
                Span span = this.spans[posIndex][hierIndex];
                if (!span.isSignificant()) continue;
                int dir = this.config.chooseSpanDirection(span);
                if (dir == 1) {
                    this.makeHierSpan(span, 1);
                    this.addForcePositionBreak(span);
                    continue;
                }
                if (dir == 2) {
                    this.makePosSpan(span, 1);
                    this.addForcePositionBreak(span);
                    continue;
                }
                if (dir == 3) {
                    count = this.makeHierSpan(span, 1);
                    this.makePosSpan(span, count);
                    this.addForcePositionBreak(span);
                    continue;
                }
                if (dir != 4) continue;
                count = this.makePosSpan(span, 1);
                this.makeHierSpan(span, count);
                this.addForcePositionBreak(span);
            }
        }
    }

    int makeHierSpan(Span span, int posSpans) {
        int pi = span.positionIndex;
        int spanCount = 1;
        for (int hi = span.hierarchyIndex + 1; hi < this.hierarchyCount; ++hi) {
            Span s;
            int i;
            boolean equal = true;
            for (i = 0; i < posSpans; ++i) {
                s = this.spans[pi + i][hi];
                equal = equal && this.config.equals(span, s);
            }
            if (!equal) break;
            ++span.hierarchySpan;
            ++spanCount;
            for (i = 0; i < posSpans; ++i) {
                s = this.spans[pi + i][hi];
                s.significant = false;
                s.positionSpan = 0;
                s.hierarchySpan = 0;
            }
        }
        return spanCount;
    }

    int makePosSpan(Span span, int hierSpans) {
        int hi = span.hierarchyIndex;
        int spanCount = 1;
        for (int pi = span.positionIndex + 1; pi < this.positionCount && !this.forcePositionBreak[pi][hi]; ++pi) {
            Span s;
            int i;
            boolean equal = true;
            for (i = 0; i < hierSpans; ++i) {
                s = this.spans[pi][hi + i];
                equal = equal && this.config.equals(span, s);
            }
            if (!equal) break;
            ++span.positionSpan;
            ++spanCount;
            for (i = 0; i < hierSpans; ++i) {
                s = this.spans[pi][hi + i];
                s.significant = false;
                s.positionSpan = 0;
                s.hierarchySpan = 0;
            }
        }
        return spanCount;
    }

    void addForcePositionBreak(Span span) {
        int pi = span.positionIndex + span.positionSpan;
        for (int hi = span.hierarchyIndex + span.hierarchySpan; pi < this.positionCount && hi < this.hierarchyCount; ++hi) {
            this.forcePositionBreak[pi][hi] = true;
        }
    }

    public SpanCalc createPositionHeader(SpanHeaderFactory shf, Axis axis) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.positionCount == 0) {
            this.hierarchyCount = axis.getHierarchies().length;
            Span[][] header = new Span[1][this.hierarchyCount];
            for (int i = 0; i < this.hierarchyCount; ++i) {
                header[0][i] = new Span(axis.getHierarchies()[i]);
            }
            return new SpanCalc(header);
        }
        Span[][] header = new Span[1][this.hierarchyCount];
        header[0][0] = shf.create(this.spans[0][0]);
        for (int hi = 1; hi < this.hierarchyCount; ++hi) {
            int pi;
            for (pi = 0; pi < this.positionCount; ++pi) {
                Span prevSpan = this.spans[pi][hi - 1];
                Span curSpan = this.spans[pi][hi];
                if (this.config.equals(prevSpan, curSpan)) continue;
                prevSpan = curSpan;
                header[0][hi] = shf.create(curSpan);
                break;
            }
            if (pi != this.positionCount) continue;
            header[0][hi] = shf.create(this.spans[0][hi]);
        }
        return new SpanCalc(header);
    }

    public void addHierarchyHeader(SpanHeaderFactory shf, boolean removeDuplicates, Axis axis) {
        if (this.positionCount == 0) {
            this.hierarchyCount = axis.getHierarchies().length;
            this.hierarchyCount = axis.getHierarchies().length;
            this.spans = new Span[1][this.hierarchyCount];
            for (int i = 0; i < this.hierarchyCount; ++i) {
                this.spans[0][i] = new Span(axis.getHierarchies()[i]);
            }
        } else {
            boolean[] keep = new boolean[this.hierarchyCount * 2];
            this.createHeaderSpans(shf, keep);
            int newHierarchyCount = 0;
            for (int i = 0; i < keep.length; ++i) {
                if (!keep[i]) continue;
                ++newHierarchyCount;
            }
            this.removeDuplicateHeaders(keep, newHierarchyCount);
        }
        this.initialized = false;
    }

    void removeDuplicateHeaders(boolean[] keep, int newHierarchyCount) {
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            Span[] oldSpans = this.spans[posIndex];
            Span[] newSpans = new Span[newHierarchyCount];
            int newHierIndex = 0;
            for (int oldHierIndex = 0; oldHierIndex < oldSpans.length; ++oldHierIndex) {
                if (!keep[oldHierIndex]) continue;
                Span span = oldSpans[oldHierIndex];
                newSpans[newHierIndex++] = span;
            }
            this.spans[posIndex] = newSpans;
        }
    }

    void createHeaderSpans(SpanHeaderFactory shf, boolean[] keep) {
        for (int posIndex = 0; posIndex < this.positionCount; ++posIndex) {
            Span[] newSpans = new Span[this.hierarchyCount * 2];
            Span prevHeaderSpan = null;
            for (int hierIndex = 0; hierIndex < this.hierarchyCount; ++hierIndex) {
                Span span = this.spans[posIndex][hierIndex];
                Span curHeaderSpan = shf.create(span);
                if (prevHeaderSpan == null || !this.config.equals(prevHeaderSpan, curHeaderSpan)) {
                    keep[hierIndex] = true;
                    newSpans[hierIndex] = curHeaderSpan;
                    prevHeaderSpan = curHeaderSpan;
                } else {
                    newSpans[hierIndex] = (Span)span.clone();
                }
                keep[hierIndex + this.hierarchyCount] = true;
                newSpans[hierIndex + this.hierarchyCount] = span;
            }
            this.spans[posIndex] = newSpans;
        }
    }

    public Span getSpan(int positionIndex, int hierarchyIndex) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.spans[positionIndex][hierarchyIndex];
    }

    public int getHierarchyCount() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.hierarchyCount;
    }

    public int getPositionCount() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.positionCount;
    }

    public SpanConfig getConfig() {
        return this.config;
    }

    public void setConfig(SpanConfig config) {
        this.initialized = false;
        this.config = config;
    }

    public Span[][] getSpans() {
        return this.spans;
    }

    public void setSpans(Span[][] spans) {
        this.spans = spans;
        this.initialized = false;
    }

    void calcIndent() {
        for (int hi = 0; hi < this.hierarchyCount; ++hi) {
            Member m;
            Span s;
            int pi;
            int minRootDistance = Integer.MAX_VALUE;
            for (pi = 0; pi < this.positionCount; ++pi) {
                s = this.spans[pi][hi];
                if (!s.isMember() || (m = s.getMember()).getDepth() >= minRootDistance) continue;
                minRootDistance = m.getDepth();
            }
            for (pi = 0; pi < this.positionCount; ++pi) {
                s = this.spans[pi][hi];
                if (s.isMember()) {
                    m = s.getMember();
                    s.setIndent(m.getDepth() - minRootDistance);
                    continue;
                }
                s.setIndent(0);
            }
        }
    }

    public static SpanCalc appendBelow(SpanCalc above, SpanCalc below) {
        int hi;
        int pi;
        if (above == null) {
            return below;
        }
        if (below == null) {
            return above;
        }
        if (above.getHierarchyCount() != below.getHierarchyCount()) {
            throw new IllegalArgumentException("sizes dont match");
        }
        int HI = above.getHierarchyCount();
        Span[][] a = above.spans;
        Span[][] b = below.spans;
        Span[][] s = new Span[a.length + b.length][];
        for (pi = 0; pi < a.length; ++pi) {
            s[pi] = new Span[HI];
            for (hi = 0; hi < HI; ++hi) {
                s[pi][hi] = a[pi][hi];
            }
        }
        for (pi = 0; pi < b.length; ++pi) {
            s[pi + a.length] = new Span[HI];
            for (hi = 0; hi < HI; ++hi) {
                s[pi + a.length][hi] = b[pi][hi];
            }
        }
        return new SpanCalc(s);
    }
}

