/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.layout.linewrap;

import com.kingdee.bos.ctrl.common.util.KeyArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

public class LineWrap {
    private Line _xline = new Line();
    private Line _yline = new Line();
    public static final int XY_OUT_LINE = 0;
    public static final int XY_IN_CELL = 1;
    public static final int XY_IN_MARGIN = 2;
    public static final int XY_IN_LINE = 3;
    public static final int LAYOUT_XY = 1;
    public static final int LAYOUT_YX = 2;
    private int _layoutMode = 1;
    private KeyArrayList _cellList = new KeyArrayList();
    private ParseResult _result = new ParseResult();

    public LineWrap() {
        this._xline._cellXY = 50;
        this._yline._cellXY = 20;
    }

    public LineWrap(int layoutMode) {
        this._layoutMode = layoutMode;
        if (this._layoutMode == 1) {
            this._xline.setPreLen(4);
        } else {
            this._xline.setPreLen(4);
        }
        this._xline._cellXY = 50;
        this._yline._cellXY = 20;
    }

    public Object getCell(Object key) {
        return this._cellList.toObject(key);
    }

    public Object getCell(int index) {
        return this._cellList.get(index);
    }

    public int getCellWidth() {
        return this._xline._cellXY;
    }

    public void setCellWidth(int xy) {
        this._xline._cellXY = xy;
    }

    public int getCellHeight() {
        return this._xline._cellXY;
    }

    public void setCellHeight(int xy) {
        this._yline._cellXY = xy;
    }

    public int getCellMarginX() {
        return this._xline._marginXY;
    }

    public void setCellMarginX(int xy) {
        this._xline._marginXY = xy;
    }

    public int getCellMarginY() {
        return this._yline._marginXY;
    }

    public void setCellMarginY(int xy) {
        this._yline._marginXY = xy;
    }

    public int getLayoutMode() {
        return this._layoutMode;
    }

    public void setLayoutMode(int layoutMode) {
        this._layoutMode = layoutMode;
    }

    public ParseResult parseXY(int x, int y) {
        this._result.xPosition = this._xline.parseXY(x);
        this._result.xIndex = this._xline.getReturnIndex();
        this._result.yPosition = this._yline.parseXY(y);
        this._result.yIndex = this._yline.getReturnIndex();
        if (this._result.xPosition == 0 || this._result.yPosition == 0 || this._layoutMode == 1 && this._result.yPosition != 1 || this._layoutMode == 2 && this._result.xPosition != 1) {
            this._result.position = 0;
            this._result.index = -1;
            return this._result;
        }
        this._result.index = this._layoutMode == 1 ? this._result.xIndex + this._result.yIndex * this._xline._preLen : this._result.yIndex + this._result.xIndex * this._yline._preLen;
        if (this._result.index >= this._cellList.size()) {
            this._result.index = this._cellList.size();
            this._result.position = 3;
        } else {
            this._result.position = this._result.xPosition == 1 && this._result.yPosition == 1 ? 1 : 2;
        }
        return this._result;
    }

    public void addCell(Component cell) {
        this._cellList.add(cell);
    }

    public void insertCell(int index, Component cell) {
        this._cellList.add(index, cell);
    }

    public void removeCell(Component cell) {
        this._cellList.remove(cell);
    }

    public void removeCell(Object key) {
        this._cellList.removeKey(key);
    }

    public void moveCell(Object key, int index) {
        this._cellList.moveKey(key, index);
    }

    public void getCellShape(int index, Rectangle rc) {
        if (this._layoutMode == 1) {
            int lineLen = this._xline._preLen;
            rc.x = this._xline.toCellXY(index % lineLen);
            rc.y = this._yline.toCellXY(index / lineLen);
        } else {
            int lineLen = this._yline._preLen;
            rc.x = this._xline.toCellXY(index / lineLen);
            rc.y = this._yline.toCellXY(index % lineLen);
        }
        rc.width = this._xline._cellXY;
        rc.height = this._yline._cellXY;
    }

    public void getMarginShape(ParseResult r, Rectangle rc) {
        if (this._layoutMode == 1) {
            int lineLen = this._xline._preLen;
            int xyIndex = r.index % lineLen;
            rc.width = this._xline._marginXY;
            rc.height = this._yline._cellXY;
            rc.y = this._yline.toCellXY(r.index / lineLen);
            if (xyIndex == 0 && r.xPosition == 3) {
                rc.x = this._xline.toMarginXY(lineLen);
                rc.y = this._yline.toCellXY(r.index / lineLen - 1);
            } else {
                rc.x = this._xline.toMarginXY(xyIndex);
            }
        } else {
            int lineLen = this._yline._preLen;
            int xyIndex = r.index % lineLen;
            rc.width = this._xline._cellXY;
            rc.height = this._yline._marginXY;
            rc.x = this._xline.toCellXY(r.index / lineLen);
            if (xyIndex == 0 && r.yPosition == 3) {
                rc.y = this._yline.toMarginXY(this._yline._preLen);
                rc.x = this._xline.toCellXY(r.index / lineLen - 1);
            } else {
                rc.y = this._yline.toMarginXY(xyIndex);
            }
        }
    }

    public void layout(int width, int height) {
        this._xline._sizeXY = width;
        this._xline.makeCellCount();
        this._yline._sizeXY = height;
        this._yline.makeCellCount();
        this.layout();
    }

    public void layout() {
        int len = this._cellList.size();
        if (this._layoutMode == 1) {
            int lineLen = this._xline._preLen;
            this._yline.setPreLen((len + lineLen - 1) / lineLen);
            for (int i = 0; i < len; ++i) {
                ((Component)this._cellList.get(i)).setBounds(this._xline.toCellXY(i % lineLen), this._yline.toCellXY(i / lineLen), this._xline._cellXY, this._yline._cellXY);
            }
        } else {
            int lineLen = this._yline._preLen;
            this._xline.setPreLen((len + lineLen - 1) / lineLen);
            for (int i = 0; i < len; ++i) {
                ((Component)this._cellList.get(i)).setBounds(this._xline.toCellXY(i / lineLen), this._yline.toCellXY(i % lineLen), this._xline._cellXY, this._yline._cellXY);
            }
        }
    }

    Dimension getMaximumSize() {
        return new Dimension(this._xline.getMaximumXY(), this._yline.getMaximumXY());
    }

    Dimension getMinimumSize() {
        if (this._layoutMode == 1) {
            return new Dimension(this._xline.getMinimumXY(), this._yline.getPreferredXY());
        }
        return new Dimension(this._xline.getPreferredXY(), this._yline.getMinimumXY());
    }

    Dimension getPreferredSize() {
        return new Dimension(this._xline.getPreferredXY(), this._yline.getPreferredXY());
    }

    void setMaximumLayout(int xLen, int yLen) {
        this._xline._maxLen = xLen;
        this._yline._maxLen = yLen;
    }

    void setMinimumLayout(int xLen, int yLen) {
        this._xline._minLen = xLen;
        this._yline._minLen = yLen;
    }

    void setPreferredLayout(int xLen, int yLen) {
        this._xline.setPreLen(xLen);
        this._yline.setPreLen(yLen);
    }

    private static class Line {
        int _sizeXY;
        int _cellXY;
        int _marginXY;
        int _maxLen = Short.MAX_VALUE;
        int _minLen = 1;
        int _preLen = 1;
        int _returnIndex;

        private Line() {
        }

        int getReturnIndex() {
            return this._returnIndex;
        }

        int parseXY(int xy) {
            if (xy < 0 || xy > this._sizeXY) {
                this._returnIndex = -1;
                return 0;
            }
            this._returnIndex = this.toCellIndex(xy);
            if (this._returnIndex < this._preLen) {
                if (xy < this.toCellXY(this._returnIndex)) {
                    return 2;
                }
                return 1;
            }
            this._returnIndex = this._preLen;
            return 3;
        }

        int toCellXY(int index) {
            return this._marginXY + index * (this._marginXY + this._cellXY);
        }

        int toMarginXY(int index) {
            return index * (this._marginXY + this._cellXY);
        }

        int toCellIndex(int xy) {
            return xy / (this._marginXY + this._cellXY);
        }

        void makeCellCount() {
            this.setPreLen(this.toCellIndex(this._sizeXY));
        }

        void setPreLen(int preLen) {
            this._preLen = preLen < this._minLen ? this._minLen : (preLen > this._maxLen ? this._maxLen : preLen);
        }

        int getMaximumXY() {
            return this.toCellXY(this._maxLen);
        }

        int getMinimumXY() {
            return this.toCellXY(this._minLen);
        }

        int getPreferredXY() {
            return this.toCellXY(this._preLen);
        }
    }

    public static class ParseResult {
        public int xPosition;
        public int xIndex;
        public int yPosition;
        public int yIndex;
        public int position;
        public int index;
    }
}

