/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.tool;

import com.kingdee.bos.ctrl.common.tool.Params;
import com.kingdee.bos.ctrl.common.tool.TestGenerator;
import com.kingdee.bos.ctrl.common.tool.Util;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CodeGenerator
implements Params {
    private TestGenerator testCode = new TestGenerator();
    private static final String LISTENER_IMP_BEGIN = "class ${listener_title} implements ${listener_name} {\n\t";
    private static final String LISTENER_IMP_END = "\n}";
    private static final String METHOD_IMP = "public void ${method_name}(${event_name} evt) {\n\t${method_body}\n}";
    private static final String METHOD_TODO = "// TODO: add code here...";
    private static final String CODE_EVENTINFO_ERROR = "/** ${master_name}: ERROR occured when reading event info! */";
    private static final String CODE_NOEVENTS = "/** ${master_name}: NO EVENTS! */";
    private Map titles = new HashMap();

    public String generateListenerCode(Class cls) {
        return this.generateListenerClass(cls).toString();
    }

    public String getTestCode(String testClassName) {
        return this.testCode.getTestCode(testClassName);
    }

    public String generateAll(Class cls, String testClassName) {
        StringBuffer src = this.generateListenerClass(cls);
        StringBuffer test = this.testCode.getTestClass(testClassName);
        test.append('\n');
        test.append('\n');
        test.append(src);
        return test.toString();
    }

    public String generateBlackAll(Class cls, String testClassName) {
        StringBuffer src = this.generateListenerClass(cls);
        StringBuffer test = this.testCode.getBlackClass(cls, testClassName);
        test.append('\n');
        test.append('\n');
        test.append(src);
        return test.toString();
    }

    public String generateAll(Class cls, EventSetDescriptor[] events, String testClassName) {
        if (events == null) {
            throw new IllegalArgumentException("param events couldn't be null");
        }
        StringBuffer src = this.generateListenerClass(cls, events);
        StringBuffer test = this.testCode.getTestClass(testClassName);
        test.append('\n');
        test.append('\n');
        test.append(src);
        return test.toString();
    }

    public String generateBlackAll(Class cls, EventSetDescriptor[] events, String testClassName) {
        if (events == null) {
            throw new IllegalArgumentException("param events couldn't be null");
        }
        if (cls == null) {
            cls = Object.class;
        }
        StringBuffer src = this.generateListenerClass(cls, events);
        StringBuffer test = this.testCode.getBlackClass(cls, testClassName);
        test.append('\n');
        test.append('\n');
        test.append(src);
        return test.toString();
    }

    private StringBuffer generateListenerClass(Class cls) {
        StringBuffer code = new StringBuffer();
        EventSetDescriptor[] events = null;
        try {
            events = CodeGenerator.getEventList(cls);
        }
        catch (IntrospectionException e) {
            code.append(CODE_EVENTINFO_ERROR);
            Util.replace(code, "${master_name}", cls != null ? cls.getName() : null);
            return code;
        }
        code = this.generateListenerClass(cls, events);
        return code;
    }

    private StringBuffer generateListenerClass(Class cls, EventSetDescriptor[] events) {
        StringBuffer code = new StringBuffer();
        if (events == null || events.length == 0) {
            code.append(CODE_NOEVENTS);
            Util.replace(code, "${master_name}", cls != null ? cls.getName() : null);
            return code;
        }
        Method[] methods = null;
        String lstr = null;
        String astr = null;
        String[] mstr = null;
        String[] estr = null;
        int mcount = 0;
        for (int i = 0; i < events.length; ++i) {
            lstr = events[i].getListenerType().getName();
            astr = events[i].getAddListenerMethod().getName();
            methods = events[i].getListenerMethods();
            mcount = methods.length;
            mstr = new String[mcount];
            estr = new String[mcount];
            for (int j = 0; j < mcount; ++j) {
                mstr[j] = methods[j].getName();
                estr[j] = methods[j].getParameterTypes()[0].getName();
            }
            if (i > 0) {
                code.append('\n');
                code.append('\n');
            }
            code.append(this.generateCode(lstr, mstr, estr, astr));
        }
        return code;
    }

    private StringBuffer generateCode(String listener, String[] methods, String[] events, String addMethod) {
        StringBuffer l_body = new StringBuffer();
        StringBuffer method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (i > 0) {
                l_body.append('\n');
            }
            method = new StringBuffer(METHOD_IMP);
            Util.replace(method, "${method_name}", methods[i]);
            Util.replace(method, "${event_name}", events[i]);
            Util.replace(method, "${method_body}", METHOD_TODO);
            l_body.append(method);
        }
        Util.tab(l_body);
        StringBuffer target = new StringBuffer(LISTENER_IMP_BEGIN);
        String title = this.generateTitle(listener);
        Util.replace(target, "${listener_title}", title);
        Util.replace(target, "${listener_name}", listener);
        target.append(l_body);
        target.append(LISTENER_IMP_END);
        StringBuffer ret = new StringBuffer("/** @exclude */\n");
        ret.append(target);
        this.testCode.addTest(listener, title, methods, addMethod);
        return ret;
    }

    private String generateTitle(String listener) {
        String title = this.getMatchTitle(listener).toString();
        int index = 1;
        String key = title;
        while (this.titles.containsKey(key)) {
            key = title + index;
            ++index;
        }
        this.titles.put(key, null);
        return key;
    }

    private StringBuffer getMatchTitle(String listener) {
        String SUFFIX_LISTENER = "Listener";
        int LEN = "Listener".length();
        String SUFFIX_IMP = "Imp";
        String SUFFIX_HDL = "Handler";
        int pos = 0;
        StringBuffer ret = new StringBuffer(listener);
        pos = ret.lastIndexOf(".");
        if (pos != -1) {
            ret.delete(0, pos + 1);
        }
        if ((pos = ret.indexOf("Listener")) != -1) {
            ret.delete(pos, pos + LEN);
            ret.append("Handler");
        } else {
            ret.append("Imp");
        }
        return ret;
    }

    public static EventSetDescriptor[] getEventList(Class cls) throws IntrospectionException {
        if (cls == null) {
            return null;
        }
        BeanInfo info = null;
        info = Introspector.getBeanInfo(cls);
        EventSetDescriptor[] events = info.getEventSetDescriptors();
        return events;
    }
}

