/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Password {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected String _encryptPW;
    public static final String rule = "new_encode";
    private static final String DEFAULT_PRNG = "SHA1PRNG";
    private static String AES_ALGORITHM = "AES/GCM/PKCS5Padding";
    public static final int AES_KEY_SIZE = 256;
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;

    public void setPassword(String password) {
        this._encryptPW = "_" + Password.AESEncode(password);
    }

    public void setEncryptedPassword(String password) {
        this._encryptPW = password;
    }

    public String getEncryptedPassword() {
        if (this._encryptPW == null) {
            this._encryptPW = "";
        }
        return this._encryptPW;
    }

    public boolean confirm(String password) {
        if (this.getEncryptedPassword().startsWith("_")) {
            return StringUtil.equals(Password.AESDncode(this.getEncryptedPassword().substring(1)), password);
        }
        return StringUtil.equals(Password.genMD5Password(password), this.getEncryptedPassword());
    }

    private static String genMD5Password(String password) {
        if (StringUtil.isEmptyString(password)) {
            return "";
        }
        try {
            byte[] strTemp = password.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base64ToMD5(String str) {
        if (StringUtil.isEmptyString(str)) {
            return "";
        }
        return Password.genMD5Password(new String(Base64.decode(str)));
    }

    @Deprecated
    public static String AESEncode(String content) {
        if (StringUtil.isEmptyString(content)) {
            return "";
        }
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance(DEFAULT_PRNG);
            random.setSeed(rule.getBytes());
            keygen.init(128, random);
            SecretKey original_key = keygen.generateKey();
            byte[] raw = original_key.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, key);
            byte[] byte_encode = content.getBytes("utf-8");
            byte[] byte_AES = cipher.doFinal(byte_encode);
            String AES_encode = new String(Base64.encodeBytes(byte_AES));
            return AES_encode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String aesEncodeGCM(String content) {
        if (StringUtil.isEmptyString(content)) {
            return "";
        }
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance(DEFAULT_PRNG);
            random.setSeed(rule.getBytes());
            keygen.init(256, random);
            SecretKey k = keygen.generateKey();
            byte[] raw = k.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            byte[] iv = new byte[12];
            random.setSeed(System.currentTimeMillis());
            random.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)key, gcmParameterSpec);
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            byte[] byteAES = cipher.doFinal(byteContent);
            byte[] message = new byte[12 + byteAES.length];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(byteAES, 0, message, 12, byteAES.length);
            return Base64.encodeBytes(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String AESDncode(String content) {
        if (StringUtil.isEmptyString(content)) {
            return "";
        }
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance(DEFAULT_PRNG);
            random.setSeed(rule.getBytes());
            keygen.init(128, random);
            SecretKey original_key = keygen.generateKey();
            byte[] raw = original_key.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, key);
            byte[] byte_content = Base64.decode(content);
            byte[] byte_decode = cipher.doFinal(byte_content);
            String AES_decode = new String(byte_decode, "utf-8");
            return AES_decode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String aesDecryptGCM(String content) {
        if (StringUtil.isEmptyString(content)) {
            return "";
        }
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance(DEFAULT_PRNG);
            random.setSeed(rule.getBytes());
            keygen.init(256, random);
            SecretKey k = keygen.generateKey();
            byte[] raw = k.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            byte[] byteContent = Base64.decode(content);
            GCMParameterSpec params = new GCMParameterSpec(128, byteContent, 0, 12);
            cipher.init(2, (Key)key, params);
            byte[] byteDecode = cipher.doFinal(byteContent, 12, byteContent.length - 12);
            return new String(byteDecode, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRealPassWord(String EnCodepassword) {
        if (EnCodepassword.startsWith("_")) {
            return Password.AESDncode(EnCodepassword.substring(1));
        }
        return EnCodepassword;
    }
}

